/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.IteratorWrapper;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class TransitiveClosure
extends SystemFunction {
    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo origin = (NodeInfo)arguments[0].head();
        if (origin == null) {
            return EmptySequence.getInstance();
        }
        FunctionItem step = (FunctionItem)arguments[1].head();
        Sequence[] stepArgs = new Sequence[1];
        HashSet<NodeInfo> startSet = new HashSet<NodeInfo>();
        startSet.add(origin);
        HashSet resultSet = new HashSet();
        while (true) {
            HashSet<NodeInfo> thisSet = new HashSet<NodeInfo>();
            for (NodeInfo node : startSet) {
                NodeInfo resultNode;
                stepArgs[0] = node;
                SequenceIterator stepResult = step.call(context, stepArgs).iterate();
                while ((resultNode = (NodeInfo)stepResult.next()) != null) {
                    if (resultSet.contains(resultNode)) continue;
                    thisSet.add(resultNode);
                }
            }
            if (thisSet.isEmpty()) break;
            resultSet.addAll(thisSet);
            startSet = thisSet;
        }
        IteratorWrapper resultIter = new IteratorWrapper(resultSet.iterator());
        DocumentOrderIterator sortedIter = new DocumentOrderIterator(resultIter, new GlobalOrderComparer());
        return SequenceExtent.from(sortedIter);
    }
}

