/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SubsequenceIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.zeno.ZenoSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;

public class ItemsAt
extends SystemFunction {
    @Override
    public int getSpecialProperties(Expression[] arguments) {
        return arguments[0].getSpecialProperties();
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        Item it;
        int start;
        IntegerRange range;
        GroundedValue input = arguments[0].materialize();
        if (input.getLength() == 0) {
            return EmptySequence.getInstance();
        }
        if (arguments[1] instanceof IntegerRange && (range = (IntegerRange)arguments[1]).getStep() == 1L && Math.abs(range.getStart()) < Integer.MAX_VALUE && Math.abs(range.getEnd()) < Integer.MAX_VALUE && (start = (int)range.getStart()) > 0) {
            return new LazySequence(SubsequenceIterator.make(arguments[0].iterate(), start, (int)range.getEnd()));
        }
        ZenoSequence result = new ZenoSequence();
        SequenceIterator positions = arguments[1].iterate();
        while ((it = positions.next()) != null) {
            int offset = (int)((IntegerValue)it).longValue();
            Item selected = input.itemAt(offset - 1);
            if (selected == null) continue;
            result = result.append(selected);
        }
        return result;
    }
}

