/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import com.saxonica.functions.qt4.URIFunctions;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.RecordTest;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class BuildURI
extends URIFunctions {
    private static final MapType STRING_MAP_TYPE = new MapType(BuiltInAtomicType.STRING, SequenceType.STRING_SEQUENCE);
    public static RecordTest uriStructureRecord = RecordTest.extensible(BuildURI.f("uri", SequenceType.SINGLE_STRING, true), BuildURI.f("scheme", SequenceType.SINGLE_STRING, true), BuildURI.f("authority", SequenceType.SINGLE_STRING, true), BuildURI.f("userinfo", SequenceType.SINGLE_STRING, true), BuildURI.f("host", SequenceType.SINGLE_STRING, true), BuildURI.f("port", SequenceType.SINGLE_STRING, true), BuildURI.f("path", SequenceType.SINGLE_STRING, true), BuildURI.f("query", SequenceType.SINGLE_STRING, true), BuildURI.f("fragment", SequenceType.SINGLE_STRING, true), BuildURI.f("path-segments", SequenceType.STRING_SEQUENCE, true), BuildURI.f("query-parameters", SequenceType.one(STRING_MAP_TYPE), true));

    private static RecordTest.Field f(String name, SequenceType type, boolean optional) {
        return new RecordTest.Field(name, type, optional);
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        MapItem parts = (MapItem)arguments[0].head();
        this.checkOptions(arguments);
        StringBuilder uri = new StringBuilder();
        String scheme = "";
        if (parts.get(SCHEME) != null) {
            scheme = parts.get(SCHEME).getStringValue();
            uri.append(scheme);
            if (nonHierarchicalSchemes.contains(parts.get(SCHEME).getStringValue())) {
                this.hierarchical = false;
            }
        }
        if (parts.get(HIERARCHICAL) != null) {
            this.hierarchical = parts.get(HIERARCHICAL).effectiveBooleanValue();
        }
        if (!"".equals(scheme)) {
            if (this.hierarchical) {
                uri.append("://");
            } else {
                uri.append(":");
            }
        }
        if (parts.get(USERINFO) != null || parts.get(HOST) != null || parts.get(PORT) != null) {
            int pos;
            String port;
            String userinfo = parts.get(USERINFO) == null ? "" : parts.get(USERINFO).getStringValue();
            String host = parts.get(HOST) == null ? "" : parts.get(HOST).getStringValue();
            String string = port = parts.get(PORT) == null ? "" : parts.get(PORT).getStringValue();
            if (!this.allowDeprecatedFeatures && (pos = userinfo.indexOf(":")) >= 0 && pos != userinfo.length() - 1) {
                userinfo = "";
            }
            if (!"".equals(userinfo)) {
                uri.append(userinfo).append("@");
            }
            uri.append(host);
            if (!("".equals(port) || this.omitDefaultPorts && defaultPorts.containsKey(scheme) && port.equals(defaultPorts.get(scheme)))) {
                uri.append(":").append(port);
            }
        } else {
            uri.append(parts.get(AUTHORITY) == null ? "" : parts.get(AUTHORITY).getStringValue());
        }
        if (parts.get(PATH_SEGMENTS) != null) {
            GroundedValue value = parts.get(PATH_SEGMENTS);
            uri.append(this.hierarchical ? this.encodePathSegment(value.itemAt(0)) : value.itemAt(0).getStringValue());
            for (int pos = 1; pos < value.getLength(); ++pos) {
                uri.append(this.pathSeparator);
                uri.append(this.encodePathSegment(value.itemAt(pos)));
            }
        } else if (parts.get(PATH) != null) {
            uri.append(parts.get(PATH).getStringValue());
        }
        if (parts.get(QUERY_PARAMETERS) != null) {
            char sep = '?';
            for (KeyValuePair pair : ((MapItem)parts.get(QUERY_PARAMETERS)).keyValuePairs()) {
                if (pair.key == null && pair.value == null) continue;
                uri.append(sep);
                sep = this.querySeparator;
                if (pair.key != null && !pair.key.getStringValue().isEmpty()) {
                    if (pair.value != null && pair.value.getLength() > 0) {
                        for (int idx = 0; idx < pair.value.getLength(); ++idx) {
                            if (idx > 0) {
                                uri.append(sep);
                            }
                            uri.append(this.encodeQueryPart(pair.key));
                            uri.append("=");
                            uri.append(this.encodeQueryPart(pair.value.itemAt(idx)));
                        }
                        continue;
                    }
                    uri.append(this.encodeQueryPart(pair.key));
                    continue;
                }
                uri.append(this.encodeQueryPart(pair.value));
            }
        } else if (parts.get(QUERY) != null) {
            uri.append("?").append(parts.get(QUERY).getStringValue());
        }
        if (parts.get(FRAGMENT) != null) {
            uri.append("#").append(this.encodeFragmentIdentifier(parts.get(FRAGMENT)));
        }
        return new StringValue(uri.toString());
    }
}

