/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.expr;

import com.saxonica.functions.extfn.ObjectMap;
import java.util.Map;
import java.util.function.Supplier;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LookupExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.hof.CurriedFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class ObjectLookupExpression
extends LookupExpression {
    private FunctionItem reflexiveFunction = null;

    public ObjectLookupExpression(Expression start, Expression step) {
        super(start, step);
    }

    @Override
    public final ItemType getItemType() {
        ItemType objectType = this.getLhsExpression().getItemType();
        if (objectType instanceof JavaExternalObjectType && this.getRhsExpression() instanceof StringLiteral) {
            String fieldName = ((StringLiteral)this.getRhsExpression()).stringify();
            Map<String, FunctionItem> methodMap = this.getConfiguration().makeMethodMap(((JavaExternalObjectType)objectType).getJavaClass(), fieldName);
            FunctionItem f = methodMap.get(fieldName);
            if (f != null) {
                return f.getFunctionItemType();
            }
            return ErrorType.getInstance();
        }
        return AnyItemType.getInstance();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Configuration config = visitor.getConfiguration();
        this.getLhs().typeCheck(visitor, contextInfo);
        this.isSingleContainer = this.getLhsExpression().getCardinality() == 16384;
        this.getRhs().typeCheck(visitor, contextInfo);
        Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(1, "?", 1);
        TypeChecker tc = config.getTypeChecker(false);
        SequenceType req = BuiltInAtomicType.STRING.oneOrMore();
        this.setRhsExpression(tc.staticTypeCheck(this.getRhsExpression(), req, role, visitor));
        boolean bl = this.isSingleEntry = this.getRhsExpression().getCardinality() == 16384;
        if (this.getRhsExpression() instanceof StringLiteral) {
            ItemType containerType = this.getLhsExpression().getItemType();
            JavaExternalObjectType target = (JavaExternalObjectType)containerType;
            Class<?> theClass = target.getJavaClass();
            String methodName = ((StringLiteral)this.getRhsExpression()).stringify();
            if (methodName.equals("this")) {
                return this;
            }
            Map<String, FunctionItem> methodMap = ObjectMap.makeMethodMap(config, theClass, methodName);
            FunctionItem f = methodMap.get(methodName);
            if (f == null) {
                throw new XPathException("No unique method " + methodName + " found in " + theClass, "XPTY0004").asTypeError().withLocation(this.getLocation());
            }
            this.reflexiveFunction = f;
        }
        return this;
    }

    @Override
    public LookupExpression copy(RebindingMap rebindings) {
        ObjectLookupExpression exp = new ObjectLookupExpression(this.getLhsExpression().copy(rebindings), this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, exp);
        exp.isArrayLookup = false;
        exp.isMapLookup = false;
        exp.isSingleEntry = this.isSingleEntry;
        exp.isSingleContainer = this.isSingleContainer;
        return exp;
    }

    @Override
    protected int computeCardinality() {
        if (this.isSingleContainer && this.isSingleEntry) {
            return 24576;
        }
        return 57344;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    public static class ObjectLookupElaborator
    extends PullElaborator {
        @Override
        public PullEvaluator elaborateForPull() {
            ObjectLookupExpression expr = (ObjectLookupExpression)this.getExpression();
            PullEvaluator lhsPull = expr.getLhsExpression().makeElaborator().elaborateForPull();
            if (expr.reflexiveFunction != null) {
                FunctionItem reflexiveFunction = expr.reflexiveFunction;
                int arity = reflexiveFunction.getArity();
                return context -> {
                    SequenceIterator baseIterator = lhsPull.iterate(context);
                    return ItemMappingIterator.map(baseIterator, item -> {
                        Sequence[] boundArgs = new Sequence[arity];
                        boundArgs[0] = item;
                        return new CurriedFunction(reflexiveFunction, boundArgs);
                    });
                };
            }
            return context -> {
                GroundedValue rhs;
                PullEvaluator rhsPull = expr.getRhsExpression().makeElaborator().elaborateForPull();
                SequenceIterator baseIterator = lhsPull.iterate(context);
                try {
                    rhs = SequenceTool.toGroundedValue(rhsPull.iterate(context));
                }
                catch (UncheckedXPathException e) {
                    throw e.getXPathException();
                }
                String key = rhs.getUnicodeStringValue().toString();
                Configuration config = context.getConfiguration();
                return ItemMappingIterator.map(baseIterator, item -> (Item)config.externalObjectAsMap((ObjectValue)item, key).get((StringValue)rhs));
            };
        }
    }
}

