/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.validate.SchemaElementTest;
import java.util.Optional;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.SchemaNodeTest;
import net.sf.saxon.tree.tiny.NodeVectorTree;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntPredicateProxy;
import net.sf.saxon.z.IntSet;
import net.sf.saxon.z.IntSetPredicate;
import net.sf.saxon.z.IntSingletonSet;

public class SchemaAttributeTest
extends NodeTest
implements SchemaNodeTest {
    private final Configuration config;
    private final AttributeDecl declaration;
    private final SimpleType requiredType;

    public SchemaAttributeTest(AttributeDecl attributeDecl) throws MissingComponentException {
        this.config = attributeDecl.getConfiguration();
        this.declaration = attributeDecl;
        this.requiredType = attributeDecl.getType();
    }

    @Override
    public StructuredQName getNodeName() {
        return this.declaration.getComponentName();
    }

    @Override
    public UType getUType() {
        return UType.ATTRIBUTE;
    }

    @Override
    public boolean matches(int nodeKind, NodeName name, SchemaType annotation) {
        if (nodeKind != 2) {
            return false;
        }
        if (name.hasFingerprint() ? name.getFingerprint() != this.declaration.getFingerprint() : !name.hasURI(this.declaration.getTargetNamespace()) || !name.getLocalPart().equals(this.declaration.getName())) {
            return false;
        }
        return SchemaElementTest.matchesAnnotation(this.requiredType, annotation, this.config.getTypeHierarchy());
    }

    @Override
    public IntPredicateProxy getMatcher(NodeVectorTree tree) {
        return IntSetPredicate.ALWAYS_FALSE;
    }

    @Override
    public boolean test(NodeInfo node) {
        if (node.hasFingerprint()) {
            return node.getNodeKind() == 2 && node.getFingerprint() == this.declaration.getFingerprint() && SchemaElementTest.matchesAnnotation(this.requiredType, node.getSchemaType(), this.config.getTypeHierarchy());
        }
        return node.getNodeKind() == 2 && node.getNamespaceUri().equals(this.declaration.getTargetNamespace()) && node.getLocalPart().equals(this.declaration.getName()) && SchemaElementTest.matchesAnnotation(this.requiredType, node.getSchemaType(), this.config.getTypeHierarchy());
    }

    @Override
    public final double getDefaultPriority() {
        return 0.0;
    }

    @Override
    public int getPrimitiveType() {
        return 2;
    }

    @Override
    public Optional<IntSet> getRequiredNodeNames() {
        return Optional.of(new IntSingletonSet(this.declaration.getFingerprint()));
    }

    @Override
    public SchemaType getContentType() {
        return this.requiredType;
    }

    public String toString() {
        return "schema-attribute(" + this.declaration.getComponentName().getEQName() + ')';
    }

    public int hashCode() {
        return this.declaration.getFingerprint();
    }

    public boolean equals(Object other) {
        return other instanceof SchemaAttributeTest && ((SchemaAttributeTest)other).declaration == this.declaration;
    }

    @Override
    public String getBasicAlphaCode() {
        return "NAS";
    }

    @Override
    public Optional<String> explainMismatch(Item item, TypeHierarchy th) {
        Optional<String> explanation = super.explainMismatch(item, th);
        if (explanation.isPresent()) {
            return explanation;
        }
        NodeInfo node = (NodeInfo)item;
        StructuredQName name = new StructuredQName("", node.getNamespaceUri(), node.getLocalPart());
        if (!this.declaration.getComponentName().equals(name)) {
            return Optional.of("The supplied attribute has the wrong name");
        }
        if (!SchemaElementTest.matchesAnnotation(this.requiredType, node.getSchemaType(), this.config.getTypeHierarchy())) {
            if (node.getSchemaType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
                return Optional.of("The supplied attribute has not been schema-validated");
            }
            return Optional.of("The supplied attribute has a non-matching type annotation (" + node.getSchemaType().getDisplayName() + ")");
        }
        return Optional.empty();
    }
}

