/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.SingleAtomicIterator;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class CompactStringValue
implements AtomicSequence {
    private final char[] value;

    public CompactStringValue(UnicodeString content) {
        this.value = content.toString().toCharArray();
    }

    public CompactStringValue(String content) {
        this.value = content.toCharArray();
    }

    @Override
    public StringValue head() {
        return new StringValue(new String(this.value));
    }

    @Override
    public AtomicIterator iterate() {
        return SingleAtomicIterator.makeIterator(this.head());
    }

    @Override
    public AtomicValue itemAt(int n) {
        return n == 0 ? this.head() : null;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public UnicodeString getCanonicalLexicalRepresentation() {
        return this.getUnicodeStringValue();
    }

    public boolean equals(Object obj) {
        return obj instanceof CompactStringValue && Arrays.equals(this.value, ((CompactStringValue)obj).value);
    }

    public int hashCode() {
        int h = 0;
        for (char cp : this.value) {
            h = 31 * h + cp;
        }
        return h;
    }

    @Override
    public UnicodeString getUnicodeStringValue() {
        return StringView.of(new String(this.value)).tidy();
    }

    @Override
    public String getStringValue() throws XPathException {
        return new String(this.value);
    }

    @Override
    public GroundedValue subsequence(int start, int length) {
        return this.head().subsequence(start, length);
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return this.value.length != 0;
    }

    @Override
    public GroundedValue reduce() {
        return this.head();
    }

    @Override
    public Iterator<AtomicValue> iterator() {
        return new MonoIterator<AtomicValue>(this.head());
    }

    public String toString() {
        return new String(this.value);
    }

    public char[] getChars() {
        return this.value;
    }
}

