/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.DeleteAction;
import com.saxonica.ee.update.InsertAction;
import com.saxonica.ee.update.InsertAttributeAction;
import com.saxonica.ee.update.PendingUpdateAction;
import com.saxonica.ee.update.PutAction;
import com.saxonica.ee.update.RenameAction;
import com.saxonica.ee.update.ReplaceAttributeAction;
import com.saxonica.ee.update.ReplaceNodeAction;
import com.saxonica.ee.update.ReplaceValueAction;
import com.saxonica.ee.validate.InSituValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.MutableDocumentInfo;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.z.IntHashMap;

public class PendingUpdateListImpl
implements PendingUpdateList {
    private final IntHashMap<List<PendingUpdateAction>> lists = new IntHashMap(7);
    private final Set<MutableNodeInfo> affectedTrees = new HashSet<MutableNodeInfo>();
    private final Set<NodeInfo> renamedNodes = new HashSet<NodeInfo>();
    private final Set<NodeInfo> replacedNodes = new HashSet<NodeInfo>();
    private final Set<NodeInfo> replacedValueNodes = new HashSet<NodeInfo>();
    private final Map<NodeInfo, NamespaceMap> newNamespaceBindings = new HashMap<NodeInfo, NamespaceMap>();
    private final Set<String> putURIs = new HashSet<String>();
    private final Map<NodeInfo, List<PendingUpdateAction>> attributeActions = new HashMap<NodeInfo, List<PendingUpdateAction>>();
    private final Set<PackageData> packages = new HashSet<PackageData>();

    public void add(PendingUpdateAction action) throws XPathException {
        int phase = action.getApplyPhase();
        if (this.lists.get(phase) == null) {
            this.lists.put(phase, new ArrayList(4));
        }
        if (action instanceof RenameAction) {
            boolean added = this.renamedNodes.add(action.getTargetNode());
            if (!added) {
                throw this.conflict("rename", "XUDY0015", action.getTargetNode());
            }
            NodeName newName = ((RenameAction)action).getNewName();
            NamespaceBinding nsCode = new NamespaceBinding(newName.getPrefix(), newName.getNamespaceUri());
            NodeInfo targetNode = action.getTargetNode();
            int nodeKind = targetNode.getNodeKind();
            if (nodeKind == 2) {
                NodeInfo parent = targetNode.getParent();
                this.addAttributeAction(parent, action);
                targetNode = parent;
            } else if (nodeKind == 7) {
                targetNode = null;
            }
            this.checkForNamespaceConflict(targetNode, nodeKind, nsCode, action);
            if (nodeKind != 2) {
                this.lists.get(phase).add(action);
            }
        } else if (action instanceof ReplaceNodeAction) {
            boolean added = this.replacedNodes.add(action.getTargetNode());
            if (!added) {
                throw this.conflict("replace", "XUDY0016", action.getTargetNode());
            }
            this.lists.get(phase).add(action);
        } else if (action instanceof ReplaceAttributeAction) {
            NodeInfo element = action.getTargetNode();
            NodeInfo oldAtt = ((ReplaceAttributeAction)action).getOldAttribute();
            boolean added = this.replacedNodes.add(oldAtt);
            if (!added) {
                throw this.conflict("replace", "XUDY0016", oldAtt);
            }
            this.addAttributeAction(element, action);
            SameNameTest test = new SameNameTest(oldAtt);
            AttributeMap newAtts = ((ReplaceAttributeAction)action).getNewAttributes();
            for (AttributeInfo att : newAtts) {
                if (test.matches(att.getNodeName().getStructuredQName())) continue;
                NamespaceBinding nsBinding = new NamespaceBinding(att.getNodeName().getPrefix(), att.getNodeName().getNamespaceUri());
                this.checkForNamespaceConflict(element, 2, nsBinding, action);
            }
        } else if (action instanceof ReplaceValueAction) {
            boolean added = this.replacedValueNodes.add(action.getTargetNode());
            if (!added) {
                throw this.conflict("replace the value of", "XUDY0017", action.getTargetNode());
            }
            this.lists.get(phase).add(action);
        } else if (action instanceof InsertAttributeAction) {
            NodeName name = ((InsertAttributeAction)action).getAttributeName();
            NamespaceBinding nsCode = new NamespaceBinding(name.getPrefix(), name.getNamespaceUri());
            NodeInfo targetNode = action.getTargetNode();
            this.addAttributeAction(targetNode, action);
            this.checkForNamespaceConflict(targetNode, 2, nsCode, action);
        } else if (action instanceof InsertAction) {
            this.lists.get(phase).add(action);
        } else if (action instanceof DeleteAction) {
            NodeInfo targetNode = action.getTargetNode();
            if (targetNode.getNodeKind() == 2) {
                NodeInfo parent = targetNode.getParent();
                if (parent != null) {
                    this.addAttributeAction(parent, action);
                }
            } else {
                this.lists.get(phase).add(action);
            }
        } else if (action instanceof PutAction) {
            this.lists.get(phase).add(action);
        }
        this.packages.add(action.getOriginator().getPackageData());
    }

    private void addAttributeAction(NodeInfo element, PendingUpdateAction action) {
        List actions = this.attributeActions.computeIfAbsent(element, k -> new ArrayList(2));
        actions.add(action);
        this.packages.add(action.getOriginator().getPackageData());
    }

    @Override
    public void addPutAction(NodeInfo node, String uri, Expression originator) throws XPathException {
        if (!this.putURIs.add(uri)) {
            throw new XPathException("Cannot put() two documents to the same URI (" + uri + ")").withErrorCode("XUDY0031").withLocation(originator.getLocation());
        }
        PutAction action = new PutAction(node, uri);
        action.setOriginator(originator);
        this.add(action);
    }

    private void checkForNamespaceConflict(NodeInfo targetNode, int nodeKind, NamespaceBinding nsCode, PendingUpdateAction action) throws XPathException {
        if (!(targetNode == null || nodeKind != 1 && nsCode.getPrefix().isEmpty())) {
            String prefix = nsCode.getPrefix();
            NamespaceUri uri = nsCode.getNamespaceUri();
            NamespaceMap map = targetNode.getAllNamespaces();
            NamespaceUri existingURI = map.getNamespaceUri(prefix);
            if (existingURI != null && !existingURI.isEmpty() && !existingURI.equals(uri)) {
                throw new XPathException("An update action creates a namespace binding that conflicts with an existing namespace binding on the same target element").withErrorCode("XUDY0023").withLocation(action.getOriginator().getLocation());
            }
            NamespaceMap nsmap = this.newNamespaceBindings.get(targetNode);
            if (nsmap == null) {
                nsmap = NamespaceMap.of(prefix, uri);
                this.newNamespaceBindings.put(targetNode, nsmap);
            } else {
                NamespaceUri existingUri = nsmap.getNamespaceUri(prefix);
                if (existingUri == null) {
                    nsmap = nsmap.put(prefix, uri);
                    this.newNamespaceBindings.put(targetNode, nsmap);
                } else if (!existingUri.equals(uri)) {
                    throw new XPathException("Two updates create conflicting namespace bindings on the same target node").withErrorCode("XUDY0024").withLocation(action.getOriginator().getLocation());
                }
            }
        }
    }

    private XPathException conflict(String action, String errorCode, NodeInfo node) {
        int kind = node.getNodeKind();
        String kindStr = NodeKindTest.describe(kind);
        if (kind == 1) {
            kindStr = Err.wrap(node.getDisplayName(), 1) + " " + kindStr;
        } else if (kind == 2) {
            kindStr = Err.wrap(node.getDisplayName(), 2) + " " + kindStr;
        }
        String msg = "Update conflict: two attempts to " + action + " the same " + kindStr + " node";
        if (node.getLineNumber() != -1) {
            msg = msg + ". Node at line " + node.getLineNumber() + " of " + node.getSystemId();
        }
        return new XPathException(msg, errorCode);
    }

    private void finalCheck() throws XPathException {
        for (Map.Entry<NodeInfo, List<PendingUpdateAction>> e : this.attributeActions.entrySet()) {
            MutableNodeInfo element = (MutableNodeInfo)e.getKey();
            this.checkAttributeActions(element, e.getValue());
            this.affectedTrees.add((MutableNodeInfo)element.getRoot());
        }
    }

    @Override
    public synchronized void apply(XPathContext context, int validationMode) throws XPathException {
        this.finalCheck();
        for (int phase = 0; phase < 6; ++phase) {
            Collection actionList = this.lists.get(phase);
            if (actionList == null) continue;
            for (Object action : actionList) {
                ((PendingUpdateAction)action).apply(context, this.affectedTrees);
            }
        }
        for (Map.Entry<NodeInfo, List<PendingUpdateAction>> e : this.attributeActions.entrySet()) {
            MutableNodeInfo element = (MutableNodeInfo)e.getKey();
            if (element.isDeleted()) continue;
            this.applyAttributeActions(element, e.getValue());
            this.affectedTrees.add((MutableNodeInfo)element.getRoot());
        }
        Collection list = this.lists.get(6);
        if (list != null) {
            for (PendingUpdateAction action : list) {
                action.apply(context, this.affectedTrees);
            }
        }
        for (MutableNodeInfo root : this.affectedTrees) {
            if (!(root instanceof MutableDocumentInfo)) continue;
            for (PackageData packageData : this.packages) {
                packageData.getKeyManager().clearDocumentIndexes(root.getTreeInfo());
            }
            ((MutableDocumentInfo)((Object)root)).resetIndexes();
        }
        if (validationMode == 1 || validationMode == 2) {
            for (MutableNodeInfo root : this.affectedTrees) {
                InSituValidator validator = new InSituValidator(root, validationMode);
                validator.validate();
            }
        }
    }

    private void checkAttributeActions(MutableNodeInfo element, List<PendingUpdateAction> actions) throws XPathException {
        NodeInfo att;
        HashMap<NodeName, Integer> names = new HashMap<NodeName, Integer>();
        AxisIterator attributes = element.iterateAxis(2);
        while ((att = attributes.next()) != null) {
            names.put(NameOfNode.makeName(att), 1);
        }
        for (PendingUpdateAction action : actions) {
            NodeName nameOfNode;
            if (action instanceof DeleteAction) {
                nameOfNode = NameOfNode.makeName(action.getTargetNode());
                int count = names.getOrDefault(nameOfNode, 0);
                if (count <= 0) continue;
                names.put(nameOfNode, count - 1);
                continue;
            }
            if (action instanceof RenameAction) {
                nameOfNode = NameOfNode.makeName(action.getTargetNode());
                int count = names.getOrDefault(nameOfNode, 0);
                if (count > 0) {
                    names.put(nameOfNode, count - 1);
                }
                nameOfNode = ((RenameAction)action).getNewName();
                count = names.getOrDefault(nameOfNode, 0);
                names.put(nameOfNode, count + 1);
                continue;
            }
            if (action instanceof ReplaceAttributeAction) {
                NodeInfo target = ((ReplaceAttributeAction)action).getOldAttribute();
                NodeName nameOfNode2 = NameOfNode.makeName(target);
                int count = names.getOrDefault(nameOfNode2, 0);
                if (count > 0) {
                    names.put(nameOfNode2, count - 1);
                }
                AttributeMap newNodes = ((ReplaceAttributeAction)action).getNewAttributes();
                for (AttributeInfo a : newNodes) {
                    nameOfNode2 = a.getNodeName();
                    count = names.getOrDefault(nameOfNode2, 0);
                    names.put(nameOfNode2, count + 1);
                }
                continue;
            }
            if (!(action instanceof InsertAttributeAction)) continue;
            nameOfNode = ((InsertAttributeAction)action).getAttributeName();
            int count = names.getOrDefault(nameOfNode, 0);
            names.put(nameOfNode, count + 1);
        }
        for (NodeName nn : names.keySet()) {
            int count = (Integer)names.get(nn);
            if (count <= 1) continue;
            throw new XPathException("After applying all updates, the element at " + Navigator.getPath(element) + " would have " + (count == 2 ? "two" : Integer.valueOf(count)) + " attributes named " + nn.getStructuredQName().getEQName(), "XUDY0021");
        }
    }

    private void applyAttributeActions(MutableNodeInfo element, List<PendingUpdateAction> actions) {
        for (PendingUpdateAction action : actions) {
            if (!(action instanceof DeleteAction)) continue;
            ((MutableNodeInfo)action.getTargetNode()).delete();
        }
        for (PendingUpdateAction action : actions) {
            if (!(action instanceof ReplaceAttributeAction)) continue;
            NodeInfo nodeInfo = ((ReplaceAttributeAction)action).getOldAttribute();
            ((MutableNodeInfo)nodeInfo).delete();
        }
        HashMap<MutableNodeInfo, NodeName> pendingRenames = null;
        for (PendingUpdateAction pendingUpdateAction : actions) {
            if (!(pendingUpdateAction instanceof RenameAction)) continue;
            NodeName nc = ((RenameAction)pendingUpdateAction).getNewName();
            FingerprintedQName newName = null;
            if (element.getAttributeValue(nc.getNamespaceUri(), nc.getLocalPart()) != null) {
                String candidate;
                int n = 1;
                while (true) {
                    candidate = nc.getLocalPart() + n;
                    if (element.getAttributeValue(nc.getNamespaceUri(), candidate) == null) break;
                    ++n;
                }
                newName = new FingerprintedQName(nc.getPrefix(), nc.getNamespaceUri(), candidate);
                if (pendingRenames == null) {
                    pendingRenames = new HashMap<MutableNodeInfo, NodeName>();
                }
                pendingRenames.put((MutableNodeInfo)pendingUpdateAction.getTargetNode(), nc);
                nc = newName;
            }
            ((MutableNodeInfo)pendingUpdateAction.getTargetNode()).rename(nc, ((RenameAction)pendingUpdateAction).isInheritNamespaces());
        }
        if (pendingRenames != null) {
            for (Map.Entry entry : pendingRenames.entrySet()) {
                ((MutableNodeInfo)entry.getKey()).rename((NodeName)entry.getValue(), true);
            }
        }
        for (PendingUpdateAction pendingUpdateAction : actions) {
            if (!(pendingUpdateAction instanceof ReplaceAttributeAction)) continue;
            AttributeMap content = ((ReplaceAttributeAction)pendingUpdateAction).getNewAttributes();
            for (AttributeInfo a : content) {
                element.addAttribute(a.getNodeName(), a.getType(), a.getValue(), 0, ((ReplaceAttributeAction)pendingUpdateAction).isInheritNamespaces());
            }
        }
        for (PendingUpdateAction pendingUpdateAction : actions) {
            if (!(pendingUpdateAction instanceof InsertAttributeAction)) continue;
            InsertAttributeAction a = (InsertAttributeAction)pendingUpdateAction;
            element.addAttribute(a.getAttributeName(), a.getNewTypeCode(), a.getNewStringValue(), 0, ((InsertAttributeAction)pendingUpdateAction).isInheritNamespaces());
        }
        element.removeTypeAnnotation();
    }

    @Override
    public Set<MutableNodeInfo> getAffectedTrees() {
        return this.affectedTrees;
    }
}

