/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import java.util.HashSet;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class CopyModifyExpression
extends Expression {
    private final int validationMode;
    private final Operand updateOp;
    private final Operand returnOp;
    private final Operand copyBindingsOp;

    public CopyModifyExpression(Expression updateExp, Expression returnExp, int validationMode) {
        this.updateOp = new Operand(this, updateExp, OperandRole.SINGLE_ATOMIC);
        this.returnOp = new Operand(this, returnExp, OperandRole.SAME_FOCUS_ACTION);
        this.copyBindingsOp = new Operand(this, returnExp, OperandRole.SINGLE_ATOMIC);
        this.validationMode = validationMode;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.updateOp, this.returnOp, this.copyBindingsOp);
    }

    public Expression getUpdateExp() {
        return this.updateOp.getChildExpression();
    }

    public void setUpdateExp(Expression updateExp) {
        this.updateOp.setChildExpression(updateExp);
    }

    public Expression getReturnExp() {
        return this.returnOp.getChildExpression();
    }

    public void setReturnExp(Expression returnExp) {
        this.returnOp.setChildExpression(returnExp);
    }

    public Expression getCopyBindings() {
        return this.copyBindingsOp.getChildExpression();
    }

    public void setCopyBindings(Expression copyBindings) {
        this.copyBindingsOp.setChildExpression(copyBindings);
    }

    @Override
    protected int computeCardinality() {
        return this.getReturnExp().getCardinality();
    }

    @Override
    public ItemType getItemType() {
        return this.getReturnExp().getItemType();
    }

    @Override
    public boolean isUpdatingExpression() {
        return false;
    }

    @Override
    public String getExpressionName() {
        return "copy-modify";
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        if (ExpressionTool.isNotAllowedInUpdatingContext(this.getUpdateExp())) {
            throw new XPathException("Expression in modify clause must be an updating expression (or () or error())", "XUST0002");
        }
        if (this.getReturnExp().isUpdatingExpression()) {
            throw new XPathException("Expression in return clause must not be an updating expression", "XUST0001");
        }
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        CopyModifyExpression exp = new CopyModifyExpression(this.getUpdateExp().copy(rebindings), this.getReturnExp().copy(rebindings), this.validationMode);
        ExpressionTool.copyLocationInfo(this, exp);
        exp.setCopyBindings(this.getCopyBindings().copy(rebindings));
        return exp;
    }

    @Override
    public int getImplementationMethod() {
        return 7;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("copyModify", this);
        out.emitAttribute("val", Validation.describe(this.validationMode));
        out.setChildRole("bindings");
        this.getCopyBindings().export(out);
        out.setChildRole("modify");
        this.getUpdateExp().export(out);
        out.setChildRole("return");
        this.getReturnExp().export(out);
        out.endElement();
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        CopyModifyExpression.dispatchTailCall(this.makeElaborator().elaborateForPush().processLeavingTail(output, context));
    }

    private void doUpdates(XPathContext context) throws XPathException {
        PendingUpdateList pul = context.getConfiguration().newPendingUpdateList();
        this.getUpdateExp().makeElaborator().elaborateForUpdate().registerUpdates(context, pul);
        pul.apply(context, this.validationMode);
        HashSet copiedNodes = new HashSet();
        SequenceTool.supply(this.getCopyBindings().iterate(context), node -> copiedNodes.add((NodeInfo)node));
        if (!copiedNodes.containsAll(pul.getAffectedTrees())) {
            throw new XPathException("A node that was not created during the copy phase has been updated during the modify phase").withErrorCode("XUDY0014").withLocation(this.getLocation()).withXPathContext(context);
        }
    }

    @Override
    public Elaborator getElaborator() {
        return new CopyModifyExpressionElaborator();
    }

    private static class CopyModifyExpressionElaborator
    extends PushElaborator {
        private CopyModifyExpressionElaborator() {
        }

        @Override
        public PushEvaluator elaborateForPush() {
            CopyModifyExpression expr = (CopyModifyExpression)this.getExpression();
            PushEvaluator returnEval = expr.getReturnExp().makeElaborator().elaborateForPush();
            return (output, context) -> {
                expr.doUpdates(context);
                return returnEval.processLeavingTail(output, context);
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            CopyModifyExpression expr = (CopyModifyExpression)this.getExpression();
            ItemEvaluator returnEval = expr.getReturnExp().makeElaborator().elaborateForItem();
            return context -> {
                expr.doUpdates(context);
                return returnEval.eval(context);
            };
        }

        @Override
        public PullEvaluator elaborateForPull() {
            CopyModifyExpression expr = (CopyModifyExpression)this.getExpression();
            PullEvaluator returnEval = expr.getReturnExp().makeElaborator().elaborateForPull();
            return context -> {
                expr.doUpdates(context);
                return returnEval.iterate(context);
            };
        }
    }
}

