/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.stream.ComponentInversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import com.saxonica.ee.trans.TemplateRuleInitializer;
import java.util.List;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.UType;

public class TemplateRuleEE
extends TemplateRule {
    private boolean declaredStreamable;
    private TemplateRuleInitializer initializer = null;
    private ComponentInversion inversion;

    @Override
    public void setDeclaredStreamable(boolean streamable) {
        this.declaredStreamable = streamable;
    }

    @Override
    public boolean isDeclaredStreamable() {
        return this.declaredStreamable;
    }

    public void setInitializer(TemplateRuleInitializer initializer) {
        this.initializer = initializer;
    }

    public TemplateRuleInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public void prepareInitializer(Compilation compilation, ComponentDeclaration decl) {
        if (this.getInitializer() == null) {
            this.setInitializer(new TemplateRuleInitializer(compilation, decl, this));
        }
    }

    @Override
    public synchronized void initialize() throws XPathException {
        assert (this.body != null || this.initializer != null);
        if (this.initializer != null) {
            this.initializer.init();
            this.initializer = null;
        }
    }

    public boolean isActuallyStreamable(List<String> reasons) {
        if (this.matchPattern == null) {
            if (reasons != null) {
                reasons.add("There is no match pattern");
            }
            return false;
        }
        if (!this.matchPattern.isMotionless()) {
            if (reasons != null) {
                reasons.add("The match pattern is not motionless");
            }
            return false;
        }
        if (this.body == null) {
            if (reasons != null) {
                reasons.add("The template has no body");
            }
            return false;
        }
        ContextItemStaticInfoEE info = (ContextItemStaticInfoEE)this.body.getConfiguration().makeContextItemStaticInfo(this.matchPattern.getItemType(), false);
        if (this.matchPattern.getItemType().getUType().overlaps(UType.ANY_NODE)) {
            info.setContextPostureStriding();
        } else {
            info.setContextPostureGrounded();
        }
        PostureAndSweep s = Streamability.getStreamability(this.body, info, reasons);
        if (s.getPosture() == Posture.GROUNDED) {
            return true;
        }
        reasons.add("The result of the template rule can contain streamed nodes");
        return false;
    }

    public void makeInversion() throws XPathException {
        if (this.inversion == null) {
            ComponentInversion inv = new ComponentInversion(this.getBody());
            inv.setStackFrame(this.getStackFrameMap());
            inv.invert(this.isActuallyStreamable(null));
            this.inversion = inv;
        }
    }

    public ComponentInversion getInversion() throws XPathException {
        if (this.inversion == null) {
            this.makeInversion();
        }
        return this.inversion;
    }
}

