/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.AtomicItemFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class GeneralComparisonInequalityFeed
extends AtomicItemFeed {
    private WatchManager watchManager;
    private final StringCollator collator;
    private AtomicMatchKey firstStreamed = null;
    private StringValue firstUntypedStreamed = null;
    private boolean done = false;
    private boolean closed = false;
    private final Expression pullOperand;
    private final int implicitTimezone;

    public GeneralComparisonInequalityFeed(WatchManager watchManager, Expression expr, int pushedArg, ItemFeed result, XPathContext context) {
        super(expr, result, context);
        this.watchManager = watchManager;
        GeneralComparison gc = (GeneralComparison)this.getExpression();
        this.collator = gc.getStringCollator();
        this.pullOperand = pushedArg == 0 ? gc.getRhsExpression() : gc.getLhsExpression();
        this.implicitTimezone = context.getImplicitTimezone();
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.done = false;
        this.firstStreamed = null;
        this.firstUntypedStreamed = null;
    }

    @Override
    public void append(Item item) throws XPathException {
        if (!this.done) {
            XPathContext context = this.getContext();
            ConversionRules rules = context.getConfiguration().getConversionRules();
            AtomicValue next = (AtomicValue)item;
            AtomicMatchKey ks1 = next.getXPathMatchKey(this.collator, this.implicitTimezone);
            BuiltInAtomicType matchType = next instanceof NumericValue ? BuiltInAtomicType.DOUBLE : ((AtomicValue)item).getPrimitiveType();
            if (this.firstStreamed == null) {
                AtomicValue val;
                this.firstStreamed = ks1;
                if (next.isUntypedAtomic()) {
                    this.firstUntypedStreamed = (StringValue)next;
                }
                SequenceIterator comparand = this.pullOperand.iterate(context);
                boolean existsUnstreamed = false;
                while ((val = (AtomicValue)comparand.next()) != null) {
                    AtomicValue cval;
                    AtomicMatchKey ks2;
                    existsUnstreamed = true;
                    if (!Type.isGenerallyComparable(matchType, val.getPrimitiveType(), false)) {
                        throw new XPathException("Comparison between " + matchType + " and " + val.getPrimitiveType() + " is not allowed", "XPTY0004", this.getExpression().getLocation());
                    }
                    if (val.isUntypedAtomic()) {
                        AtomicValue cval2 = Converter.convert(this.firstUntypedStreamed, matchType, rules);
                        AtomicMatchKey ku1 = cval2.getXPathMatchKey(this.collator, this.implicitTimezone);
                        if (ku1.equals(ks1)) continue;
                        this.reportDone(true);
                        break;
                    }
                    AtomicMatchKey ku2 = val.getXPathMatchKey(this.collator, this.implicitTimezone);
                    if (!ks1.equals(ku2)) {
                        this.reportDone(true);
                        break;
                    }
                    if (this.firstUntypedStreamed == null || ku2 == (ks2 = (cval = Converter.convert(this.firstUntypedStreamed, matchType, rules)).getXPathMatchKey(this.collator, this.implicitTimezone))) continue;
                    this.reportDone(true);
                    break;
                }
                if (!existsUnstreamed) {
                    this.reportDone(false);
                }
            } else if (ks1 != this.firstStreamed) {
                this.reportDone(true);
            }
        }
    }

    private void reportDone(boolean result) throws XPathException {
        Outputter out = this.getNextOutputter();
        this.done = true;
        out.append(BooleanValue.get(result));
        if (this.watchManager.allowsEarlyExit()) {
            this.closed = true;
            out.close();
            this.getTerminator().terminate();
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.done) {
            this.getNextOutputter().append(BooleanValue.FALSE);
        }
        if (!this.closed) {
            super.close();
            this.firstStreamed = null;
            this.firstUntypedStreamed = null;
        }
    }
}

