/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ItemFeed;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;

public class BufferingForEachExpressionFeed
extends ItemFeed {
    Expression action;
    XPathContext localContext;
    private final List<Item> inputValue = new ArrayList<Item>(4);

    public BufferingForEachExpressionFeed(ForEach expr, ItemFeed result, XPathContext context) {
        super(expr, result, context);
        this.action = expr.getActionExpression();
        this.localContext = context;
    }

    @Override
    public void append(Item item) throws XPathException {
        this.inputValue.add(item);
    }

    @Override
    public void close() throws XPathException {
        XPathContextMinor c2 = this.localContext.newMinorContext();
        c2.trackFocus(new ListIterator.Of<Item>(this.inputValue));
        ContextMappingIterator mappingIter = new ContextMappingIterator(c1 -> this.action.iterate(c1), c2);
        Outputter out = this.getNextOutputter();
        BufferingForEachExpressionFeed.processItems(mappingIter, out);
        out.close();
    }
}

