/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;

public class LiteralAdjunct
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
    }

    @Override
    public Pattern toStreamingPattern(Configuration config) {
        Literal exp = (Literal)this.getExpression();
        if (Literal.isEmptySequence(exp)) {
            return new NodeTestPattern(ErrorType.getInstance());
        }
        return super.toStreamingPattern(config);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new LiteralItemFeed(this.getExpression(), out, context);
    }

    public class LiteralItemFeed
    extends ItemFeed {
        LiteralItemFeed(Expression exp, ItemFeed out, XPathContext context) {
            super(exp, out, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            Outputter out = this.getNextOutputter();
            if (!Literal.isEmptySequence(this.getExpression())) {
                GroundedValue value = ((Literal)this.getExpression()).getGroundedValue();
                if (value instanceof Item) {
                    out.append((Item)value);
                } else {
                    SequenceIterator iter = value.iterate();
                    LiteralItemFeed.processItems(iter, out);
                }
            }
        }

        @Override
        public void append(Item item) throws XPathException {
        }
    }
}

