/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.SequenceCollector;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class LetExpressionAdjunct
extends StreamingAdjunct {
    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Expression select = ((LetExpression)this.getExpression()).getSequence();
        if (Streamability.getSweep(select) == Sweep.CONSUMING) {
            Inversion ie = Inversion.invertExpression(select, forGrouping);
            Inversion route = ie.copy();
            Inversion.PushAction letAction = new Inversion.PushAction();
            letAction.feedMaker = new FeedMakerForConsumingSelect((LetExpression)this.getExpression());
            letAction.pushMethod = 16;
            letAction.streamingChildSequence = 0;
            route.prepend(letAction);
            return CSharp.methodRef(route::getWatch);
        }
        StreamingAdjunct sa = StreamingAdjunct.makeStreamingAdjunct(this.getConfiguration(), this.getExpression());
        return sa.getWatchMaker(forGrouping);
    }

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        LetExpression expr = (LetExpression)this.getExpression();
        if (expr.getSequence() instanceof ContextItemExpression && contextInfo.getContextItemPosture() != Posture.GROUNDED && !this.hasNonInspectionUsage(expr, expr.getAction())) {
            expr.getSequenceOp().setUsage(OperandUsage.INSPECTION);
        }
        return super.computeStreamability(contextInfo, reasons);
    }

    private boolean hasNonInspectionUsage(LetExpression binding, Expression child) {
        for (Operand o : child.operands()) {
            if (o.getChildExpression() instanceof VariableReference) {
                if (((VariableReference)o.getChildExpression()).getBinding() == binding && o.getUsage() != OperandUsage.INSPECTION) {
                    return true;
                }
                if (!this.hasNonInspectionUsage(binding, o.getChildExpression())) continue;
                return true;
            }
            if (!this.hasNonInspectionUsage(binding, o.getChildExpression())) continue;
            return true;
        }
        return false;
    }

    private static class ItemFeedForConsumingSelect
    extends ItemFeed {
        private SequenceCollector collector;
        private ComplexContentOutputter cco;

        public ItemFeedForConsumingSelect(Expression letExpr, ItemFeed out, XPathContext context) {
            super(letExpr, out, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.collector = new SequenceCollector(this.getResultFeed().getPipelineConfiguration());
            this.cco = new ComplexContentOutputter(this.collector);
        }

        @Override
        public void startDocument(int properties) throws XPathException {
            this.cco.startDocument(properties);
        }

        @Override
        public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
            this.cco.startElement(elemName, typeCode, location, properties);
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
            this.cco.startElement(elemName, type, attributes, namespaces, location, properties);
        }

        @Override
        public void endDocument() throws XPathException {
            this.cco.endDocument();
        }

        @Override
        public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
            this.cco.namespace(prefix, namespaceUri, properties);
        }

        @Override
        public void attribute(NodeName attName, SimpleType typeCode, String value, Location location, int properties) throws XPathException {
            this.cco.attribute(attName, typeCode, value, location, properties);
        }

        @Override
        public void endElement() throws XPathException {
            this.cco.endElement();
        }

        @Override
        public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
            this.cco.characters(chars, location, properties);
        }

        @Override
        public void processingInstruction(String name, UnicodeString data, Location location, int properties) throws XPathException {
            this.cco.processingInstruction(name, data, location, properties);
        }

        @Override
        public void comment(UnicodeString content, Location location, int properties) throws XPathException {
            this.cco.comment(content, location, properties);
        }

        @Override
        public void append(Item item) throws XPathException {
            this.cco.append(item);
        }

        @Override
        public void close() throws XPathException {
            LetExpression letExpr = (LetExpression)this.getExpression();
            GroundedValue value = this.collector.getSequence();
            XPathContext context = this.getContext();
            context.setLocalVariable(letExpr.getLocalSlotNumber(), value);
            TailCall tc = letExpr.getAction().makeElaborator().elaborateForPush().processLeavingTail(this.getResultFeed(), context);
            Expression.dispatchTailCall(tc);
            super.close();
        }
    }

    private static class FeedMakerForConsumingSelect
    implements FeedMaker {
        public final LetExpression letExpr;

        public FeedMakerForConsumingSelect(LetExpression letExpr) {
            this.letExpr = letExpr;
        }

        @Override
        public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
            return new ItemFeedForConsumingSelect(this.letExpr, out, context);
        }
    }
}

