/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericAtomicComparer;
import net.sf.saxon.functions.IndexOf;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;

public class IndexOfStreamer
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public FeedMaker getFeedMaker(int arg) {
        return arg == 0 ? this : this.getDefaultFeedMaker(arg);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new IndexOfFeed(this.getExpression(), out, context);
    }

    private static class IndexOfFeed
    extends ItemFeed {
        private AtomicValue search;
        private AtomicComparer comparer;
        private int count;

        IndexOfFeed(Expression expr, ItemFeed result, XPathContext context) {
            super(expr, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
            SystemFunction fn = call.getTargetFunction();
            if (fn instanceof IndexOf) {
                this.comparer = ((IndexOf)fn).getAtomicComparer(this.getContext());
            } else {
                Expression collationArg = call.getArg(call.getArity() - 1);
                String collationName = collationArg.evaluateAsString(this.getContext()).toString();
                StringCollator collator = this.getContext().getConfiguration().getCollation(collationName);
                if (collator == null) {
                    this.dynamicError(new XPathException("Unknown collation " + collationName, "FOCH0002"));
                }
                this.comparer = new GenericAtomicComparer(collator, this.getContext());
            }
            Expression searchArg = call.getArg(1);
            this.search = (AtomicValue)searchArg.evaluateItem(this.getContext());
            this.count = 0;
        }

        @Override
        public void append(Item item) throws XPathException {
            if (!this.hasFailed()) {
                ++this.count;
                if (this.comparer.comparesEqual((AtomicValue)item, this.search)) {
                    this.getNextOutputter().append(new Int64Value(this.count));
                }
            }
        }
    }
}

