/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.FeedToEventBuffer;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.CopyOfFeed;
import com.saxonica.ee.stream.feed.DecomposingFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Fork;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.AnchorPattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;

public class ForkAdjunct
extends StreamingAdjunct {
    private Inversion[] actionInversions;

    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        Fork exp = (Fork)this.getExpression();
        if (exp.getSize() == 0) {
            return PostureAndSweep.GROUNDED_AND_MOTIONLESS;
        }
        PostureAndSweep eccentric = null;
        for (Operand o : exp.operands()) {
            PostureAndSweep ps = Streamability.getStreamability(o.getChildExpression(), contextInfo, reasons);
            if (ps.getPosture() == Posture.ROAMING || ps.getSweep() == Sweep.FREE_RANGING) {
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            if (ps.getPosture() != Posture.GROUNDED && ps.getSweep() != Sweep.MOTIONLESS) {
                if (eccentric != null) {
                    reasons.add("At most one branch of the xsl:fork may return streamed nodes");
                    return PostureAndSweep.ROAMING_AND_FREE_RANGING;
                }
                eccentric = ps;
                continue;
            }
            if (ps.getPosture() == Posture.GROUNDED) continue;
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        if (eccentric != null) {
            return eccentric;
        }
        return new PostureAndSweep(Posture.GROUNDED, Sweep.CONSUMING);
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Fork fork = (Fork)this.getExpression();
        if (this.actionInversions == null) {
            this.actionInversions = new Inversion[fork.getSize()];
            int i = 0;
            for (Operand o : fork.operands()) {
                this.actionInversions[i] = Streamability.getSweep(o.getChildExpression()) == Sweep.CONSUMING ? Inversion.invertExpression(o.getChildExpression(), forGrouping) : null;
                ++i;
            }
        }
        return (watchManager, out, context) -> new Trigger(AnchorPattern.getInstance(), new ForkFeed(this.getExpression(), this.actionInversions, out, context, watchManager), context);
    }

    private static class ForkFeed
    extends ItemFeed {
        private WatchManager watchManager;
        private FeedToEventBuffer[] writers;
        private Inversion[] actionInversions;

        public ForkFeed(Expression exp, Inversion[] actionInversions, ItemFeed result, XPathContext context, WatchManager watchManager) {
            super(exp, result, context);
            this.actionInversions = actionInversions;
            this.watchManager = watchManager;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            Fork fork = (Fork)this.getExpression();
            this.writers = new FeedToEventBuffer[fork.getSize()];
            int i = 0;
            for (Operand o : fork.operands()) {
                FeedToEventBuffer writer = new FeedToEventBuffer(this.getNextOutputter(), (ItemFeed)this, this.getContext());
                writer.setPipelineConfiguration(this.getPipelineConfiguration());
                this.writers[i] = writer;
                if (Streamability.getSweep(o.getChildExpression()) == Sweep.CONSUMING) {
                    ItemFeed feed = new DecomposingFeed((Outputter)writer, this.getContext());
                    if (Streamability.getPosture(o.getChildExpression()) != Posture.GROUNDED) {
                        feed = new CopyOfFeed(this.watchManager, feed, this.getContext());
                    }
                    this.watchManager.addWatch(this.actionInversions[i].getWatch(this.watchManager, feed, this.getContext()), true);
                } else {
                    o.getChildExpression().process(writer, this.getContext());
                }
                ++i;
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            return null;
        }

        @Override
        public void append(Item item) throws XPathException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
        }

        @Override
        public void close() throws XPathException {
            if (!this.hasFailed()) {
                Outputter out = this.getNextOutputter();
                for (FeedToEventBuffer writer : this.writers) {
                    writer.replay(out);
                }
                out.close();
            }
            this.writers = null;
        }
    }
}

