/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;

public class FilterFunctionCallAdjunct
extends TransmissionAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        if (reasons == null) {
            reasons = new ArrayList<String>();
        }
        UserFunctionCall exp = (UserFunctionCall)this.getExpression();
        UserFunction target = exp.getFunction();
        Operand[] operanda = exp.getOperanda().copy();
        operanda[0].setUsage(OperandUsage.TRANSMISSION);
        for (int i = 1; i < operanda.length; ++i) {
            operanda[i].setUsage(Operand.typeDeterminedUsage(target.getArgumentType(i).getPrimaryType()));
        }
        return Streamability.generalStreamabilityRules(exp, Arrays.asList(operanda), contextInfo, reasons);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed resultFeed, XPathContext context) throws XPathException {
        UserFunctionCall exp = (UserFunctionCall)this.getExpression();
        final Component targetComponent = exp.getTargetComponent(context);
        final UserFunction target = exp.getTargetFunction(context);
        final Sequence[] argValues = SequenceTool.makeSequenceArray(target.getArity());
        for (int i = 1; i < argValues.length; ++i) {
            try {
                argValues[i] = SequenceTool.toGroundedValue(exp.getArg(i).iterate(context));
                continue;
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }
        return new ItemFeed(resultFeed, context){

            @Override
            public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
                Item it;
                argValues[0] = node;
                XPathContextMajor c2 = this.getContext().newCleanContext();
                c2.setCurrentComponent(targetComponent);
                Sequence result = ((UserFunction)targetComponent.getActor()).call(c2, argValues);
                SequenceIterator iter = result.iterate();
                while ((it = iter.next()) != null) {
                    if (it instanceof FleetingParentNode) {
                        this.getResultFeed().startSelectedParentNode((FleetingParentNode)it, locationId);
                        continue;
                    }
                    this.getResultFeed().append(it);
                }
                return null;
            }

            @Override
            public void append(Item item) throws XPathException {
                argValues[0] = item;
                XPathContextMajor c2 = this.getContext().newCleanContext();
                Sequence result = target.call(c2, argValues);
                1.processItems(result.iterate(), this.getResultFeed());
            }
        };
    }
}

