/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.FilteringAdjunct;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.functions.hof.FunctionSequenceCoercer;
import net.sf.saxon.functions.hof.UserFunctionReference;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;

public class FilterFnStreamer
extends FilteringAdjunct {
    @Override
    public PostureAndSweep computeStreamability(ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        Iterable<Operand> ops;
        Expression exp = this.getExpression();
        PostureAndSweep ps = Streamability.generalStreamabilityRules(exp, ops = exp.operands(), contextInfo, reasons);
        if (ps.getSweep() == Sweep.CONSUMING && ps.getPosture() != Posture.GROUNDED) {
            Expression fn = ((SystemFunctionCall)exp).getArg(1);
            if (FilterFnStreamer.checkPredicateFunction(fn, reasons)) {
                return ps;
            }
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        return ps;
    }

    public static boolean checkPredicateFunction(Expression fn, List<String> reasons) {
        if (fn instanceof FunctionSequenceCoercer) {
            fn = ((FunctionSequenceCoercer)fn).getBaseExpression();
        }
        UserFunction uf = null;
        if (fn instanceof UserFunctionReference) {
            uf = (UserFunction)((UserFunctionReference)fn).getFixedTarget().getActor();
        }
        if (uf == null) {
            reasons.add("Call to " + fn.getParentExpression().toShortString() + " is not streamable, because the predicate function is not statically known");
            return false;
        }
        if (uf.getFunctionName().hasURI(NamespaceUri.ANONYMOUS)) {
            UserFunctionParameter first = uf.getParameterDefinitions()[0];
            first.setFunctionStreamability(FunctionStreamability.INSPECTION);
            first.setRequiredType(new SequenceType(first.getRequiredType().getPrimaryType(), 16384));
            Expression body = uf.getBody();
            PostureAndSweep bodyPS = Streamability.getStreamability(body, ContextItemStaticInfoEE.ABSENT, reasons);
            if (bodyPS.getPosture() != Posture.GROUNDED || bodyPS.getSweep() != Sweep.MOTIONLESS) {
                reasons.add("The body of the predicate function must be grounded and motionless");
                return false;
            }
        } else if (uf.getDeclaredStreamability() != FunctionStreamability.INSPECTION) {
            reasons.add("Call to " + fn.getParentExpression().toShortString() + " is not streamable, because the predicate function is not declared with streamability='inspection'");
            return false;
        }
        return true;
    }

    @Override
    public FilteringFeed.Filter makeFilter(XPathContext context, ItemFeed out) throws XPathException {
        FunctionItem function = (FunctionItem)((SystemFunctionCall)this.getExpression()).getArg(1).evaluateItem(context);
        Sequence[] args = SequenceTool.makeSequenceArray(1);
        return new FilteringFeed.FilterLambda((item, position) -> {
            args[0] = item;
            return ((BooleanValue)function.call(context, args).head()).getBooleanValue() ? FilteringFeed.FilterResult.MATCHES : FilteringFeed.FilterResult.SKIP;
        });
    }
}

