/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.BooleanFnFeed;
import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.FilteringFeed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.NoOpenFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.BooleanEvaluator;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.value.BooleanValue;

public class ChooseAdjunct
extends TransmissionAdjunct {
    int consumingCondition = -2;
    Inversion invertedCondition;
    Inversion[] actionInversions;

    @Override
    public void setExpression(Expression expression) {
        super.setExpression(expression);
        this.actionInversions = new Inversion[((Choose)this.getExpression()).size()];
    }

    private int getConsumingCondition() throws XPathException {
        if (this.consumingCondition == -2) {
            this.consumingCondition = -1;
            int cond = 0;
            for (Operand o : ((Choose)this.getExpression()).conditions()) {
                if (Streamability.getSweep(o.getChildExpression()) == Sweep.CONSUMING) {
                    this.consumingCondition = cond;
                    this.invertedCondition = Inversion.invertExpression(o.getChildExpression(), false);
                    break;
                }
                ++cond;
            }
        }
        return this.consumingCondition;
    }

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        Choose exp = (Choose)this.getExpression();
        if (this.getConsumingCondition() < 0) {
            return (watchManager, out, context) -> {
                BooleanEvaluator[] booleanEvaluators = exp.getConditionEvaluators();
                out.open(new Terminator());
                out = new NoOpenFeed(out, context);
                for (int i = 0; i < exp.size(); ++i) {
                    if (!booleanEvaluators[i].eval(context)) continue;
                    Expression action = exp.getAction(i);
                    if (Streamability.getSweep(action) == Sweep.CONSUMING) {
                        Inversion actionInversion = this.actionInversions[i];
                        if (actionInversion == null) {
                            this.actionInversions[i] = actionInversion = Inversion.invertExpression(action, forGrouping);
                        }
                        return actionInversion.getWatch(watchManager, out, context);
                    }
                    SequenceTool.supply(action.iterate(context), out::append);
                    break;
                }
                return new Trigger(new NodeTestPattern(ErrorType.getInstance()), new FilteringFeed(watchManager, out, context, FilteringFeed.OpaqueFilter), context);
            };
        }
        return null;
    }

    @Override
    public Trigger makeTransmissionFlow(WatchManager watchManager, Expression exp, ItemFeed out, XPathContext context) throws XPathException {
        WatchMaker wm = this.getWatchMaker(false);
        if (wm != null) {
            return wm.makeWatch(watchManager, out, context);
        }
        throw new XPathException("Choose expression too complex for streaming", "XTSE3430");
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return this.getFeedMaker(-1).makeItemFeed(watchManager, out, context);
    }

    @Override
    public FeedMaker getFeedMaker(int arg) throws XPathException {
        if (this.getConsumingCondition() < 0) {
            throw new XPathException("Streaming xsl:choose: expecting a watch");
        }
        return new FeedMakerForConsumingCondition(this, this.getConsumingCondition());
    }

    private static class ItemFeedForConsumingCondition
    extends ItemFeed {
        private final int consumingCondition;
        private boolean matched = false;
        BooleanEvaluator[] booleanEvaluators;

        public ItemFeedForConsumingCondition(Expression expression, int consumingCondition, ItemFeed out, XPathContext context) {
            super(expression, out, context);
            this.consumingCondition = consumingCondition;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            Choose expression = (Choose)this.getExpression();
            this.booleanEvaluators = expression.getConditionEvaluators();
            super.open(terminator);
            for (int i = 0; i < this.consumingCondition; ++i) {
                boolean truth = this.booleanEvaluators[i].eval(this.getContext());
                if (!truth) continue;
                SequenceIterator iter = expression.getAction(i).iterate(this.getContext());
                ItemFeedForConsumingCondition.processItems(iter, this.getNextOutputter());
                this.matched = true;
                break;
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            boolean truth = ((BooleanValue)item).getBooleanValue();
            Choose expression = (Choose)this.getExpression();
            Expression selectedAction = null;
            if (!this.matched) {
                if (truth) {
                    selectedAction = expression.getAction(this.consumingCondition);
                } else {
                    for (int i = 1; i < expression.size(); ++i) {
                        if (!this.booleanEvaluators[i].eval(this.getContext())) continue;
                        selectedAction = expression.getAction(i);
                        break;
                    }
                }
            }
            if (selectedAction != null) {
                SequenceIterator iter = selectedAction.iterate(this.getContext());
                ItemFeedForConsumingCondition.processItems(iter, this.getNextOutputter());
            }
        }
    }

    private static class FeedMakerForConsumingCondition
    implements FeedMaker {
        final ChooseAdjunct chooseAdjunct;
        final Choose expression;
        final int consumingCondition;

        public FeedMakerForConsumingCondition(ChooseAdjunct adjunct, int consumingCondition) {
            this.chooseAdjunct = adjunct;
            this.expression = (Choose)adjunct.getExpression();
            this.consumingCondition = consumingCondition;
        }

        @Override
        public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
            ItemFeedForConsumingCondition action = new ItemFeedForConsumingCondition(this.expression, this.consumingCondition, out, context);
            return new BooleanFnFeed.Positive(watchManager, this.expression, action, context);
        }
    }
}

