/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Event;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;

public class ContentDetector
extends ProxyReceiver {
    private Event.StartElement pendingEvent = null;

    public ContentDetector(WatchManager nextReceiver) {
        super(nextReceiver);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        this.flush(true);
        this.pendingEvent = new Event.StartElement(elemName, type, attributes, namespaces, location, properties);
    }

    @Override
    public void endElement() throws XPathException {
        this.flush(false);
        this.nextReceiver.endElement();
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.flush(true);
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        this.flush(true);
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.flush(true);
        this.nextReceiver.comment(chars, locationId, properties);
    }

    private void flush(boolean nonEmpty) throws XPathException {
        if (this.pendingEvent != null) {
            int properties = this.pendingEvent.getProperties();
            if (nonEmpty) {
                properties |= 0x40000;
            }
            this.pendingEvent.replay(this.nextReceiver, properties);
            this.pendingEvent = null;
        }
    }
}

