/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XSDInclude;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import java.util.HashSet;
import javax.xml.transform.Source;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.type.SchemaException;

public class XSDRedefine
extends SchemaElement {
    private SingleNamespaceSchema externalSchema;
    private SingleNamespaceSchema redefinedSchema;
    private String externalSchemaDocumentURI;

    @Override
    protected void prepareAttributes() throws SchemaException {
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"id", "schemaLocation"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String schemaLocation = atts.getValue(NamespaceUri.NULL, "schemaLocation");
        if (schemaLocation == null) {
            this.missingAttribute("schemaLocation");
            throw new SchemaException("Processing abandoned");
        }
        String documentBase = this.getBaseURI();
        PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
        SchemaCompiler compiler = this.getXSDSchema().getSchemaCompiler();
        Source source = null;
        try {
            source = SchemaReader.getSource(documentBase, schemaLocation, compiler, null);
        }
        catch (SchemaException e) {
            this.handleSchemaException(schemaLocation, e);
        }
        if (source == null) {
            this.warning("Failed to locate redefined schema document " + schemaLocation);
            this.externalSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), NamespaceUri.NULL);
        }
        if (source != null) {
            if (compiler.isBeingRead(source.getSystemId())) {
                this.error("The schema document " + source.getSystemId() + " includes or redefines itself recursively");
                return;
            }
            if (compiler.getExistingSchemaDocument(schemaLocation, this.getXSDSchema().getTargetNamespace()) != null) {
                this.error("Saxon can't handle redefinition of a schema document that has already been loaded by a different route");
                return;
            }
            try {
                SchemaDocument schemaDoc = SchemaReader.read(source, compiler, pipe, this);
                XSDSchema redefined = schemaDoc.getXSDSchema();
                this.externalSchema = redefined.getSchema();
                this.externalSchemaDocumentURI = redefined.getSystemId();
            }
            catch (SchemaException e) {
                this.handleSchemaException(schemaLocation, e);
            }
        }
    }

    private void handleSchemaException(String schemaLocation, SchemaException e) throws SchemaException {
        Throwable cause = e.getException();
        if (!XSDInclude.isFileNotFoundException(cause)) {
            throw e;
        }
        this.warning("Failed to locate redefined schema document " + schemaLocation);
        this.externalSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), NamespaceUri.NULL);
    }

    public SingleNamespaceSchema getRedefinedSchema() {
        return this.redefinedSchema;
    }

    public SingleNamespaceSchema getExternalSchema() {
        return this.externalSchema;
    }

    public String getExternalSchemaDocumentURI() {
        return this.externalSchemaDocumentURI;
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        if (this.externalSchema == null) {
            return;
        }
        HashSet<String> redefinedTypes = new HashSet<String>();
        HashSet<String> redefinedAttributeGroups = new HashSet<String>();
        HashSet<String> redefinedModelGroups = new HashSet<String>();
        block6: for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            switch (fp) {
                case 578: {
                    continue block6;
                }
                case 585: {
                    String attributeGroupName = nodeInfo.getAttributeValue(NamespaceUri.NULL, "name");
                    if (attributeGroupName == null || redefinedAttributeGroups.add(attributeGroupName)) continue block6;
                    this.error("Attempting to redefine the same attribute group more than once");
                    continue block6;
                }
                case 588: 
                case 621: {
                    String typeName = nodeInfo.getAttributeValue(NamespaceUri.NULL, "name");
                    if (typeName == null || redefinedTypes.add(typeName)) continue block6;
                    this.error("Attempting to redefine the same type more than once");
                    continue block6;
                }
                case 596: {
                    String modelGroupName = nodeInfo.getAttributeValue(NamespaceUri.NULL, "name");
                    if (modelGroupName == null || redefinedModelGroups.add(modelGroupName)) continue block6;
                    this.error("Attempting to redefine the same named model group more than once");
                    continue block6;
                }
            }
            this.illegalElement(nodeInfo);
        }
        this.redefinedSchema = new SingleNamespaceSchema(this.externalSchema.getConfiguration(), this.externalSchema.getTargetNamespace());
        this.externalSchema.copyTo(this.redefinedSchema, compiler);
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        if (this.redefinedSchema != null) {
            this.redefinedSchema.copyTo(this.getSchema(), compiler);
        }
    }
}

