/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.Optionality;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.ValueConstraint;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDComplexType;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.str.StringView;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public class XSDAttribute
extends SchemaElement {
    private AttributeDecl attributeDecl = null;
    private AttributeUse attributeUse = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean typeSpecified = false;
    private boolean isReference = false;

    @Override
    protected void prepareAttributes() throws SchemaException {
        String inheritAtt;
        ValueConstraint vc;
        String localTargetNamespace;
        String[] allowed;
        AttributeMap atts = this.attributes();
        if (this.isTopLevel()) {
            allowed = new String[]{"default", "fixed", "id", "inheritable", "name", "type"};
            this.allowAttributes(atts, allowed);
            this.requireAttribute(atts, "name");
        } else {
            allowed = new String[]{"default", "fixed", "form", "id", "inheritable", "name", "ref", "targetNamespace", "type", "use"};
            this.allowAttributes(atts, allowed);
        }
        this.isReference = atts.getValue(NamespaceUri.NULL, "ref") != null;
        String form = atts.getValue(NamespaceUri.NULL, "form");
        if (form != null) {
            if (this.isReference) {
                this.mutuallyExclusiveAttributes("form", "ref");
            }
            if (!form.equals("qualified") && !form.equals("unqualified")) {
                this.invalidAttributeValue("form", form, "Must be 'qualified' or 'unqualified'");
                form = "qualified";
            }
        } else if (this.isTopLevel()) {
            form = "qualified";
        } else {
            form = this.getXSDSchema().getAttributeFormDefault();
            if (form == null) {
                form = "unqualified";
            }
        }
        if ((localTargetNamespace = atts.getValue(NamespaceUri.NULL, "targetNamespace")) != null) {
            if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
                this.error("The targetNamespace cannot be defined locally unless XSD 1.1 is enabled");
            }
            if (atts.getValue(NamespaceUri.NULL, "name") == null) {
                this.error("If there is no @name then there must be no @targetNamespace");
            }
            this.checkMutuallyExclusiveAttributes("targetNamespace", "form");
        }
        String attValue = atts.getValue(NamespaceUri.NULL, "name");
        StructuredQName nc = null;
        if (attValue != null) {
            this.attributeDecl = new AttributeDecl((EnterpriseConfiguration)this.getConfiguration(), this.isTopLevel());
            this.attributeDecl.setLocator(this);
            if (attValue.equals("xmlns")) {
                this.error("The attribute name 'xmlns' is reserved");
            }
            if (atts.getValue(NamespaceUri.NULL, "ref") != null) {
                this.mutuallyExclusiveAttributes("name", "ref");
                nc = StandardNames.SQ_XS_INVALID_NAME;
            } else {
                try {
                    if (localTargetNamespace != null || "qualified".equals(form)) {
                        if (this.getXSDSchema().getTargetNamespace().equals(NamespaceUri.SCHEMA_INSTANCE)) {
                            this.error("Attributes cannot be declared in the 'xsi:' namespace");
                        }
                        nc = this.getComponentName(attValue, 1);
                    } else {
                        nc = this.getComponentName(attValue, 2);
                    }
                    this.attributeDecl.setAttributeName(nc);
                }
                catch (SchemaException err) {
                    this.error(err.getMessage());
                    nc = StandardNames.SQ_XS_INVALID_NAME;
                }
            }
            this.attributeDecl.setAttributeName(nc);
            if (!this.isTopLevel()) {
                this.attributeUse = new AttributeUse((EnterpriseConfiguration)this.getConfiguration());
                this.attributeUse.setTargetComponentName(this.attributeDecl.getComponentName());
                this.attributeUse.setTarget(this.attributeDecl);
                this.attributeUse.setLocator(this);
            }
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "ref")) != null) {
            this.attributeUse = new AttributeUse((EnterpriseConfiguration)this.getConfiguration());
            this.attributeUse.setLocator(this);
            try {
                nc = this.getComponentName(attValue, 0);
                if (nc.hasURI(NamespaceUri.SCHEMA_INSTANCE)) {
                    this.getConfiguration().addSchemaForBuiltInNamespace(NamespaceUri.SCHEMA_INSTANCE);
                }
            }
            catch (SchemaException err) {
                nc = StandardNames.SQ_XS_INVALID_NAME;
                this.error(err.getMessage());
            }
            this.attributeUse.setTargetComponentName(nc);
        }
        if (nc == null) {
            nc = StandardNames.SQ_XS_INVALID_NAME;
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "default")) != null && !nc.hasURI(NamespaceUri.SCHEMA_INSTANCE)) {
            vc = new ValueConstraint(ValueConstraint.Variety.DEFAULT, StringView.tidy(attValue));
            if (this.attributeUse != null) {
                this.attributeUse.setValueConstraint(vc);
            } else if (this.attributeDecl != null) {
                this.attributeDecl.setValueConstraint(vc);
            }
        }
        this.processId();
        attValue = atts.getValue(NamespaceUri.NULL, "fixed");
        if (attValue != null) {
            if (atts.getValue(NamespaceUri.NULL, "default") != null && !nc.hasURI(NamespaceUri.SCHEMA_INSTANCE)) {
                this.mutuallyExclusiveAttributes("fixed", "default");
            }
            vc = new ValueConstraint(ValueConstraint.Variety.FIXED, StringView.tidy(attValue));
            if (this.attributeUse != null) {
                this.attributeUse.setValueConstraint(vc);
            } else if (this.attributeDecl != null) {
                this.attributeDecl.setValueConstraint(vc);
            }
        }
        attValue = atts.getValue(NamespaceUri.NULL, "type");
        int typeFingerprint = -1;
        if (attValue == null) {
            if (this.attributeDecl != null) {
                this.attributeDecl.setSimpleType(AnySimpleType.getInstance());
            }
        } else {
            this.typeSpecified = true;
            if (this.isReference) {
                this.mutuallyExclusiveAttributes("type", "ref");
                return;
            }
            try {
                typeFingerprint = this.getFingerprint(attValue, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            this.checkPermittedType(typeFingerprint, attValue, "an attribute type");
            if (this.attributeDecl != null) {
                this.attributeDecl.setTypeReference(new TypeReference(typeFingerprint, this.getSchema().getConfiguration(), this));
            }
        }
        if ((attValue = atts.getValue(NamespaceUri.NULL, "use")) != null) {
            Optionality useFlag;
            boolean hasFixed;
            boolean hasDefault;
            boolean bl = hasDefault = atts.getValue(NamespaceUri.NULL, "default") != null;
            if (hasDefault && !attValue.equals("optional")) {
                this.error("When @default is present, the @use attribute must have the value \"optional\"");
                attValue = "optional";
            }
            boolean bl2 = hasFixed = atts.getValue(NamespaceUri.NULL, "fixed") != null;
            if (hasFixed && attValue.equals("prohibited") && this.getXSDSchema().getSchemaCompiler().getLanguageVersion() != 10) {
                this.error("When @fixed is present, the @use attribute must not have the value \"prohibited\"");
                attValue = "optional";
            }
            switch (attValue) {
                case "required": {
                    useFlag = Optionality.REQUIRED;
                    break;
                }
                case "optional": {
                    useFlag = Optionality.OPTIONAL;
                    break;
                }
                case "prohibited": {
                    useFlag = Optionality.PROHIBITED;
                    break;
                }
                default: {
                    this.invalidAttributeValue("use", attValue, "Must be required|optional|prohibited");
                    useFlag = Optionality.OPTIONAL;
                }
            }
            if (this.attributeUse != null) {
                this.attributeUse.setUse(useFlag);
            }
        }
        if ((inheritAtt = atts.getValue(NamespaceUri.NULL, "inheritable")) != null) {
            if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
                this.error("The inheritable attribute cannot be used unless XSD 1.1 is enabled");
            }
            boolean inherit = this.parseBooleanAttribute("inheritable", inheritAtt);
            if (this.attributeUse != null) {
                this.attributeUse.setInheritable(inherit ? 1 : 0);
            }
            if (this.attributeDecl != null) {
                this.attributeDecl.setInheritable(inherit);
            }
        }
        if (atts.getValue(NamespaceUri.NULL, "fixed") != null || atts.getValue(NamespaceUri.NULL, "default") != null) {
            SchemaType type;
            boolean needResolver = true;
            if (this.typeSpecified && typeFingerprint < 1024 && (type = BuiltInType.getSchemaType(typeFingerprint)) instanceof SimpleType && !((SimpleType)type).isNamespaceSensitive()) {
                needResolver = false;
            }
            if (needResolver) {
                NamespaceResolver resolver = this.makeNamespaceContext();
                if (this.attributeDecl != null) {
                    this.attributeDecl.setNamespaceResolver(resolver);
                }
                if (this.attributeUse != null) {
                    this.attributeUse.setNamespaceResolver(resolver);
                }
            }
        }
    }

    public AttributeDecl getAttributeDeclaration() {
        return this.attributeDecl;
    }

    public AttributeUse getAttributeUse() {
        return this.attributeUse;
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        String localTargetNamespace = this.getAttributeValue(NamespaceUri.NULL, "targetNamespace");
        if (localTargetNamespace != null && !NamespaceUri.of(localTargetNamespace).equals(this.getXSDSchema().getTargetNamespace())) {
            this.checkLocalTargetNamespace("attribute");
        }
        if (this.attributeDecl != null) {
            NodeInfo nodeInfo;
            AxisIterator ancIter = this.iterateAxis(0);
            while ((nodeInfo = ancIter.next()) != null) {
                if (!(nodeInfo instanceof XSDComplexType)) continue;
                this.attributeDecl.setContainingComplexType(((XSDComplexType)nodeInfo).getComplexType());
                break;
            }
        }
        for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            if (fp == 578) {
                if (this.foundAnnotation) {
                    this.duplicateElement("annotation");
                }
                if (this.foundSimpleType) {
                    this.mustBeFirstElement("annotation");
                }
                this.foundAnnotation = true;
                continue;
            }
            if (fp == 621) {
                if (this.typeSpecified) {
                    this.mutuallyExclusiveElementAndAttribute("simpleType", "type");
                }
                if (this.isReference) {
                    this.mutuallyExclusiveElementAndAttribute("simpleType", "ref");
                }
                if (this.foundSimpleType) {
                    this.duplicateElement("simpleType");
                }
                this.foundSimpleType = true;
                continue;
            }
            this.illegalElement(nodeInfo);
        }
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            if (fp != 621 || this.attributeDecl == null) continue;
            SimpleTypeDefinition simpleTypeDef = ((XSDSimpleType)nodeInfo).getSimpleTypeDefinition();
            TypeReference ref = new TypeReference(simpleTypeDef.getFingerprint(), this.getSchema().getConfiguration(), this);
            this.attributeDecl.setTypeReference(ref);
            simpleTypeDef.setContainingDeclaration(this.attributeDecl.getComponentName(), false);
            simpleTypeDef.setContextComponent(this.attributeDecl);
        }
    }
}

