/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringView;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class VersionControlFilter
extends ProxyReceiver {
    private final SchemaCompiler compiler;
    private int depthOfHole = 0;
    private boolean emptySchemaElement = false;
    private final DecimalValue thisVersion;
    private final boolean isXSD11;
    private boolean foundErrors;
    private static final FingerprintedQName XS_SCHEMA = new FingerprintedQName("xs", NamespaceUri.SCHEMA, "schema", 617);

    public VersionControlFilter(SchemaCompiler compiler, Receiver next) {
        super(next);
        this.compiler = compiler;
        int xsdVersion = compiler.getLanguageVersion();
        this.thisVersion = new BigDecimalValue(new BigDecimal(xsdVersion == 10 ? "1.0" : "1.1"));
        this.isXSD11 = xsdVersion == 11;
    }

    @Override
    public void open() throws XPathException {
        this.nextReceiver.open();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (this.emptySchemaElement) {
            ++this.depthOfHole;
            return;
        }
        if (this.depthOfHole == 0) {
            boolean ignore = false;
            boolean doneAttributes = false;
            for (AttributeInfo att : attributes) {
                NodeName attName = att.getNodeName();
                if (!attName.hasURI(NamespaceUri.SCHEMA_VERSIONING)) continue;
                String localName = attName.getLocalPart();
                try {
                    block9 : switch (localName) {
                        case "minVersion": {
                            DecimalValue dv = this.parseDecimalValue(att.getValue());
                            if (this.thisVersion.compareTo(dv) >= 0) break;
                            ignore = true;
                            doneAttributes = true;
                            break;
                        }
                        case "maxVersion": {
                            DecimalValue dv = this.parseDecimalValue(att.getValue());
                            if (this.thisVersion.compareTo(dv) < 0) break;
                            ignore = true;
                            doneAttributes = true;
                            break;
                        }
                        case "typeAvailable": {
                            Set<StructuredQName> typesAvailable = this.parseListOfQNames(att.getValue(), namespaces);
                            for (StructuredQName structuredQName : typesAvailable) {
                                if (this.isAutomaticallyKnownTypeName(structuredQName)) continue;
                                ignore = true;
                                doneAttributes = true;
                                break block9;
                            }
                            break;
                        }
                        case "typeUnavailable": {
                            Set<StructuredQName> typesUnavailable = this.parseListOfQNames(att.getValue(), namespaces);
                            ignore = true;
                            for (Object name2 : typesUnavailable) {
                                if (this.isAutomaticallyKnownTypeName((StructuredQName)name2)) continue;
                                ignore = false;
                                doneAttributes = true;
                                break block9;
                            }
                            break;
                        }
                        case "facetAvailable": {
                            Object name2;
                            Set<StructuredQName> set = this.parseListOfQNames(att.getValue(), namespaces);
                            name2 = set.iterator();
                            while (name2.hasNext()) {
                                StructuredQName name = name2.next();
                                if (this.isKnownFacetName(name)) continue;
                                ignore = true;
                                doneAttributes = true;
                                break block9;
                            }
                            break;
                        }
                        case "facetUnavailable": {
                            Set<StructuredQName> facetsUnavailable = this.parseListOfQNames(att.getValue(), namespaces);
                            ignore = true;
                            for (StructuredQName name : facetsUnavailable) {
                                if (this.isKnownFacetName(name)) continue;
                                ignore = false;
                                doneAttributes = true;
                                break block9;
                            }
                            break;
                        }
                        default: {
                            this.compiler.warning("Unrecognized attribute name " + attName, "SXSD1014", location);
                        }
                    }
                    if (!doneAttributes) continue;
                    break;
                }
                catch (XPathException e) {
                    this.compiler.error("Invalid value for attribute " + attName + ": " + e.getMessage(), location);
                    this.foundErrors = true;
                }
            }
            if (ignore) {
                if (elemName.equals(XS_SCHEMA)) {
                    this.emptySchemaElement = true;
                } else {
                    this.depthOfHole = 1;
                    return;
                }
            }
            this.nextReceiver.startElement(elemName, type, attributes, namespaces, location, properties);
        } else {
            ++this.depthOfHole;
        }
    }

    @Override
    public void endElement() throws XPathException {
        if (this.depthOfHole > 0) {
            --this.depthOfHole;
        } else {
            this.nextReceiver.endElement();
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.depthOfHole == 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) {
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
    }

    @Override
    public void endDocument() throws XPathException {
        super.endDocument();
        if (this.foundErrors) {
            throw new XPathException("One or more errors were found in the content of schema versioning attributes");
        }
    }

    private DecimalValue parseDecimalValue(String value) throws ValidationException {
        return (DecimalValue)BigDecimalValue.makeDecimalValue(value, true).asAtomic();
    }

    private Set<StructuredQName> parseListOfQNames(String value, NamespaceResolver resolver) throws XPathException {
        StringValue tok;
        HashSet<StructuredQName> result = new HashSet<StructuredQName>(4);
        Whitespace.Tokenizer tokenizer = new Whitespace.Tokenizer(StringView.tidy(value));
        while ((tok = tokenizer.next()) != null) {
            StructuredQName val = StructuredQName.fromLexicalQName(tok.getStringValue(), true, false, resolver);
            result.add(val);
        }
        return result;
    }

    private boolean isKnownFacetName(StructuredQName name) {
        String localName = name.getLocalPart();
        return name.hasURI(NamespaceUri.SCHEMA) && Facet.isFacetName(localName, this.isXSD11 ? 11 : 10) || name.hasURI(NamespaceUri.SAXON) && localName.equals("preprocess");
    }

    private boolean isAutomaticallyKnownTypeName(StructuredQName name) {
        int fp = StandardNames.getFingerprint(name.getNamespaceUri(), name.getLocalPart());
        return fp != -1 && BuiltInType.getSchemaType(fp) != null && (this.isXSD11 || fp != 575);
    }
}

