/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.config.StandardSchemaResolver;
import com.saxonica.ee.jaxp.SchemaFactoryImpl;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SchemaNodeFactory;
import com.saxonica.ee.schema.sdoc.VersionControlFilter;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.event.CommentStripper;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.Valve;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.type.SchemaException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class SchemaReader {
    private SchemaReader() {
    }

    public static Source getSource(String baseURI, String relativeURI, SchemaCompiler compiler, NamespaceUri targetNamespaceUri) throws SchemaException {
        try {
            String targetNamespace;
            String[] locations = new String[]{relativeURI};
            Source[] sources = null;
            SchemaURIResolver r = compiler.getSchemaURIResolver();
            String string = targetNamespace = targetNamespaceUri == null ? null : targetNamespaceUri.toString();
            if (r != null) {
                sources = r.resolve(targetNamespace, baseURI, locations);
            }
            if (sources == null || sources.length == 1 && sources[0] == null) {
                r = new StandardSchemaResolver(compiler.getConfiguration());
                sources = r.resolve(targetNamespace, baseURI, locations);
            }
            if (sources.length == 0 || sources[0] == null) {
                return null;
            }
            if (sources.length == 1) {
                return sources[0];
            }
            throw new UnsupportedOperationException("SchemaURIResolver is currently restricted to return one source for each schemaLocation");
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public static Source[] getSources(String baseURI, String[] relativeURIs, SchemaCompiler compiler, NamespaceUri targetNamespace) throws SchemaException {
        try {
            Source[] sources = compiler.getSchemaURIResolver().resolve(targetNamespace.toString(), baseURI, relativeURIs);
            if (sources == null) {
                StandardSchemaResolver r = new StandardSchemaResolver(compiler.getConfiguration());
                sources = r.resolve(targetNamespace.toString(), baseURI, relativeURIs);
            }
            return sources;
        }
        catch (XPathException e) {
            throw new SchemaException(e);
        }
    }

    public static SchemaDocument read(Source source, SchemaCompiler compiler, PipelineConfiguration pipe, SchemaElement referrer) throws SchemaException {
        SchemaDocument schemaDocument;
        AxisIterator children;
        NodeInfo top;
        boolean tracing = pipe.getConfiguration().isTiming();
        String docId = source.getSystemId();
        if (docId == null) {
            docId = "(unknown URI)";
        }
        if (tracing) {
            pipe.getConfiguration().getLogger().info("Loading schema document " + docId);
        }
        if ((top = (children = (schemaDocument = SchemaReader.buildSchemaDocument(source, compiler, pipe, referrer)).getDocument().getRootNode().iterateAxis(3, NodeKindTest.makeNodeKindTest(1))).next()).getNamespaceUri().equals(NamespaceUri.SCM)) {
            if (tracing) {
                pipe.getConfiguration().getLogger().info("Loaded compiled schema document " + docId);
            }
            return schemaDocument;
        }
        if (!(top instanceof XSDSchema)) {
            SchemaException err = new SchemaException("Outermost element of schema document must be xs:schema");
            Loc loc = new Loc(source.getSystemId(), top == null ? 1 : top.getLineNumber(), -1);
            err.setLocator(loc);
            pipe.getErrorReporter().report(new XmlProcessingException(err));
            throw err;
        }
        compiler.setPipelineConfiguration(pipe);
        compiler.setBeingRead(source.getSystemId());
        ((XSDSchema)top).processAllAttributes();
        ((XSDSchema)top).validateSubtree(compiler);
        compiler.markAsRead(source.getSystemId(), (XSDSchema)top);
        int errors = ((XSDSchema)top).getErrorCount();
        if (errors > 0) {
            String msg = errors == 1 ? "One error was" : errors + " errors were";
            throw new SchemaException(msg + " found while processing the schema");
        }
        if (tracing) {
            pipe.getConfiguration().getLogger().info("Finished loading schema document " + source.getSystemId());
        }
        return schemaDocument;
    }

    public static SchemaDocument buildSchemaDocument(Source source, SchemaCompiler compiler, PipelineConfiguration pipe, SchemaElement referrer) throws SchemaException {
        TreeInfo tree;
        SchemaNodeFactory nodeFactory = new SchemaNodeFactory(compiler, pipe, referrer);
        LinkedTreeBuilder schemaBuilder = new LinkedTreeBuilder(pipe, Durability.LASTING);
        schemaBuilder.setSystemId(source.getSystemId());
        schemaBuilder.setNodeFactory(nodeFactory);
        schemaBuilder.setLineNumbering(true);
        Stripper stripper = new Stripper(AllElementsSpaceStrippingRule.getInstance(), schemaBuilder);
        VersionControlFilter vcFilter = new VersionControlFilter(compiler, stripper);
        CommentStripper commentStripper = new CommentStripper(vcFilter);
        if (source instanceof NodeInfo) {
            String base = ((NodeInfo)source).getBaseURI();
            if (!base.equals(source.getSystemId())) {
                schemaBuilder.setSystemId(base);
            }
            LocationCopier copier = new LocationCopier(((NodeInfo)source).getNodeKind() == 9, base);
            pipe.setCopyInformee(CSharp.methodRef(copier::notifyElementNode));
        }
        TinyBuilder scmBuilder = new TinyBuilder(pipe);
        scmBuilder.setSystemId(source.getSystemId());
        Valve valve = new Valve(NamespaceUri.SCM, commentStripper, scmBuilder);
        Configuration config = pipe.getConfiguration();
        ParseOptions options = config.getParseOptions().withSchemaValidationMode(3).withErrorReporter(compiler.getErrorReporter());
        try {
            commentStripper.setPipelineConfiguration(pipe);
            SchemaReader.sendSchemaSource(source, compiler, pipe, valve, config, options);
            tree = valve.wasDiverted() ? scmBuilder.getTree() : schemaBuilder.getCurrentRoot().getTreeInfo();
            schemaBuilder.reset();
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null) {
                if (SchemaReader.isSAXException(cause)) {
                    SAXParseException spe = (SAXParseException)cause;
                    if ((cause = spe.getException()) != null) {
                        if (cause instanceof SchemaException) {
                            throw (SchemaException)cause;
                        }
                        if (cause instanceof RuntimeException) {
                            cause.printStackTrace();
                        }
                        throw new SchemaException(cause);
                    }
                    throw new SchemaException("Failed to parse schema document");
                }
                if (cause instanceof SchemaException) {
                    throw (SchemaException)cause;
                }
                throw new SchemaException(cause);
            }
            throw new SchemaException(err);
        }
        finally {
            if (options.isPleaseCloseAfterUse()) {
                ParseOptions.close(source);
            }
        }
        NodeInfo doc = tree.getRootNode();
        if (doc.iterateAxis(3, NodeKindTest.ELEMENT).next() == null) {
            throw new SchemaException("Schema document is empty or absent");
        }
        return new SchemaDocument(tree);
    }

    private static boolean isSAXException(Throwable e) {
        return e instanceof SAXParseException;
    }

    private static void sendSchemaSource(Source source, SchemaCompiler compiler, PipelineConfiguration pipe, Valve valve, Configuration config, ParseOptions options) throws XPathException {
        if (Version.platform.isJava() && options.getXMLReader() == null && options.getXMLReaderMaker() == null && !(source instanceof NodeInfo) && !(source instanceof DOMSource)) {
            SchemaReader.setupSourceWithReader(source, compiler, valve, config, options);
        } else if (source instanceof NodeInfo && ((NodeInfo)source).getNodeKind() == 1 || source instanceof DOMSource && ((DOMSource)source).getNode().getNodeType() == 1) {
            TinyBuilder temp = new TinyBuilder(pipe);
            temp.setSystemId(source.getSystemId());
            temp.open();
            temp.startDocument(0);
            Sender.send(source, temp, options);
            temp.endDocument();
            temp.close();
            Sender.send(temp.getCurrentRoot().asActiveSource(), valve, options);
        } else {
            Sender.send(source, valve, options);
        }
    }

    public static void setupSourceWithReader(Source source, SchemaCompiler compiler, Valve valve, Configuration config, ParseOptions options) throws XPathException {
        XMLReader parser = config.getStyleParser();
        if ((options = options.withXMLReader(parser).withDTDValidationMode(4)).getEntityResolver() != null && parser.getEntityResolver() == null) {
            parser.setEntityResolver(options.getEntityResolver());
        }
        if (compiler.getErrorReporter() instanceof SchemaFactoryImpl.ErrorReporterWrappingErrorHandler) {
            parser.setErrorHandler(((SchemaFactoryImpl.ErrorReporterWrappingErrorHandler)compiler.getErrorReporter()).getErrorHandler());
        }
        Sender.send(source, valve, options);
        config.reuseStyleParser(parser);
    }
}

