/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class SaxonParam
extends AnnotationParent {
    @Override
    protected void prepareAttributes() throws SchemaException {
        String select;
        String as;
        Configuration config = this.getConfiguration();
        NodeImpl parent = this.getParent();
        if (parent == null || parent.getFingerprint() != 581) {
            this.error("The saxon:param element is allowed only as a child of xs:appinfo");
        }
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"as", "name", "select"};
        this.allowAttributes(atts, allowed);
        this.requireAttribute(atts, "name");
        String name = atts.getValue(NamespaceUri.NULL, "name");
        StructuredQName qName = this.makeQName(name);
        if (qName.hasURI(NamespaceUri.NULL) && qName.getLocalPart().equals("value")) {
            this.error("The variable name $value is reserved for system use");
        }
        if ((as = atts.getValue(NamespaceUri.NULL, "as")) == null) {
            as = "item()*";
        }
        if ((select = atts.getValue(NamespaceUri.NULL, "select")) == null) {
            select = "()";
        }
        SchemaElement.XPathStaticContext env = new SchemaElement.XPathStaticContext(this);
        env.setNamespaceResolver(this.makeNamespaceContext());
        env.setBaseURI(this.getBaseURI());
        env.setXPathLanguageLevel(31);
        SequenceType requiredType = this.makeSequenceType(as, env);
        GroundedValue defaultValue = EmptySequence.getInstance();
        try {
            Expression expr = ExpressionTool.make(select, env, 0, 0, null);
            ExpressionVisitor visitor = ExpressionVisitor.make(env);
            ItemType contextItemType = Type.ITEM_TYPE;
            expr = expr.typeCheck(visitor, config.makeContextItemStaticInfo(contextItemType, true));
            expr = config.getTypeChecker(false).staticTypeCheck(expr, requiredType, () -> new RoleDiagnostic(8, name, 0), visitor);
            SlotManager stackFrameMap = config.makeSlotManager();
            ExpressionTool.allocateSlots(expr, stackFrameMap.getNumberOfVariables(), stackFrameMap);
            Controller controller = new Controller(config);
            XPathContextMajor dynamicContext = controller.newXPathContext();
            dynamicContext = dynamicContext.newCleanContext();
            dynamicContext.openStackFrame(stackFrameMap);
            defaultValue = SequenceTool.toGroundedValue(expr.iterate(dynamicContext));
        }
        catch (XPathException e) {
            this.error(e.getMessage());
        }
        catch (UncheckedXPathException e) {
            this.error(e.getXPathException().getMessage());
        }
        PackageData pd = new PackageData(this.getConfiguration());
        pd.setHostLanguage(HostLanguage.XML_SCHEMA, this.getConfiguration().getXsdVersion());
        pd.setSchemaAware(true);
        GlobalParam param = new GlobalParam();
        param.setPackageData(pd);
        param.setVariableQName(qName);
        param.setRequiredType(requiredType);
        param.setBody(Literal.makeLiteral(defaultValue));
        this.getXSDSchema().addGlobalParam(param);
    }

    public SequenceType makeSequenceType(String sequenceType, StaticContext env) throws SchemaException {
        try {
            XPathParser parser = new XPathParser(env);
            return parser.parseSequenceType(sequenceType, env);
        }
        catch (XPathException err) {
            this.error(err.getMessage());
            return SequenceType.ANY_SEQUENCE;
        }
    }

    public final StructuredQName makeQName(String lexicalQName) throws SchemaException {
        StructuredQName qName;
        try {
            qName = StructuredQName.fromLexicalQName(lexicalQName, false, true, this);
        }
        catch (XPathException e) {
            throw new SchemaException(e.asStaticError().maybeWithErrorCode("XTSE0020").replacingErrorCode("FONS0004", "XTSE0280").replacingErrorCode("FOCA0002", "XTSE0020"));
        }
        return qName;
    }
}

