/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class WhitespaceFacet
extends Facet {
    int action;

    @Override
    public boolean isConstraining() {
        return false;
    }

    @Override
    public String getName() {
        return "whiteSpace";
    }

    public void setValue(String value) throws SchemaException {
        if (value.equals("preserve")) {
            this.action = 0;
        } else if (value.equals("replace")) {
            this.action = 1;
        } else if (value.equals("collapse")) {
            this.action = 2;
        } else {
            throw new SchemaException("Invalid whiteSpace facet value: " + value);
        }
    }

    @Override
    public UnicodeString getValue() {
        switch (this.action) {
            case 0: {
                return BMPString.of("preserve");
            }
            case 1: {
                return BMPString.of("replace");
            }
            case 2: {
                return BMPString.of("collapse");
            }
        }
        return null;
    }

    @Override
    public int getWhitespaceAction() {
        return this.action;
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        if (base.isListType()) {
            if (this.action != 2) {
                throw new SchemaException("The whiteSpace facet on a list type must be {collapse}");
            }
        } else {
            if (base.isUnionType()) {
                throw new SchemaException("The whiteSpace facet is not applicable to a union type");
            }
            if (!(base instanceof AnySimpleType)) {
                int p = ((AtomicType)base).getPrimitiveType();
                if (type.getFingerprint() != 513) {
                    if (p == 513) {
                        if (this.action < base.getWhitespaceAction()) {
                            throw new SchemaException("The whiteSpace normalization must not be weaker than that of the base type");
                        }
                    } else if (this.action != 2) {
                        throw new SchemaException("The whiteSpace facet must be {collapse} unless the type is derived from string");
                    }
                }
            }
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        return true;
    }

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        WhitespaceFacet facet = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<WhitespaceFacet>(facet);
                }
                case "value": {
                    switch (this.action) {
                        default: {
                            return StringValue.bmp("preserve");
                        }
                        case 2: {
                            return StringValue.bmp("collapse");
                        }
                        case 1: 
                    }
                    return StringValue.bmp("replace");
                }
                case "fixed": {
                    return BooleanValue.get(this.isFixed());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

