/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import java.math.BigInteger;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.sort.SimpleTypeComparison;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigIntegerValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public abstract class ValueRangeFacet
extends Facet {
    boolean isConverted = false;
    AtomicValue requiredValue;

    @Override
    public UnicodeString getValue() {
        return this.requiredValue.getUnicodeStringValue();
    }

    public void setValue(String value) throws SchemaException {
        this.requiredValue = StringValue.makeStringValue(value);
    }

    public void setRequiredValue(AtomicValue value) {
        this.requiredValue = value;
        this.isConverted = true;
    }

    public AtomicValue getRequiredValue() {
        return this.requiredValue;
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException, ValidationException {
        boolean ok;
        EnterpriseConfiguration config;
        block23: {
            boolean OK;
            int primitive;
            if (!base.isAtomicType()) {
                throw new SchemaException("The " + this.getName() + " facet is not available on the non-atomic type " + base.getDescription());
            }
            if (base instanceof UserAtomicType) {
                primitive = ((UserAtomicType)base).getPrimitiveType();
            } else if (base instanceof BuiltInAtomicType) {
                primitive = ((BuiltInAtomicType)base).getPrimitiveType();
            } else {
                if (base instanceof SimpleTypeDefinition) {
                    if (base.getValidationStatus() == SchemaValidationStatus.INVALID || ((SimpleTypeDefinition)base).getFixupStatus() == SchemaValidationStatus.INVALID) {
                        return;
                    }
                    throw new IllegalStateException();
                }
                throw new IllegalStateException("Unknown atomic type representation: " + base.getClass());
            }
            boolean bl = OK = primitive == 533 || primitive == 517 || primitive == 516 || primitive == 515 || primitive == 518 || primitive == 521 || primitive == 519 || primitive == 520 || primitive == 523 || primitive == 522 || primitive == 526 || primitive == 524 || primitive == 525 || primitive == 634 || primitive == 633;
            if (!OK) {
                throw new SchemaException("The " + this.getName() + " facet is not allowed on the unordered type " + base.getDescription());
            }
            config = type.getConfiguration();
            try {
                this.convertToTargetType((AtomicType)type.getBaseType(), config);
            }
            catch (SchemaException e1) {
                try {
                    this.convertToTargetType((AtomicType)type.getBuiltInBaseType(), config);
                    ok = true;
                }
                catch (SchemaException e2) {
                    ok = false;
                }
                if (ok) break block23;
                throw e1;
            }
        }
        if (base instanceof UserSimpleType) {
            UserSimpleType ubase = (UserSimpleType)base;
            Facet baseFacet = ubase.getFacet(this.getClass());
            if (baseFacet != null && baseFacet.isFixed() && !SimpleTypeComparison.getInstance().equal(this.requiredValue, ((ValueRangeFacet)baseFacet).requiredValue)) {
                throw new SchemaException("The " + this.getName() + " facet is fixed in the base type and cannot be varied");
            }
            ValidationFailure err = ubase.checkAgainstFacets(this.requiredValue, null, ubase.getExtendedFacetList(), null);
            if (err != null) {
                if (this.getName().endsWith("Exclusive") && baseFacet != null) {
                    ((ValueRangeFacet)baseFacet).convertToTargetType(base, config);
                    if (SimpleTypeComparison.getInstance().equal(this.requiredValue, ((ValueRangeFacet)baseFacet).requiredValue)) {
                        err = null;
                    }
                }
                if (err != null) {
                    throw new SchemaException("In a type derived by restriction, the " + this.getName() + " facet is not a valid value of the base type");
                }
            }
        } else {
            BuiltInAtomicType bbase = (BuiltInAtomicType)base;
            ok = true;
            if (this.requiredValue instanceof Int64Value) {
                long v = ((Int64Value)this.requiredValue).longValue();
                ok = IntegerValue.checkRange(v, bbase);
            } else if (this.requiredValue instanceof BigIntegerValue) {
                BigInteger v = ((BigIntegerValue)this.requiredValue).asBigInteger();
                ok = IntegerValue.checkBigRange(v, bbase);
            }
            if (!ok) {
                throw new SchemaException("The value of the " + this.getName() + " facet is out of range for the base type");
            }
        }
    }

    protected void convertToTargetType(SimpleType base, Configuration config) throws SchemaException {
        if (!this.isConverted) {
            StringConverter converter = ((AtomicType)base).getStringConverter(config.getConversionRules());
            ConversionResult v = converter.convertString(this.requiredValue.getUnicodeStringValue());
            if (v instanceof ValidationFailure) {
                String s = Err.wrap(this.requiredValue.getUnicodeStringValue(), 4);
                throw new SchemaException("The value " + s + " of the " + this.getName() + " facet is not valid for the type " + base.getDescription() + ". " + ((ValidationFailure)v).getMessage());
            }
            this.requiredValue = (AtomicValue)v;
            this.isConverted = true;
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        if (!this.isConverted) {
            throw new AssertionError((Object)"Value used in facet has not been converted to required type");
        }
        if (value == null || this.requiredValue == null) {
            return false;
        }
        int c = SimpleTypeComparison.getInstance().compareItems(value, this.requiredValue);
        return c != Integer.MIN_VALUE && this.testComparisonOK(c);
    }

    protected abstract boolean testComparisonOK(int var1);

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        ValueRangeFacet thisFacet = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<ValueRangeFacet>(thisFacet);
                }
                case "value": {
                    return this.requiredValue;
                }
                case "fixed": {
                    return BooleanValue.get(this.isFixed());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

