/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.Optionality;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.UserSimpleType;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.str.BMPString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class ExplicitTimezoneFacet
extends Facet {
    private Optionality facetValue;

    @Override
    public String getName() {
        return "explicitTimezone";
    }

    @Override
    public UnicodeString getValue() {
        switch (this.facetValue) {
            case REQUIRED: {
                return BMPString.of("required");
            }
            case OPTIONAL: {
                return BMPString.of("optional");
            }
        }
        return BMPString.of("prohibited");
    }

    public void setValue(String value) throws SchemaException {
        switch (value) {
            case "required": {
                this.facetValue = Optionality.REQUIRED;
                break;
            }
            case "optional": {
                this.facetValue = Optionality.OPTIONAL;
                break;
            }
            case "prohibited": {
                this.facetValue = Optionality.PROHIBITED;
                break;
            }
            default: {
                throw new SchemaException("Value of explicitTimezone facet must be required, optional, or prohibited");
            }
        }
    }

    @Override
    public void checkFacetRestriction(UserSimpleType type, SimpleType base, SchemaCompiler compiler) throws SchemaException {
        if (base instanceof UserAtomicType) {
            UserAtomicType ubase = (UserAtomicType)base;
            ExplicitTimezoneFacet baseFacet = (ExplicitTimezoneFacet)ubase.getFacet(ExplicitTimezoneFacet.class);
            if (baseFacet != null) {
                if (baseFacet.isFixed() && this.facetValue != baseFacet.facetValue) {
                    throw new SchemaException("The explicitTimezone facet is fixed in the base type and cannot be varied");
                }
                if (baseFacet.facetValue == Optionality.PROHIBITED && this.facetValue != Optionality.PROHIBITED) {
                    throw new SchemaException("The explicitTimezone is prohibited in the base type so it must be prohibited in the derived type");
                }
                if (baseFacet.facetValue == Optionality.REQUIRED && this.facetValue != Optionality.REQUIRED) {
                    throw new SchemaException("The explicitTimezone is required in the base type so it must be required in the derived type");
                }
            }
        } else if (base.getFingerprint() == 565 && this.facetValue != Optionality.REQUIRED) {
            throw new SchemaException("The explicitTimezone is required in the base type so it must be required in the derived type");
        }
    }

    @Override
    public boolean testAtomicValue(AtomicValue value) {
        if (this.facetValue != Optionality.OPTIONAL) {
            if (value instanceof CalendarValue) {
                return this.facetValue == Optionality.REQUIRED == ((CalendarValue)value).hasTimezone();
            }
            return false;
        }
        return true;
    }

    @Override
    public FunctionItem getFacetAsFunctionItem() {
        ExplicitTimezoneFacet facet = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return new StringValue(this.getName());
                }
                case "implementation": {
                    return new ObjectValue<ExplicitTimezoneFacet>(facet);
                }
                case "value": {
                    return new StringValue(this.getValue());
                }
                case "fixed": {
                    return BooleanValue.get(this.isFixed());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

