/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.ComponentWithValueConstraint;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.IdentityConstraintReference;
import com.saxonica.ee.schema.Key;
import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.SimpleComponentReference;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.TypeAlternative;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.Unique;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.ValueConstraint;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.validate.SchemaElementTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public class ElementDecl
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent,
ComponentWithValueConstraint,
SchemaDeclaration,
Term {
    private int block = 0;
    private ModelGroupDefinition containingModelGroup = null;
    private UserComplexType containingComplexType = null;
    private List<IdentityConstraintReference> constraintRefs = null;
    private int finalProhibitions = 0;
    private ValueConstraint valueConstraint;
    private final boolean global;
    private boolean isAbstractDecl = false;
    private StructuredQName elementName;
    private int fingerprint = -1;
    private NamespaceResolver namespaceResolver;
    private boolean nillable = false;
    private List<SimpleComponentReference> substitutionGroupOwners = null;
    private Collection<ElementDecl> substitutionGroupMembers = new ArrayList<ElementDecl>();
    private NamespaceUri targetNamespace;
    private TypeReference typeReference = null;
    private Collection<UserComplexType> complexTypesUsingThisElement = new ArrayList<UserComplexType>();
    private List<TypeAlternative> typeAlternatives = null;
    private String generatedId = null;

    public ElementDecl(EnterpriseConfiguration config, boolean global, SourceLocator locator) {
        this.setLocator(locator);
        this.global = global;
        this.setConfiguration(config);
        this.constraintRefs = new ArrayList<IdentityConstraintReference>(3);
    }

    @Override
    public void setGeneratedId(String id) {
        this.generatedId = id;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void addIdentityConstraint(IdentityConstraintReference constraint) {
        if (constraint == null) {
            return;
        }
        this.constraintRefs.add(constraint);
    }

    public void setContainingComplexType(UserComplexType type) {
        this.containingComplexType = type;
    }

    public void setContainingModelGroup(ModelGroupDefinition type) {
        this.containingModelGroup = type;
    }

    public int getBlock() {
        return this.block;
    }

    @Override
    public ValueConstraint getValueConstraint() {
        return this.valueConstraint;
    }

    public int getSubstitutionGroupExclusions() {
        return this.finalProhibitions;
    }

    public boolean allowsDerivation(int derivation) {
        return (this.finalProhibitions & derivation) == 0;
    }

    public UserComplexType getContainingComplexType() {
        return this.containingComplexType;
    }

    public ModelGroupDefinition getContainingModelGroup() {
        return this.containingModelGroup;
    }

    @Override
    public AtomicSequence getFixedValue() {
        ValueConstraint vc = this.getFixedValueConstraint();
        return vc == null ? null : vc.getValue();
    }

    @Override
    public UnicodeString getFixedValueLexicalForm() {
        ValueConstraint vc = this.getFixedValueConstraint();
        return vc == null ? null : vc.getLexicalForm();
    }

    public List<IdentityConstraintReference> getIdentityConstraints() {
        return this.constraintRefs;
    }

    public String getDisplayName() {
        return this.elementName.getDisplayName();
    }

    public String getName() {
        return this.elementName.getLocalPart();
    }

    public NamespaceUri getTargetNamespace() {
        return this.targetNamespace;
    }

    public int getTypeFingerprint() {
        if (this.typeReference != null) {
            return this.typeReference.getTargetFingerprint();
        }
        return -1;
    }

    @Override
    public SchemaType getType() throws MissingComponentException {
        if (this.typeReference == null) {
            return AnyType.getInstance();
        }
        SchemaType schemaType = (SchemaType)this.typeReference.getTarget();
        if (schemaType == null || schemaType.getValidationStatus() == SchemaValidationStatus.INVALID) {
            return AnyType.getInstance();
        }
        if (schemaType instanceof SimpleTypeDefinition) {
            schemaType = ((SimpleTypeDefinition)schemaType).getWorkingType();
            this.typeReference.setTarget(schemaType);
        }
        return schemaType;
    }

    public Set<ElementDecl> getSubstitutionGroupOwners() throws MissingComponentException {
        if (this.substitutionGroupOwners != null) {
            HashSet<ElementDecl> heads = new HashSet<ElementDecl>(this.substitutionGroupOwners.size());
            for (ComponentReference componentReference : this.substitutionGroupOwners) {
                heads.add((ElementDecl)componentReference.getTarget());
            }
            return heads;
        }
        return Collections.emptySet();
    }

    public Collection<ElementDecl> getSubstitutionGroupMembers() {
        return this.substitutionGroupMembers;
    }

    public synchronized void addSubstitutionGroupMember(ElementDecl member, SchemaCompiler compiler) throws SchemaException {
        if (!this.substitutionGroupMembers.contains(member)) {
            EnterpriseConfiguration config = this.getConfiguration();
            if (member != this) {
                member.fixup(compiler);
                String reason = member.isValidlySubstitutable(this);
                if (reason != null) {
                    boolean isError = false;
                    if (compiler.getConfiguration().getXsdVersion() == 11 && reason.startsWith("required type derivation method")) {
                        isError = true;
                    }
                    String memberName = member.getDisplayName();
                    String msg = "Element " + Err.wrap(memberName, 1) + " cannot participate in the substitution group of element " + Err.wrap(this.getName(), 1) + ": " + reason;
                    try {
                        Set<ElementDecl> grandFathers = this.getSubstitutionGroupOwners();
                        for (ElementDecl grandFather : grandFathers) {
                            if (member.isValidlySubstitutable(grandFather) != null) continue;
                            msg = msg + ". However, element " + Err.wrap(memberName, 1) + " can substitute for element " + Err.wrap(grandFather.getDisplayName(), 1);
                            break;
                        }
                    }
                    catch (MissingComponentException missingComponentException) {
                        // empty catch block
                    }
                    if (isError) {
                        compiler.error(msg, member);
                        throw new SchemaException("Disallowed substitution group membership");
                    }
                    compiler.warning(msg, "SXSD1002", member);
                    return;
                }
            }
            if (member != this && config.isSealedNamespace(this.getTargetNamespace())) {
                String msg = "It is not possible to add to the substitution group of element " + this.getName() + " in namespace '" + this.getTargetNamespace() + "', because the schema for that namespace has already been used for validating instance documents, or for compiling queries or stylesheets";
                SchemaException err = new SchemaException(msg);
                err.setLocator(member);
                throw err;
            }
            this.substitutionGroupMembers.add(member);
            if (this.substitutionGroupMembers.size() > 10) {
                this.substitutionGroupMembers = new HashSet<ElementDecl>(this.substitutionGroupMembers);
            }
            if (member != this) {
                for (UserComplexType type : this.complexTypesUsingThisElement) {
                    type.recompile(compiler);
                }
            }
        }
    }

    public synchronized void registerComplexTypeUsingThisElement(UserComplexType type) {
        if (!this.complexTypesUsingThisElement.contains(type)) {
            this.complexTypesUsingThisElement.add(type);
            if (this.complexTypesUsingThisElement.size() > 10) {
                this.complexTypesUsingThisElement = new HashSet<UserComplexType>(this.complexTypesUsingThisElement);
            }
        }
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstractDecl;
    }

    @Override
    public boolean isNillable() {
        return this.nillable;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstractDecl = isAbstract;
    }

    public void setBlock(int block) {
        this.block = block;
    }

    public void setFinalProhibitions(int finalValue) {
        this.finalProhibitions = finalValue;
    }

    @Override
    public void setValueConstraint(ValueConstraint vc) {
        this.valueConstraint = vc;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public void setElementName(StructuredQName elementName, int fingerprint) {
        this.elementName = elementName;
        this.fingerprint = fingerprint;
        this.targetNamespace = elementName.getNamespaceUri();
        this.substitutionGroupMembers.add(this);
    }

    public void setElementName(StructuredQName elementName) {
        this.elementName = elementName;
        this.fingerprint = this.getConfiguration().getNamePool().allocateFingerprint(elementName.getNamespaceUri(), elementName.getLocalPart());
        this.targetNamespace = elementName.getNamespaceUri();
        this.substitutionGroupMembers.add(this);
    }

    @Override
    public StructuredQName getComponentName() {
        return this.elementName;
    }

    @Override
    public int getFingerprint() {
        return this.fingerprint;
    }

    public void addSubstitutionGroupHead(StructuredQName qName) {
        if (this.substitutionGroupOwners == null) {
            this.substitutionGroupOwners = new ArrayList<SimpleComponentReference>(2);
        }
        SimpleComponentReference headRef = new SimpleComponentReference(801, qName, this.getConfiguration());
        headRef.setLocator(this);
        this.substitutionGroupOwners.add(headRef);
    }

    public void setTypeReference(TypeReference type) {
        this.typeReference = type;
    }

    public void addTypeAlternative(TypeAlternative alternative) {
        if (this.typeAlternatives == null) {
            this.typeAlternatives = new ArrayList<TypeAlternative>(5);
        }
        this.typeAlternatives.add(alternative);
    }

    @Override
    public boolean hasTypeAlternatives() {
        return this.typeAlternatives != null;
    }

    public List<TypeAlternative> getTypeAlternatives() {
        return this.typeAlternatives;
    }

    @Override
    public void lookForCycles(Stack<SchemaComponent> references, SchemaCompiler compiler) throws SchemaException {
        for (Object e : references) {
            ElementDecl member = (ElementDecl)e;
            if (member == this) {
                compiler.error("Element declaration " + this.getDisplayName() + " participates in a substitution group whose definition is circular", this);
                throw new SchemaException("Circular definition found");
            }
            this.addSubstitutionGroupMember(member, compiler);
        }
        if (this.substitutionGroupOwners != null) {
            references.push(this);
            for (ComponentReference componentReference : this.substitutionGroupOwners) {
                componentReference.tryToResolve(compiler, false);
                if (!componentReference.isResolved()) continue;
                ElementDecl head = (ElementDecl)componentReference.getTarget();
                head.lookForCycles(references, compiler);
            }
            references.pop();
        }
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        if (this.getFixupStatus() == SchemaValidationStatus.UNVALIDATED) {
            this.setFixupStatus(SchemaValidationStatus.VALIDATING);
            if (this.substitutionGroupOwners != null) {
                for (ComponentReference componentReference : this.substitutionGroupOwners) {
                    ElementDecl decl = (ElementDecl)PreparedSchema.validateReference(componentReference, compiler, false);
                    if (decl == null) {
                        this.setFixupStatus(SchemaValidationStatus.INVALID);
                        this.substitutionGroupOwners = null;
                        return false;
                    }
                    result = decl.fixup(compiler);
                }
            }
            if (this.typeReference != null && !this.typeReference.isDangling()) {
                SchemaType type;
                try {
                    type = (SchemaType)PreparedSchema.validateReference(this.typeReference, compiler, false);
                }
                catch (MissingComponentException missingComponentException) {
                    type = null;
                }
                if (type == null) {
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    this.typeReference = new TypeReference(575, this.getConfiguration(), this);
                    return false;
                }
                if (type instanceof UserSchemaComponent) {
                    result &= ((UserSchemaComponent)((Object)type)).fixup(compiler);
                }
            }
            if (this.hasTypeAlternatives()) {
                for (TypeAlternative typeAlternative : this.getTypeAlternatives()) {
                    result &= typeAlternative.fixup(compiler);
                }
            }
            for (IdentityConstraintReference identityConstraintReference : this.constraintRefs) {
                identityConstraintReference.tryToResolve(compiler, false);
            }
        }
        this.setFixupStatus(result ? SchemaValidationStatus.VALIDATED : SchemaValidationStatus.INVALID);
        return result;
    }

    @Override
    public NodeTest makeSchemaNodeTest() throws MissingComponentException {
        return new SchemaElementTest(this);
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        SchemaType type;
        if (!this.isValidationNeeded()) {
            return true;
        }
        this.setValidationStatus(SchemaValidationStatus.VALIDATING);
        boolean result = true;
        boolean checkFirstSubstitutionGroup = true;
        if (this.typeReference != null) {
            this.typeReference.tryToResolve(compiler, false);
        } else if (this.substitutionGroupOwners != null) {
            ElementDecl head = (ElementDecl)PreparedSchema.validateReference(this.substitutionGroupOwners.get(0), compiler, false);
            if (head != null) {
                SchemaType headType = head.getType();
                this.typeReference = new TypeReference(headType.getFingerprint(), this.getConfiguration(), this);
                this.typeReference.setTarget(headType);
                checkFirstSubstitutionGroup = false;
            } else {
                this.typeReference = new TypeReference(AnyType.getInstance().getFingerprint(), this.getConfiguration(), this);
                this.typeReference.setTarget(AnyType.getInstance());
                checkFirstSubstitutionGroup = false;
            }
        }
        if (this.typeReference != null) {
            PreparedSchema.validateReference(this.typeReference, compiler, false);
            if (!this.typeReference.isResolved()) {
                this.setValidationStatus(SchemaValidationStatus.INVALID);
                return true;
            }
        }
        if ((type = this.getType()) != null) {
            if (type.isComplexType()) {
                if (type instanceof UserComplexType) {
                    result = ((UserComplexType)type).validate(compiler);
                }
            } else if (type.isSimpleType()) {
                SimpleType simpleType = (SimpleType)type;
                if (simpleType instanceof UserSimpleType) {
                    result = ((UserSimpleType)simpleType).validate(compiler);
                }
                if (result && compiler.getLanguageVersion() == 10 && this.getValueConstraint() != null && simpleType.getBuiltInBaseType().getFingerprint() == 560) {
                    compiler.error("An element of type xs:ID must have no fixed or default value", this);
                    result = false;
                }
            }
            if (this.getFixedValue() != null) {
                result &= this.validateSimpleValue(type, "fixed", compiler);
            }
            if (this.getDefaultValueLexicalForm() != null) {
                result &= this.validateSimpleValue(type, "default", compiler);
            }
            boolean first = true;
            if (this.substitutionGroupOwners != null && checkFirstSubstitutionGroup) {
                for (ComponentReference componentReference : this.substitutionGroupOwners) {
                    ElementDecl head;
                    if ((checkFirstSubstitutionGroup || !first) && (head = (ElementDecl)PreparedSchema.validateReference(componentReference, compiler, false)) != null) {
                        SchemaType headType = head.getType();
                        try {
                            compiler.getConfiguration().checkTypeDerivationIsOK(type, headType, head.finalProhibitions);
                        }
                        catch (SchemaException err) {
                            compiler.error("Element " + this.getDisplayName() + " cannot be in the substitution group of " + head.getDisplayName() + ". " + err.getMessage(), this);
                            result = false;
                        }
                    }
                    if (compiler.getLanguageVersion() == 10 && !first) {
                        compiler.error("In XML Schema 1.0, an element can participate in one substitution group only", this);
                    }
                    first = false;
                }
            }
            for (IdentityConstraintReference identityConstraintReference : this.constraintRefs) {
                compiler.addPendingTypeCheck(identityConstraintReference, type);
            }
        }
        if (this.hasTypeAlternatives()) {
            for (TypeAlternative ta : this.getTypeAlternatives()) {
                SchemaType schemaType = ta.getSchemaType();
                if (schemaType instanceof UserDefinedType) {
                    result &= ((UserSchemaComponent)((Object)schemaType)).validate(compiler);
                }
                if (schemaType == ErrorType.getInstance()) continue;
                try {
                    compiler.getConfiguration().checkTypeDerivationIsOK(schemaType, type, this.finalProhibitions);
                }
                catch (SchemaException err) {
                    compiler.error("Invalid alternative type. " + err.getMessage(), ta);
                    result = false;
                }
            }
        }
        for (IdentityConstraintReference icr : this.constraintRefs) {
            icr.tryToResolve(compiler, false);
            if (!icr.isResolved()) {
                compiler.error("Cannot resolve integrity constraint reference " + icr.getTargetComponentName().getDisplayName(), this);
                return false;
            }
            IdentityConstraint identityConstraint = icr.getTarget();
            switch (icr.getExpectedKindOfConstraint()) {
                case 625: {
                    if (identityConstraint instanceof Unique) break;
                    compiler.error("Target of xs:unique reference must be an xs:unique element", icr);
                    result = false;
                    break;
                }
                case 599: {
                    if (identityConstraint instanceof Key) break;
                    compiler.error("Target of xs:key reference must be an xs:key element", icr);
                    result = false;
                    break;
                }
                case 600: {
                    if (identityConstraint instanceof KeyRef) break;
                    compiler.error("Target of xs:keyref reference must be an xs:keyref element", icr);
                    result = false;
                }
            }
        }
        this.setValidationStatus(result ? SchemaValidationStatus.VALIDATED : SchemaValidationStatus.INVALID);
        return result;
    }

    private String isValidlySubstitutable(ElementDecl other) throws MissingComponentException {
        int block = other.getBlock();
        if (this == other) {
            return null;
        }
        if ((block & 0x10) != 0) {
            return "substitution has been blocked";
        }
        boolean found = false;
        LinkedList<ElementDecl> unsearched = new LinkedList<ElementDecl>();
        unsearched.add(this);
        while (!unsearched.isEmpty()) {
            if (unsearched.contains(other)) {
                found = true;
                break;
            }
            ElementDecl first = (ElementDecl)unsearched.pollFirst();
            unsearched.addAll(first.getSubstitutionGroupOwners());
        }
        if (!found) {
            return "element declaration is not a member of the substitution group";
        }
        int actualDerivations = 0;
        int prohibitedDerivations = block;
        SchemaType t = this.getType();
        SchemaType ot = other.getType();
        if (ot == null) {
            ot = AnyType.getInstance();
        }
        while (t != null && t != AnyType.getInstance() && !t.isSameType(ot)) {
            actualDerivations |= t.getDerivationMethod();
            t = t.getBaseType();
            prohibitedDerivations |= t.getBlock();
        }
        if ((actualDerivations & prohibitedDerivations) != 0) {
            return "required type derivation method (extension or restriction) has been blocked";
        }
        return null;
    }

    private boolean validateSimpleValue(SchemaType type, String property, SchemaCompiler compiler) throws SchemaException {
        SimpleType simpleType;
        if (type.isSimpleType()) {
            simpleType = (SimpleType)type;
        } else if (((ComplexType)type).isSimpleContent()) {
            simpleType = ((ComplexType)type).getSimpleContentType();
        } else if (((ComplexType)type).isMixedContent()) {
            if (!((ComplexType)type).isEmptiable()) {
                compiler.error("An element with mixed content may have a " + property + " value only if its type is emptiable", this);
                return false;
            }
            simpleType = BuiltInAtomicType.STRING;
        } else {
            compiler.error("An element with a " + property + " value must have simple or mixed content", this);
            return false;
        }
        assert (simpleType != null);
        if (simpleType instanceof SimpleTypeDefinition) {
            boolean result = ((SimpleTypeDefinition)simpleType).validate(compiler);
            if (!result) {
                return false;
            }
            simpleType = ((SimpleTypeDefinition)simpleType).getWorkingType();
        }
        if (this.valueConstraint != null) {
            return this.valueConstraint.makeTypedValue(compiler, simpleType, this.getNamespaceResolver(), this);
        }
        return true;
    }

    protected void fixupSubstitutionGroup(SchemaCompiler compiler) throws SchemaException {
        if (this.substitutionGroupOwners != null) {
            for (ComponentReference componentReference : this.substitutionGroupOwners) {
                ElementDecl head = (ElementDecl)PreparedSchema.validateReference(componentReference, compiler, false);
                if (head != null) continue;
                String err = "Element " + Err.wrap(componentReference.getTargetComponentName().getDisplayName(), 1) + " is referenced as head of a substitution group for " + Err.wrap(this.getDisplayName()) + ", but is not declared in the schema";
                compiler.warning(err, "SXSD1003", this);
            }
            this.lookForCycles(new Stack<SchemaComponent>(), compiler);
        }
    }

    public boolean isSameDeclaration(ElementDecl other) {
        if (this == other) {
            return true;
        }
        if (this.getFingerprint() != other.getFingerprint()) {
            return false;
        }
        if (!this.generatedId.equals(other.generatedId)) {
            return false;
        }
        if (this.getBlock() != other.getBlock()) {
            return false;
        }
        if (this.getSubstitutionGroupExclusions() != other.getSubstitutionGroupExclusions()) {
            return false;
        }
        if (this.typeReference != null && other.typeReference != null) {
            if (this.typeReference.isAnonymousType()) {
                return other.typeReference.isAnonymousType();
            }
            return this.typeReference.getTargetFingerprint() == other.typeReference.getTargetFingerprint();
        }
        return true;
    }

    public boolean hasSameTypeTable(ElementDecl other) throws MissingComponentException {
        if (this.isSameDeclaration(other)) {
            return true;
        }
        if (this.typeAlternatives == null && other.typeAlternatives == null) {
            return true;
        }
        if (this.typeAlternatives == null || other.typeAlternatives == null) {
            return false;
        }
        if (this.typeAlternatives.size() != other.typeAlternatives.size()) {
            return false;
        }
        if (!this.getType().isSameType(other.getType())) {
            return false;
        }
        for (int i = 0; i < this.typeAlternatives.size(); ++i) {
            XPathExpression c1;
            TypeAlternative a0 = this.typeAlternatives.get(i);
            TypeAlternative a1 = other.typeAlternatives.get(i);
            XPathExpression c0 = a0.getCondition();
            if (c0 == null != ((c1 = a1.getCondition()) == null)) {
                return false;
            }
            if (c0 != null && !c0.getInternalExpression().isEqual(c1.getInternalExpression())) {
                return false;
            }
            if (!a0.getDefaultElementNamespace().equals(a1.getDefaultElementNamespace())) {
                return false;
            }
            if (!a0.getBaseURI().equals(a1.getBaseURI())) {
                return false;
            }
            if (!a0.getSchemaType().isSameType(a1.getSchemaType())) {
                return false;
            }
            HashSet<String> prefixes0 = new HashSet<String>();
            Iterator<String> it = a0.getNamespaceContext().iteratePrefixes();
            while (it.hasNext()) {
                prefixes0.add(it.next());
            }
            it = a1.getNamespaceContext().iteratePrefixes();
            while (it.hasNext()) {
                String prefix = it.next();
                if (prefixes0.contains(prefix)) continue;
                return false;
            }
            for (String p : prefixes0) {
                if (a0.getNamespaceContext().getURIForPrefix(p, false).equals(a1.getNamespaceContext().getURIForPrefix(p, false))) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "ElementDeclaration " + this.getName();
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("element");
        serializer.emitAttribute("id", id);
        if (this.getName() != null) {
            serializer.emitAttribute("name", this.getName());
            if (!this.getTargetNamespace().isEmpty()) {
                serializer.emitAttribute("targetNamespace", this.getTargetNamespace().toString());
            }
        }
        serializer.emitAttribute("type", serializer.getTypeLink(this.getType()));
        serializer.emitAttribute("global", this.isGlobal() ? "true" : "false");
        if (!this.isGlobal() && this.getContainingComplexType() != null) {
            serializer.emitAttribute("containingComplexType", serializer.getId(this.getContainingComplexType(), false));
        }
        if (this.getDefaultValueLexicalForm() != null) {
            serializer.emitAttribute("default", this.getDefaultValueLexicalForm().toString());
        }
        serializer.emitAttribute("nillable", this.isNillable() ? "true" : "false");
        if (this.finalProhibitions != 0) {
            String ex = "";
            if ((this.finalProhibitions & 2) != 0) {
                ex = "extension";
            }
            if ((this.finalProhibitions & 1) != 0) {
                ex = ex + (ex.isEmpty() ? "" : " ") + "restriction";
            }
            serializer.emitAttribute("final", ex);
        }
        if (this.block != 0) {
            String dis = "";
            if ((this.block & 2) != 0) {
                dis = "extension";
            }
            if ((this.block & 1) != 0) {
                dis = dis + (dis.isEmpty() ? "" : " ") + "restriction";
            }
            if ((this.block & 0x10) != 0) {
                dis = dis + (dis.isEmpty() ? "" : " ") + "substitution";
            }
            serializer.emitAttribute("block", dis);
        }
        serializer.emitAttribute("abstract", this.isAbstractDecl ? "true" : "false");
        if (this.substitutionGroupOwners != null) {
            for (ComponentReference componentReference : this.substitutionGroupOwners) {
                serializer.startElement("substitutionGroupAffiliation");
                serializer.emitAttribute("ref", serializer.getId(componentReference.getTarget(), false));
                serializer.endElement();
            }
        }
        if (this.hasTypeAlternatives()) {
            for (TypeAlternative typeAlternative : this.getTypeAlternatives()) {
                typeAlternative.serialize(serializer);
            }
        }
        for (IdentityConstraintReference identityConstraintReference : this.getIdentityConstraints()) {
            serializer.startElement("identityConstraint");
            serializer.emitAttribute("ref", serializer.getId(identityConstraintReference.getTarget(), false));
            serializer.endElement();
        }
        if (this.getValueConstraint() != null) {
            this.getValueConstraint().serialize(serializer);
        }
        serializer.endElement();
    }

    @Override
    public FunctionItem getComponentAsFunction() {
        ElementDecl thisDecl = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Element Declaration");
                }
                case "implementation": {
                    return new ObjectValue<ElementDecl>(thisDecl);
                }
                case "name": {
                    return new StringValue(this.getName(), (AtomicType)BuiltInAtomicType.NCNAME);
                }
                case "target namespace": {
                    return new AnyURIValue(this.getTargetNamespace().toUnicodeString());
                }
                case "type definition": {
                    return this.getType().getComponentAsFunction();
                }
                case "type table": {
                    if (this.hasTypeAlternatives()) {
                        CallableDelegate typeTable = new CallableDelegate((context1, arguments1) -> {
                            String key1;
                            switch (key1 = arguments1[0].head().getStringValue()) {
                                case "class": {
                                    return StringValue.bmp("Type Table");
                                }
                                case "alternatives": {
                                    ArrayList<FunctionItem> list = new ArrayList<FunctionItem>();
                                    for (TypeAlternative ta : this.getTypeAlternatives()) {
                                        list.add(ta.getComponentAsFunction());
                                    }
                                    return SequenceExtent.makeSequenceExtent(list);
                                }
                                case "default type definition": {
                                    return this.typeAlternatives.get(this.typeAlternatives.size() - 1).getComponentAsFunction();
                                }
                            }
                            return EmptySequence.getInstance();
                        });
                        return new CallableFunction(1, (Callable)typeTable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
                    }
                    return EmptySequence.getInstance();
                }
                case "scope": {
                    CallableDelegate scopeFunction = new CallableDelegate((context12, arguments12) -> {
                        String key12;
                        switch (key12 = ((StringValue)arguments12[0].head()).getStringValue()) {
                            case "class": {
                                return StringValue.bmp("Scope");
                            }
                            case "variety": {
                                return StringValue.bmp(this.isGlobal() ? "global" : "local");
                            }
                            case "parent": {
                                if (this.isGlobal()) {
                                    return EmptySequence.getInstance();
                                }
                                if (this.getContainingComplexType() != null) {
                                    return this.getContainingComplexType().getComponentAsFunction();
                                }
                                if (this.getContainingModelGroup() != null) {
                                    return this.getContainingModelGroup().getComponentAsFunction();
                                }
                                return EmptySequence.getInstance();
                            }
                        }
                        return EmptySequence.getInstance();
                    });
                    return new CallableFunction(1, (Callable)scopeFunction, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
                }
                case "value constraint": {
                    return this.getValueConstraintAsFunction(this);
                }
                case "nillable": {
                    return BooleanValue.get(this.isNillable());
                }
                case "identity-constraint definitions": {
                    ArrayList<FunctionItem> constraints = new ArrayList<FunctionItem>();
                    for (IdentityConstraintReference ic : this.getIdentityConstraints()) {
                        constraints.add(ic.getTarget().getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(constraints);
                }
                case "substitution group affiliations": {
                    ArrayList<FunctionItem> groups = new ArrayList<FunctionItem>();
                    for (ElementDecl decl : this.getSubstitutionGroupOwners()) {
                        groups.add(decl.getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(groups);
                }
                case "substitution group exclusions": {
                    ArrayList<AtomicValue> exclusions = new ArrayList<AtomicValue>();
                    if ((this.getSubstitutionGroupExclusions() & 2) != 0) {
                        exclusions.add(StringValue.bmp("extension"));
                    }
                    if ((this.getSubstitutionGroupExclusions() & 1) != 0) {
                        exclusions.add(StringValue.bmp("restriction"));
                    }
                    return new AtomicArray(exclusions);
                }
                case "disallowed substitutions": {
                    ArrayList<AtomicValue> exclusions = new ArrayList<AtomicValue>();
                    if ((this.getBlock() & 2) != 0) {
                        exclusions.add(StringValue.bmp("extension"));
                    }
                    if ((this.getBlock() & 1) != 0) {
                        exclusions.add(StringValue.bmp("restriction"));
                    }
                    if ((this.getBlock() & 0x10) != 0) {
                        exclusions.add(StringValue.bmp("substitution"));
                    }
                    return new AtomicArray(exclusions);
                }
                case "abstract": {
                    return BooleanValue.get(this.isAbstract());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ElementDecl)) {
            return false;
        }
        ElementDecl e2 = (ElementDecl)other;
        return this.getFingerprint() == e2.getFingerprint() && this.getTypeFingerprint() == e2.getTypeFingerprint() && this.getBlock() == e2.getBlock() && this.getSubstitutionGroupExclusions() == e2.getSubstitutionGroupExclusions() && (this.getFixedValueLexicalForm() == null || this.getFixedValueLexicalForm().equals(e2.getFixedValueLexicalForm()));
    }

    public int hashCode() {
        return this.getFingerprint() ^ this.getTypeFingerprint() << 10;
    }
}

