/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.ComponentWithValueConstraint;
import com.saxonica.ee.schema.Optionality;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SimpleComponentReference;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.ValueConstraint;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.sort.SimpleTypeComparison;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public final class AttributeUse
extends SimpleComponentReference
implements ComponentWithValueConstraint,
UserSchemaComponent {
    private Optionality useFlag = Optionality.OPTIONAL;
    private ValueConstraint valueConstraint;
    private NamespaceResolver namespaceResolver;
    private AttributeGroupDecl containingAttributeGroupDecl;
    private int inheritable = -1;

    public AttributeUse(EnterpriseConfiguration config) {
        this.setConfiguration(config);
        this.symbolSpace = 802;
    }

    @Override
    public void tryToResolve(SchemaCompiler compiler, boolean fatal) throws SchemaException {
        super.tryToResolve(compiler, fatal);
        if (this.isResolved()) {
            AttributeDecl decl = (AttributeDecl)this.target;
            if (!decl.isGlobal()) {
                decl.setContainingAttributeGroup(this.getContainingAttributeGroupDecl());
            }
        } else {
            String name = this.getTargetComponentName().getEQName();
            if (compiler.isAllowDanglingReferences() && !fatal) {
                compiler.warning("Unknown attribute declaration " + name + " (substituting dummy declaration)", "SXSD1001", this);
                AttributeDecl decl = new AttributeDecl(compiler.getConfiguration(), false);
                decl.setAttributeName(this.getTargetComponentName());
                decl.setSimpleType(BuiltInAtomicType.STRING);
                this.target = decl;
            } else {
                throw new SchemaException("Unknown attribute declaration " + name, this);
            }
        }
    }

    public AttributeDecl getAttributeDeclaration() throws MissingComponentException {
        return (AttributeDecl)this.getTarget();
    }

    public AttributeGroupDecl getContainingAttributeGroupDecl() {
        return this.containingAttributeGroupDecl;
    }

    public void setContainingAttributeGroupDecl(AttributeGroupDecl containingAttributeGroupDecl) {
        this.containingAttributeGroupDecl = containingAttributeGroupDecl;
    }

    public String getDisplayName() {
        return this.getTargetComponentName().getDisplayName();
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public String getUse() {
        switch (this.useFlag) {
            case PROHIBITED: {
                return "prohibited";
            }
            case REQUIRED: {
                return "required";
            }
        }
        return "optional";
    }

    public int getCardinality() {
        switch (this.useFlag) {
            case PROHIBITED: {
                return 8192;
            }
            case REQUIRED: {
                return 16384;
            }
        }
        return 24576;
    }

    @Override
    public ValueConstraint getValueConstraint() {
        return this.valueConstraint;
    }

    public UnicodeString getUnderlyingDefaultValue() throws MissingComponentException {
        if (this.getDefaultValueLexicalForm() == null) {
            AttributeDecl declaration = (AttributeDecl)this.getTarget();
            if (declaration != null) {
                return declaration.getDefaultValueLexicalForm();
            }
            return null;
        }
        return this.getDefaultValueLexicalForm();
    }

    public AtomicSequence getUnderlyingFixedValue() throws MissingComponentException {
        if (this.getFixedValue() == null) {
            AttributeDecl declaration = (AttributeDecl)this.getTarget();
            if (declaration != null) {
                return declaration.getFixedValue();
            }
            return null;
        }
        return this.getFixedValue();
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    public boolean isOptional() {
        return this.useFlag == Optionality.OPTIONAL;
    }

    public boolean isProhibited() {
        return this.useFlag == Optionality.PROHIBITED;
    }

    public boolean isRequired() {
        return this.useFlag == Optionality.REQUIRED;
    }

    public void setUse(Optionality value) {
        this.useFlag = value;
    }

    @Override
    public void setValueConstraint(ValueConstraint vc) {
        this.valueConstraint = vc;
    }

    public void setInheritable(int inherit) {
        this.inheritable = inherit;
    }

    public boolean isInheritable() throws MissingComponentException {
        switch (this.inheritable) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return ((AttributeDecl)this.getTarget()).isInheritable();
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        PreparedSchema.validateReference(this, compiler, false);
        this.setValidationStatus(SchemaValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean ok;
        this.tryToResolve(compiler, false);
        if (!this.isResolved()) {
            return false;
        }
        AttributeDecl declaration = (AttributeDecl)this.getTarget();
        boolean result = declaration.validate(compiler);
        if (!result) {
            return false;
        }
        SimpleType stype = declaration.getType();
        EnterpriseConfiguration config = compiler.getConfiguration();
        if (compiler.getLanguageVersion() == 10 && (this.getFixedValue() != null || this.getDefaultValueLexicalForm() != null) && stype.getBuiltInBaseType().getFingerprint() == 560) {
            compiler.error("An attribute of type xs:ID must have no fixed or default value", this);
            return false;
        }
        if (this.valueConstraint != null && !(ok = this.valueConstraint.makeTypedValue(compiler, stype, this.namespaceResolver, this))) {
            return false;
        }
        AtomicSequence fixedVal = declaration.getFixedValue();
        if (fixedVal != null) {
            if (this.getDefaultValueLexicalForm() != null) {
                String err = "An attribute reference " + Err.wrap(this.getDisplayName(), 2) + " cannot have a default value if the attribute declaration has a fixed value";
                compiler.error(err, this);
                return false;
            }
            AtomicSequence thisFixedValue = this.getFixedValue();
            if (thisFixedValue != null && !SimpleTypeComparison.getInstance().equal(thisFixedValue, fixedVal)) {
                String err = "The attribute reference " + Err.wrap(this.getDisplayName(), 2) + " and the corresponding declaration have different fixed values";
                compiler.error(err, this);
                return false;
            }
        }
        return true;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        if (!this.isProhibited()) {
            serializer.startElement("attributeUse");
            serializer.emitAttribute("required", this.isRequired() ? "true" : "false");
            serializer.emitAttribute("inheritable", this.isInheritable() ? "true" : "false");
            serializer.emitAttribute("ref", serializer.getId(this.getAttributeDeclaration(), false));
            if (this.getDefaultValueLexicalForm() != null) {
                serializer.emitAttribute("default", this.getDefaultValueLexicalForm().toString());
            }
            if (this.getValueConstraint() != null) {
                this.getValueConstraint().serialize(serializer);
            }
            serializer.endElement();
        }
    }

    @Override
    public FunctionItem getComponentAsFunction() {
        AttributeUse thisAttributeUse = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Attribute Use");
                }
                case "implementation": {
                    return new ObjectValue<AttributeUse>(thisAttributeUse);
                }
                case "required": {
                    return BooleanValue.get(this.isRequired());
                }
                case "attribute declaration": {
                    return this.getAttributeDeclaration().getComponentAsFunction();
                }
                case "value constraint": {
                    return this.getValueConstraintAsFunction(this);
                }
                case "inheritable": {
                    return BooleanValue.get(this.isInheritable());
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

