/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupReference;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.Wildcard;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.expr.sort.SimpleTypeComparison;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntToIntArrayMap;
import net.sf.saxon.z.IntToIntHashMap;
import net.sf.saxon.z.IntToIntMap;

public final class AttributeGroupDecl
extends SchemaStructure
implements UserSchemaComponent,
SerializableSchemaComponent {
    private final List<AttributeUse> attributes;
    private final List<AttributeGroupReference> references;
    private AttributeWildcard anyAttribute = null;
    private StructuredQName attributeGroupName;
    private IntHashMap<AttributeUse> declaredAttributes = null;
    private IntToIntMap counterMap;
    private AttributeGroupDecl redefinedAttributeGroup;

    public AttributeGroupDecl(EnterpriseConfiguration config) {
        this.setConfiguration(config);
        this.attributes = new ArrayList<AttributeUse>(10);
        this.references = new ArrayList<AttributeGroupReference>(10);
    }

    public StructuredQName getAttributeGroupName() {
        return this.attributeGroupName;
    }

    public String getName() {
        return this.attributeGroupName.getLocalPart();
    }

    public NamespaceUri getTargetNamespace() {
        return this.attributeGroupName.getNamespaceUri();
    }

    public void addAttributeUse(AttributeUse use) {
        if (use == null) {
            return;
        }
        this.attributes.add(use);
    }

    public void addAttributeGroupReference(AttributeGroupReference attrGroup) {
        if (attrGroup == null) {
            return;
        }
        this.references.add(attrGroup);
    }

    public void setRedefinedAttributeGroupDecl(AttributeGroupDecl other) {
        this.redefinedAttributeGroup = other;
    }

    public List<AttributeUse> getLocalAttributes() {
        return this.attributes;
    }

    public List<AttributeGroupReference> getLocalAttributeGroupReferences() {
        return this.references;
    }

    @Override
    public void lookForCycles(Stack<SchemaComponent> references, SchemaCompiler compiler) throws SchemaException {
        if (compiler.getLanguageVersion() == 11) {
            return;
        }
        if (references.contains(this)) {
            throw new SchemaException("The definition of attribute group " + Err.wrap(this.getAttributeGroupName().getDisplayName()) + " is circular", this);
        }
        references.push(this);
        for (AttributeGroupReference group : this.getLocalAttributeGroupReferences()) {
            group.lookForCycles(references, compiler);
        }
        references.pop();
    }

    public AttributeWildcard getLocalAttributeWildcard() {
        return this.anyAttribute;
    }

    public AttributeWildcard getAttributeWildcard(SchemaCompiler compiler) {
        return this.getAttributeWildcard(compiler, new Stack<AttributeGroupDecl>());
    }

    AttributeWildcard getAttributeWildcard(SchemaCompiler compiler, Stack<AttributeGroupDecl> stack) {
        Wildcard wat;
        AttributeWildcard awc = this.getLocalAttributeWildcard();
        Wildcard wildcard = wat = awc == null ? null : awc.getWildcard();
        if (stack.contains(this)) {
            return null;
        }
        stack.push(this);
        for (AttributeGroupReference ref : this.getLocalAttributeGroupReferences()) {
            AttributeWildcard gawc = ref.getAttributeWildcard(compiler, stack);
            Wildcard gat = gawc == null ? null : gawc.getWildcard();
            if (gat == null) continue;
            if (wat == null) {
                wat = gat;
                continue;
            }
            wat = Wildcard.makeIntersection(wat, gat, this.getConfiguration().getNamePool());
        }
        stack.pop();
        return wat == null ? null : new AttributeWildcard(wat);
    }

    public List<AttributeUse> getAttributeUses() throws MissingComponentException {
        ArrayList<AttributeUse> list = new ArrayList<AttributeUse>(20);
        this.gatherAttributeUses(list);
        return list;
    }

    private void gatherAttributeUses(List<AttributeUse> list) throws MissingComponentException {
        this.gatherAttributeUses(list, new Stack<AttributeGroupDecl>());
    }

    private void gatherAttributeUses(List<AttributeUse> list, Stack<AttributeGroupDecl> stack) throws MissingComponentException {
        list.addAll(this.attributes);
        for (AttributeGroupReference reference : this.references) {
            AttributeGroupDecl decl = (AttributeGroupDecl)reference.getTarget();
            stack.push(this);
            if (!stack.contains(decl)) {
                decl.gatherAttributeUses(list, stack);
            }
            stack.pop();
        }
    }

    public IntToIntMap getCounterMap() {
        return this.counterMap;
    }

    public String getDisplayName() {
        return this.attributeGroupName.getDisplayName();
    }

    public void setAnyAttribute(AttributeWildcard wildcard) {
        this.anyAttribute = wildcard;
    }

    @Override
    public boolean fixup(SchemaCompiler compiler) throws SchemaException {
        if (this.getFixupStatus() == SchemaValidationStatus.UNVALIDATED) {
            boolean b;
            SchemaStructure decl;
            this.setFixupStatus(SchemaValidationStatus.VALIDATING);
            for (AttributeUse use : this.attributes) {
                decl = (AttributeDecl)PreparedSchema.validateReference(use, compiler, false);
                if (decl == null) {
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    continue;
                }
                b = ((AttributeDecl)decl).fixup(compiler);
                if (b) continue;
                this.setFixupStatus(SchemaValidationStatus.INVALID);
            }
            for (AttributeGroupReference ref : this.references) {
                decl = (AttributeGroupDecl)PreparedSchema.validateReference(ref, compiler, false);
                if (decl == null) {
                    ref.setFixupStatus(SchemaValidationStatus.INVALID);
                    this.setFixupStatus(SchemaValidationStatus.INVALID);
                    continue;
                }
                b = ((AttributeGroupDecl)decl).fixup(compiler);
                if (b) continue;
                this.setFixupStatus(SchemaValidationStatus.INVALID);
            }
            if (this.getFixupStatus() == SchemaValidationStatus.INVALID) {
                return false;
            }
            this.lookForCycles(new Stack<SchemaComponent>(), compiler);
        }
        this.setFixupStatus(SchemaValidationStatus.VALIDATED);
        return true;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        if (this.getFixupStatus() == SchemaValidationStatus.UNVALIDATED) {
            result = this.fixup(compiler);
        }
        if (this.getFixupStatus() == SchemaValidationStatus.INVALID) {
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        switch (this.getValidationStatus()) {
            case VALIDATED: 
            case INVALID: {
                return true;
            }
            case VALIDATING: {
                compiler.error("The definition of attribute group " + Err.wrap(this.getAttributeGroupName().getDisplayName()) + " is circular", this);
                return false;
            }
        }
        this.setValidationStatus(SchemaValidationStatus.VALIDATING);
        for (AttributeUse att : this.attributes) {
            result &= att.validate(compiler);
        }
        for (AttributeGroupReference ref : this.references) {
            result &= ref.validate(compiler);
        }
        if (!result) {
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        AttributeWildcard wild = this.getAttributeWildcard(compiler);
        if (wild != null) {
            result = wild.validate(compiler);
        }
        if (result) {
            String foundID = null;
            ArrayList<AttributeUse> attributeList = new ArrayList<AttributeUse>();
            this.gatherAttributeUses(attributeList);
            HashSet<StructuredQName> fingerprintSet = new HashSet<StructuredQName>(attributeList.size() * 2);
            TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
            for (AttributeUse att : attributeList) {
                StructuredQName key;
                if (!(result &= att.validate(compiler))) continue;
                AttributeDecl decl = (AttributeDecl)att.getTarget();
                SimpleType stype = decl.getSimpleType();
                if (stype.isAtomicType() && stype.getFingerprint() != 573 && th.isSubType((AtomicType)stype, BuiltInAtomicType.ID)) {
                    if (foundID != null && compiler.getLanguageVersion() == 10) {
                        compiler.error("Attribute group contains more than one ID attribute (" + foundID + ", " + att.getDisplayName() + ')', this);
                        result = false;
                    }
                    foundID = att.getDisplayName();
                }
                if (fingerprintSet.contains(key = att.getTargetComponentName())) {
                    compiler.error("Attribute " + Err.wrap(key.getDisplayName(), 2) + " appears more than once in attribute group", this);
                    result = false;
                }
                fingerprintSet.add(key);
            }
            this.buildCounterMap();
        }
        if (this.redefinedAttributeGroup != null) {
            result &= this.isValidRestriction(this.redefinedAttributeGroup, compiler);
        }
        this.getDeclaredAttributes();
        this.setValidationStatus(SchemaValidationStatus.VALIDATED);
        return result;
    }

    public void buildCounterMap() throws MissingComponentException {
        ArrayList<AttributeUse> attributeList = new ArrayList<AttributeUse>();
        this.gatherAttributeUses(attributeList);
        int size = attributeList.size();
        this.counterMap = size < 8 ? new IntToIntArrayMap(size + 2) : new IntToIntHashMap(size + 2);
        int counterIndex = 0;
        for (AttributeUse att : attributeList) {
            int key = att.getAttributeDeclaration().getFingerprint();
            this.counterMap.put(key, counterIndex++);
        }
    }

    public boolean isValidRestriction(AttributeGroupDecl base, SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        for (AttributeUse att : this.getAttributeUses()) {
            AtomicSequence attFixed;
            AtomicSequence baseFixed;
            if (att.isProhibited()) continue;
            StructuredQName targetName = att.getTargetComponentName();
            AttributeUse baseAtt = base.getAttributeUse(targetName);
            if (baseAtt == null || baseAtt.isProhibited()) {
                AttributeWildcard baseWildCard = base.getAttributeWildcard(compiler);
                if (baseWildCard == null) {
                    compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is " + (baseAtt == null ? "not defined" : "prohibited") + " in the base type", this);
                    result = false;
                    continue;
                }
                if (baseWildCard.getWildcard().matches(att.getTargetComponentName(), false, (Configuration)this.getConfiguration(), null)) continue;
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is " + (baseAtt == null ? "not defined" : "prohibited") + " in the base type", this);
                result = false;
                continue;
            }
            if (baseAtt.isRequired() && !att.isRequired()) {
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is optional but the base attribute is required", this);
                result = false;
            }
            if (baseAtt.isInheritable() != att.isInheritable()) {
                if (att.isInheritable()) {
                    compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is inheritable, but the corresponding attribute in the base type is not", this);
                } else {
                    compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is not inheritable, but the corresponding attribute in the base type is", this);
                }
                result = false;
            }
            AttributeDecl decl = (AttributeDecl)att.getTarget();
            AttributeDecl baseDecl = (AttributeDecl)baseAtt.getTarget();
            String reason = UserSimpleType.isTypeDerivationOK(decl.getSimpleType(), baseDecl.getSimpleType(), 0);
            if (reason != null) {
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " is inconsistent with the base type. " + reason, this);
                result = false;
            }
            if ((baseFixed = baseAtt.getFixedValue()) == null) {
                baseFixed = baseDecl.getFixedValue();
            }
            if (baseFixed == null) continue;
            if (att.getUnderlyingDefaultValue() != null) {
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " has a default value but the base attribute is fixed", this);
                result = false;
            }
            if ((attFixed = att.getUnderlyingFixedValue()) != null && !SimpleTypeComparison.getInstance().equal(attFixed, baseFixed)) {
                compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " has a fixed value different from that of the base attribute", this);
                result = false;
                continue;
            }
            if (attFixed != null) continue;
            compiler.error("Invalid restriction: attribute " + Err.wrap(att.getDisplayName(), 2) + " must have the same fixed value as the base attribute", this);
            result = false;
        }
        for (AttributeUse baseAtt : base.getAttributeUses()) {
            AttributeUse thisAtt;
            if (!baseAtt.isRequired() || (thisAtt = this.getAttributeUse(baseAtt.getTargetComponentName())) != null) continue;
            compiler.error("Invalid restriction: base type has a required attribute " + Err.wrap(baseAtt.getDisplayName(), 2), this);
            result = false;
        }
        AttributeWildcard wild = this.getAttributeWildcard(compiler);
        if (wild != null) {
            AttributeWildcard baseWild = base.getAttributeWildcard(compiler);
            if (baseWild == null) {
                compiler.error("Invalid restriction: this type has an <xs:anyAttribute> but the base type does not", this);
                return false;
            }
            if (!wild.getWildcard().isSubset(baseWild.getWildcard(), compiler.getNamePool())) {
                compiler.error("Invalid restriction: this type has an <anyAttribute> wildcard which allows attribute names that are not permitted by the <anyAttribute> on the base type", this);
                return false;
            }
            if (baseWild.getWildcard().compareStrength(wild.getWildcard()) > 0) {
                compiler.error("Invalid <anyAttribute> restriction: this type has a weaker processContents than the base type", this);
                return false;
            }
        }
        return result;
    }

    public boolean isSameDeclaration(AttributeGroupDecl other) {
        return this == other || this.getAttributeGroupName().equals(other.getAttributeGroupName()) && this.hasSameLocation(other);
    }

    public void setAttributeGroupName(StructuredQName name) {
        this.attributeGroupName = name;
    }

    public IntHashMap<AttributeUse> getDeclaredAttributes() throws MissingComponentException {
        if (this.declaredAttributes == null) {
            IntHashMap<AttributeUse> map = new IntHashMap<AttributeUse>(10);
            for (AttributeUse att : this.getAttributeUses()) {
                map.put(att.getAttributeDeclaration().getFingerprint(), att);
            }
            this.declaredAttributes = map;
        }
        return this.declaredAttributes;
    }

    public final AttributeUse getAttributeUse(StructuredQName attributeName) throws MissingComponentException {
        for (AttributeUse att : this.getAttributeUses()) {
            if (!att.getTargetComponentName().equals(attributeName)) continue;
            return att;
        }
        return null;
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("attributeGroup");
        serializer.emitAttribute("id", id);
        serializer.emitAttribute("name", this.getName());
        if (this.getTargetNamespace() != null && !this.getTargetNamespace().isEmpty()) {
            serializer.emitAttribute("targetNamespace", this.getTargetNamespace().toString());
        }
        this.serializeContents(serializer);
        serializer.endElement();
    }

    public void serializeContents(SchemaModelSerializer serializer) throws XPathException {
        for (AttributeUse att : this.getAttributeUses()) {
            att.serialize(serializer);
        }
        if (this.getAttributeWildcard(null) != null) {
            this.getAttributeWildcard(null).serialize(serializer);
        }
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        this.buildCounterMap();
    }

    @Override
    public FunctionItem getComponentAsFunction() {
        AttributeGroupDecl thisDecl = this;
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Attribute Group Definition");
                }
                case "implementation": {
                    return new ObjectValue<AttributeGroupDecl>(thisDecl);
                }
                case "name": {
                    return new StringValue(this.getName(), (AtomicType)BuiltInAtomicType.NCNAME);
                }
                case "target namespace": {
                    return new AnyURIValue(this.getTargetNamespace().toUnicodeString());
                }
                case "attribute uses": {
                    ArrayList<FunctionItem> uses = new ArrayList<FunctionItem>();
                    for (AttributeUse use : this.getAttributeUses()) {
                        uses.add(use.getComponentAsFunction());
                    }
                    return SequenceExtent.makeSequenceExtent(uses);
                }
                case "attribute wildcard": {
                    if (this.getLocalAttributeWildcard() != null) {
                        return this.getLocalAttributeWildcard().getComponentAsFunction();
                    }
                    return EmptySequence.getInstance();
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

