/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.parallel;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.trans.Outcome;
import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.java.CleanerProxy;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class PushToPull {
    private final PushEvaluator expression;
    private final XPathContext context;
    private final BlockingQueue<Outcome<Item>> queue = new ArrayBlockingQueue<Outcome<Item>>(50);
    private static final Item STOPPER = StringValue.bmp("finished");

    public PushToPull(PushEvaluator expression, XPathContext context) {
        this.expression = expression;
        this.context = context;
    }

    public SequenceIterator getIterator() {
        EnterpriseConfiguration config = (EnterpriseConfiguration)this.context.getConfiguration();
        Thread provider = config.getMultithreadingFactory().makeThread(new Provider(this.expression, this.queue, this.context));
        provider.start();
        return new PushToPullIterator(provider, this.queue, this.context);
    }

    private static class PushToPullIterator
    implements SequenceIterator,
    Closeable {
        private final Thread provider;
        private final BlockingQueue<Outcome<Item>> queue;
        private boolean allDone = false;
        private final CleanerProxy.CleanableProxy cleanable;

        public PushToPullIterator(Thread provider, BlockingQueue<Outcome<Item>> queue, XPathContext context) {
            this.provider = provider;
            this.queue = queue;
            this.cleanable = context.getConfiguration().registerCleanupAction(provider, PushToPullIterator.getCleaningAction(provider));
        }

        @Override
        public Item next() {
            if (this.allDone) {
                return null;
            }
            try {
                Outcome<Item> next = this.queue.take();
                if (next.isSuccess()) {
                    Item item = next.getResult();
                    if (item == STOPPER) {
                        this.allDone = true;
                        return null;
                    }
                    return item;
                }
                XPathException xpe = XPathException.makeXPathException(next.getException());
                throw new UncheckedXPathException(xpe);
            }
            catch (InterruptedException e) {
                XPathException xpie = XPathException.makeXPathException(e);
                throw new UncheckedXPathException(xpie);
            }
        }

        @Override
        public void close() {
            this.allDone = true;
            if (this.cleanable != null) {
                this.cleanable.clean();
            } else if (this.provider != null) {
                this.provider.interrupt();
            }
        }

        private static Runnable getCleaningAction(Thread provider) {
            return () -> provider.interrupt();
        }
    }

    private static class Provider
    implements Runnable {
        private final XPathContext context;
        private final BlockingQueue<Outcome<Item>> queue;
        private final PushEvaluator expression;

        public Provider(PushEvaluator expression, BlockingQueue<Outcome<Item>> queue, XPathContext context) {
            this.expression = expression;
            this.queue = queue;
            this.context = context;
        }

        @Override
        public void run() {
            PipelineConfiguration pipe = this.context.getController().makePipelineConfiguration();
            pipe.setXPathContext(this.context);
            QueueWriter q = new QueueWriter(this.queue, pipe);
            try {
                TailCall tc = this.expression.processLeavingTail(new ComplexContentOutputter(q), this.context);
                Expression.dispatchTailCall(tc);
                q.write(STOPPER);
            }
            catch (QuitParsingException quit) {
                if (!quit.isNotifiedByConsumer()) {
                    try {
                        q.write(STOPPER);
                    }
                    catch (XPathException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (XPathException err) {
                q.notify(err);
            }
        }
    }

    private static class QueueWriter
    extends SequenceWriter {
        private final BlockingQueue<Outcome<Item>> queue;

        public QueueWriter(BlockingQueue<Outcome<Item>> queue, PipelineConfiguration pipe) {
            super(pipe);
            this.queue = queue;
        }

        @Override
        public void write(Item item) throws XPathException {
            if (Thread.currentThread().isInterrupted()) {
                throw new QuitParsingException(true);
            }
            try {
                this.queue.put(new Outcome<Item>(item));
            }
            catch (InterruptedException e) {
                throw new QuitParsingException(true);
            }
        }

        public void notify(XPathException exception) {
            try {
                this.queue.clear();
                this.queue.put(new Outcome(exception));
            }
            catch (InterruptedException e) {
                System.err.println("Caught interruption");
            }
        }
    }
}

