/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.parallel;

import com.saxonica.config.EnterpriseConfiguration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Supplier;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.java.CleanerProxy;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.iter.ManualIterator;

public final class MultithreadedContextMappingIterator
implements SequenceIterator {
    private final FocusIterator base;
    private final PullEvaluator action;
    private final XPathContextMinor context;
    private SequenceIterator stepIterator = null;
    private final Supplier<Integer> lastPositionFinder;
    private final ExecutorService service;
    private final BlockingQueue<Future<GroundedValue>> resultQueue = new LinkedBlockingQueue<Future<GroundedValue>>();
    private SequenceIterator dischargedIterator;
    private CleanerProxy.CleanableProxy cleanable;

    public MultithreadedContextMappingIterator(PullEvaluator action, XPathContextMinor context, int threads) throws XPathException {
        this.base = context.getCurrentIterator();
        this.action = action;
        this.context = context;
        this.lastPositionFinder = CSharp.methodRef(context::getLast);
        EnterpriseConfiguration config = (EnterpriseConfiguration)context.getConfiguration();
        this.service = config.getMultithreadingFactory().makeExecutorService(threads);
        int n = 0;
        int max = threads * 3;
        try {
            while (++n <= max) {
                Item item = this.base.next();
                if (item == null) {
                    return;
                }
                this.mapOneItem(context);
            }
        }
        catch (UncheckedXPathException e) {
            this.close();
            throw e.getXPathException();
        }
        this.cleanable = config.registerCleanupAction(this, MultithreadedContextMappingIterator.getCleaningAction(this.service));
    }

    @Override
    public Item next() {
        Item nextItem;
        if (this.dischargedIterator != null) {
            return this.dischargedIterator.next();
        }
        while (true) {
            Item item;
            Future future;
            if (this.stepIterator != null) {
                nextItem = this.stepIterator.next();
                if (nextItem != null) break;
                this.stepIterator = null;
            }
            if ((future = (Future)this.resultQueue.poll()) == null) {
                this.close();
                return null;
            }
            try {
                this.stepIterator = ((GroundedValue)future.get()).iterate();
            }
            catch (InterruptedException e) {
                throw new UncheckedXPathException(e);
            }
            catch (ExecutionException e) {
                this.close();
                if (e.getCause() instanceof XPathException) {
                    throw new UncheckedXPathException((XPathException)e.getCause());
                }
                if (e.getCause() instanceof UncheckedXPathException) {
                    throw (UncheckedXPathException)e.getCause();
                }
                throw new UncheckedXPathException(e);
            }
            if (this.stepIterator == null) {
                return null;
            }
            if (this.base.current() != null && (item = this.base.next()) != null) {
                this.mapOneItem(this.context);
            }
            if ((nextItem = this.stepIterator.next()) != null) break;
            this.stepIterator = null;
        }
        return nextItem;
    }

    @Override
    public void close() {
        this.base.close();
        if (this.cleanable != null) {
            this.cleanable.clean();
        } else if (this.service != null) {
            this.service.shutdown();
        }
    }

    private static Runnable getCleaningAction(ExecutorService service) {
        return service::shutdown;
    }

    private void mapOneItem(XPathContextMinor context) {
        Future<GroundedValue> future;
        XPathContextMajor c3 = XPathContextMajor.newThreadContext(context);
        FocusIterator base = context.getCurrentIterator();
        ManualIterator manualIterator = new ManualIterator(base.current(), base.position());
        manualIterator.setLengthFinder(this.lastPositionFinder);
        c3.setCurrentIterator(manualIterator);
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        pipe.setXPathContext(context);
        int attempts = 0;
        while (true) {
            try {
                future = this.service.submit(() -> {
                    try {
                        return SequenceTool.toGroundedValue(this.action.iterate(c3));
                    }
                    catch (XPathException err) {
                        this.close();
                        throw err;
                    }
                    catch (UncheckedXPathException err) {
                        this.close();
                        throw err.getXPathException();
                    }
                });
            }
            catch (RejectedExecutionException e) {
                if (this.service.isShutdown()) {
                    return;
                }
                if (attempts++ < 10) {
                    try {
                        Thread.sleep(1L << attempts);
                    }
                    catch (InterruptedException e1) {
                        this.close();
                        throw e;
                    }
                    continue;
                }
                this.close();
                throw e;
            }
            break;
        }
        this.resultQueue.add(future);
    }
}

