/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.stream.ContentDetector;
import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.StreamInstr;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.watch.StreamWatch;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.om.MutableNodeInfo;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.UpdateAgent;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;

public class XQueryExpressionEE
extends XQueryExpression {
    private boolean allowDocumentProjection;
    private final boolean isUpdating;
    private PathMap pathMap;
    private Inversion inversion;
    PushEvaluator pusher = null;

    public XQueryExpressionEE(Expression exp, QueryModule mainModule, boolean streaming) throws XPathException {
        super(exp, mainModule, streaming);
        boolean isUpdatingExpression;
        Configuration config = mainModule.getConfiguration();
        if (config.isLicensedFeature(4)) {
            PackageData pd = mainModule.getPackageData();
            ExpressionTool.processExpressionTree(this.expression, null, (expr, result) -> {
                Expression fallback;
                if (expr instanceof StreamInstr && (fallback = ((StreamInstr)expr).prepareForStreaming(pd)) != expr) {
                    if (expr == this.expression) {
                        this.expression = fallback;
                    } else {
                        Expression parent = expr.getParentExpression();
                        for (Operand o : parent.operands()) {
                            if (o.getChildExpression() != expr) continue;
                            o.setChildExpression(fallback);
                        }
                    }
                    return true;
                }
                return false;
            });
        }
        if (streaming && config.isLicensedFeature(4)) {
            ContextItemStaticInfoEE contextInfo;
            PostureAndSweep ps;
            if (!ExpressionTool.dependsOnFocus(exp)) {
                throw new XPathException("Streaming is not possible because the query does not use the context item");
            }
            Iterator<GlobalVariable> it = mainModule.getModuleVariables();
            while (it.hasNext()) {
                GlobalVariable gVar = it.next();
                if (gVar.getBody() == null || !ExpressionTool.dependsOnFocus(gVar.getBody())) continue;
                throw new XPathException("Streaming is not possible because a variable $" + gVar.getObjectName().getDisplayName() + " depends on the context item");
            }
            ArrayList<String> reasons = new ArrayList<String>();
            ItemType contextItemType = AnyItemType.getInstance();
            GlobalContextRequirement req = mainModule.getExecutable().getGlobalContextRequirement();
            if (req != null) {
                contextItemType = req.getRequiredItemType();
            }
            if ((ps = Streamability.getStreamability(this.expression, contextInfo = new ContextItemStaticInfoEE(contextItemType, false, Posture.STRIDING), reasons)).getPosture() == Posture.ROAMING || ps.getSweep() == Sweep.FREE_RANGING) {
                StringBuilder fsb = new StringBuilder(256);
                fsb.append("Streaming is not possible. ");
                for (String r : reasons) {
                    fsb.append(r);
                    fsb.append(". ");
                }
                throw new XPathException(fsb.toString(), "XTSE3430");
            }
            this.inversion = Inversion.invertExpression(this.expression, false);
        }
        this.isUpdating = isUpdatingExpression = mainModule.isUpdating() && this.expression.isUpdatingExpression();
    }

    @Override
    protected void processQuery(Outputter dest, XPathContext context) throws XPathException {
        if (this.pusher == null) {
            this.pusher = this.expression.makeElaborator().elaborateForPush();
        }
        TailCall tc = this.pusher.processLeavingTail(dest, context);
        Expression.dispatchTailCall(tc);
    }

    @Override
    public boolean isUpdateQuery() {
        return this.isUpdating;
    }

    @Override
    public void setAllowDocumentProjection(boolean allowed) {
        this.allowDocumentProjection = allowed;
    }

    @Override
    public boolean isDocumentProjectionAllowed() {
        return this.allowDocumentProjection;
    }

    public PathMap getPathMap() {
        if (this.pathMap == null) {
            this.pathMap = new PathMap(this.expression);
        }
        for (PackageData pack : this.getExecutable().getPackages()) {
            for (GlobalVariable var : pack.getGlobalVariableList()) {
                Expression select;
                if (var.isUnused() || (select = var.getBody()) == null) continue;
                select.addToPathMap(this.pathMap, null);
            }
        }
        return this.pathMap;
    }

    @Override
    public Controller newController(DynamicQueryContext env) throws XPathException {
        Controller controller = new Controller(this.executable.getConfiguration(), this.executable);
        if (this.isUpdateQuery() && !controller.getModel().isMutable()) {
            controller.setModel(TreeModel.LINKED_TREE);
        }
        env.initializeController(controller);
        if (this.allowDocumentProjection) {
            controller.setUseDocumentProjection(this.getPathMap());
        }
        return controller;
    }

    @Override
    public Set<MutableNodeInfo> runUpdate(DynamicQueryContext dynamicEnv) throws XPathException {
        if (!this.isUpdating) {
            throw new XPathException("Calling runUpdate() on a non-updating query");
        }
        Configuration config = this.executable.getConfiguration();
        Controller controller = this.newController(dynamicEnv);
        XPathContextMajor context = this.initialContext(dynamicEnv, controller);
        try {
            PendingUpdateList pul = config.newPendingUpdateList();
            context.openStackFrame(this.stackFrameMap);
            this.expression.makeElaborator().elaborateForUpdate().registerUpdates(context, pul);
            pul.apply(context, this.mainModule.getRevalidationMode());
            Set<MutableNodeInfo> set = pul.getAffectedTrees();
            return set;
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                XmlProcessingException error = new XmlProcessingException(e);
                controller.getErrorReporter().report(error);
            }
            throw e;
        }
        finally {
            if (controller.getTraceListener() != null) {
                controller.getTraceListener().close();
            }
        }
    }

    @Override
    public void runUpdate(DynamicQueryContext dynamicEnv, UpdateAgent agent) throws XPathException {
        if (!this.isUpdating) {
            throw new XPathException("Calling runUpdate() on a non-updating query");
        }
        Configuration config = this.executable.getConfiguration();
        Controller controller = this.newController(dynamicEnv);
        XPathContextMajor context = this.initialContext(dynamicEnv, controller);
        try {
            PendingUpdateList pul = config.newPendingUpdateList();
            context.openStackFrame(this.stackFrameMap);
            this.expression.makeElaborator().elaborateForUpdate().registerUpdates(context, pul);
            pul.apply(context, this.mainModule.getRevalidationMode());
            for (MutableNodeInfo mutableNodeInfo : pul.getAffectedTrees()) {
                agent.update(mutableNodeInfo, controller);
            }
        }
        catch (XPathException e) {
            if (!e.hasBeenReported()) {
                controller.getErrorReporter().report(new XmlProcessingException(e));
            }
            throw e;
        }
        finally {
            if (controller.getTraceListener() != null) {
                controller.getTraceListener().close();
            }
        }
    }

    @Override
    public void runStreamed(DynamicQueryContext dynamicEnv, Source source, Result result, Properties outputProperties) throws XPathException {
        Receiver receiver;
        if (this.inversion == null) {
            throw new XPathException("Query was not compiled for streaming");
        }
        Controller controller = this.newController(dynamicEnv);
        XPathContextMajor context = controller.newXPathContext();
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(HostLanguage.XQUERY);
        if (result instanceof Receiver) {
            receiver = (Receiver)result;
        } else {
            SerializerFactory sf = context.getConfiguration().getSerializerFactory();
            Properties actualProperties = this.validateOutputProperties(controller, outputProperties);
            receiver = sf.getReceiver(result, new SerializationProperties(actualProperties), pipe);
        }
        receiver.open();
        WatchManager wm = new WatchManager(pipe);
        wm.setXPathContext(context);
        wm.setOutputter(new ComplexContentOutputter(receiver));
        StreamWatch streamWatch = new StreamWatch(this.inversion, wm, context);
        wm.addWatch(streamWatch, true);
        ContentDetector cd = new ContentDetector(wm);
        context.openStackFrame(this.stackFrameMap);
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        try {
            Sender.send(source, cd, controller.getConfiguration().getParseOptions());
        }
        catch (QuitParsingException quitParsingException) {
        }
        catch (XPathException err) {
            controller.reportFatalError(err);
            throw err;
        }
        finally {
            if (controller.getTraceListener() != null) {
                controller.getTraceListener().close();
            }
        }
        receiver.close();
        if (result instanceof StreamResult) {
            this.closeStreamIfNecessary((StreamResult)result, mustClose);
        }
    }

    @Override
    public void explainPathMap() {
        PathMap map = this.getPathMap();
        StandardLogger pw = new StandardLogger();
        pw.info("DOCUMENT PROJECTION: PATH MAP");
    }
}

