/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.PullElaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ConditionalInstruction;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class SwitchExpression
extends Expression
implements ConditionalInstruction {
    private final Operand subjectOp;
    private final List<Operand> actions;
    private final Map<AtomicMatchKey, Integer> map;
    private Map<AtomicMatchKey, AtomicValue> originalValues;
    private final Operand defaultActionOp;
    private final StringCollator collation;
    private boolean _isInstruction;
    public static final OperandRole SUBJECT = new OperandRole(0, OperandUsage.ABSORPTION, SequenceType.SINGLE_ATOMIC);

    public SwitchExpression(SwitchCaseInfo switchCaseInfo) {
        this.originalValues = switchCaseInfo.originalValues;
        this.subjectOp = new Operand(this, switchCaseInfo.commonlhs, SUBJECT);
        this.map = new HashMap<AtomicMatchKey, Integer>(switchCaseInfo.index.size());
        this.actions = new ArrayList<Operand>(switchCaseInfo.index.size());
        for (Map.Entry<AtomicMatchKey, Expression> entry : switchCaseInfo.index.entrySet()) {
            Expression action = entry.getValue();
            int actionNumber = -1;
            for (int i = 0; i < this.actions.size(); ++i) {
                if (this.actions.get(i).getChildExpression() != action) continue;
                actionNumber = i;
            }
            if (actionNumber == -1) {
                actionNumber = this.actions.size();
                this.actions.add(new Operand(this, action, Choose.CHOICE_ACTION));
            }
            this.map.put(entry.getKey(), actionNumber);
        }
        this.defaultActionOp = new Operand(this, switchCaseInfo.defaultAction, Choose.CHOICE_ACTION);
        this.collation = switchCaseInfo.collation;
    }

    private SwitchExpression(Expression commonlhs, Map<AtomicMatchKey, Integer> cases, List<Operand> actions, Expression otherwise, StringCollator collation) {
        this.subjectOp = new Operand(this, commonlhs, SUBJECT);
        this.map = new HashMap<AtomicMatchKey, Integer>(cases);
        this.actions = new ArrayList<Operand>(actions.size());
        for (Operand o : actions) {
            this.actions.add(new Operand(this, o.getChildExpression().copy(new RebindingMap()), OperandRole.SAME_FOCUS_ACTION));
        }
        this.defaultActionOp = new Operand(this, otherwise, OperandRole.SAME_FOCUS_ACTION);
        this.collation = collation;
    }

    public void setInstruction(boolean inst) {
        this._isInstruction = inst;
    }

    @Override
    public boolean isInstruction() {
        return this._isInstruction;
    }

    public Expression getSubjectExpression() {
        return this.subjectOp.getChildExpression();
    }

    public Map<AtomicMatchKey, Integer> getCaseMap() {
        return this.map;
    }

    public Expression getOtherwiseExpression() {
        return this.defaultActionOp.getChildExpression();
    }

    public Operand getAction(int index) {
        return this.actions.get(index);
    }

    public List<Operand> getActions() {
        return this.actions;
    }

    public Operand getOtherwiseOperand() {
        return this.defaultActionOp;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> list = new ArrayList<Operand>();
        list.add(this.subjectOp);
        list.add(this.defaultActionOp);
        list.addAll(this.actions);
        return list;
    }

    public StringCollator getCollation() {
        return this.collation;
    }

    @Override
    protected int computeCardinality() {
        int card = this.getOtherwiseExpression().getCardinality();
        for (Operand action : this.actions) {
            if ((card = Cardinality.union(card, action.getChildExpression().getCardinality())) != 57344) continue;
            return card;
        }
        return card;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        ArrayList<Operand> newActions = new ArrayList<Operand>();
        for (Operand o : this.actions) {
            newActions.add(new Operand(this, o.getChildExpression().copy(rebindings), Choose.CHOICE_ACTION));
        }
        SwitchExpression s2 = new SwitchExpression(this.getSubjectExpression().copy(rebindings), this.map, newActions, this.getOtherwiseExpression().copy(rebindings), this.collation);
        s2.originalValues = this.originalValues;
        return s2;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("switch", this);
        if (this.collation != CodepointCollator.getInstance()) {
            out.emitAttribute("coll", this.collation.getCollationURI());
        }
        out.setChildRole("value");
        this.getSubjectExpression().export(out);
        for (AtomicMatchKey key : this.map.keySet()) {
            out.startElement("case", this);
            Literal.exportAtomicValue(this.originalValues.get(key), out);
            int selection = this.map.get(key);
            this.actions.get(selection).getChildExpression().export(out);
            out.endElement();
        }
        out.setChildRole("default");
        this.getOtherwiseExpression().export(out);
        out.endElement();
    }

    @Override
    public ItemType getItemType() {
        ItemType type = this.getOtherwiseExpression().getItemType();
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        for (Operand operand : this.actions) {
            Expression action = operand.getChildExpression();
            type = Type.getCommonSuperType(type, action.getItemType(), th);
        }
        return type;
    }

    @Override
    public Expression unordered(boolean retainAllNodes, boolean forStreaming) throws XPathException {
        for (Operand o : this.actions) {
            Expression e2 = o.getChildExpression().unordered(retainAllNodes, forStreaming);
            if (e2 == o.getChildExpression()) continue;
            o.setChildExpression(e2);
        }
        this.defaultActionOp.setChildExpression(this.getOtherwiseExpression().unordered(retainAllNodes, forStreaming));
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForItem().eval(context);
    }

    public int getIndex(AtomicMatchKey key) {
        return this.map.getOrDefault(key, -1);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForPull().iterate(context);
    }

    @Override
    public void process(Outputter output, XPathContext context) throws XPathException {
        SwitchExpression.dispatchTailCall(this.makeElaborator().elaborateForPush().processLeavingTail(output, context));
    }

    @Override
    public int getImplementationMethod() {
        return 7;
    }

    @Override
    public String getExpressionName() {
        return "switch";
    }

    @Override
    public String getStreamerName() {
        return "SwitchExpression";
    }

    @Override
    public Elaborator getElaborator() {
        return new SwitchExprElaborator();
    }

    public static class SwitchExprElaborator
    extends PullElaborator {
        @Override
        public PullEvaluator elaborateForPull() {
            SwitchExpression expr = (SwitchExpression)this.getExpression();
            ItemEvaluator subjectEvaluator = expr.getSubjectExpression().makeElaborator().elaborateForItem();
            ArrayList<PullEvaluator> actionEvaluators = new ArrayList<PullEvaluator>(expr.getActions().size());
            for (Operand o : expr.getActions()) {
                actionEvaluators.add(o.getChildExpression().makeElaborator().elaborateForPull());
            }
            PullEvaluator otherwiseEvaluator = expr.getOtherwiseExpression().makeElaborator().elaborateForPull();
            return context -> {
                AtomicValue subjectValue = (AtomicValue)subjectEvaluator.eval(context);
                if (subjectValue == null) {
                    return otherwiseEvaluator.iterate(context);
                }
                AtomicMatchKey key = subjectValue.getXPathMatchKey(expr.getCollation(), context.getImplicitTimezone());
                int selection = expr.getIndex(key);
                if (selection == -1) {
                    return otherwiseEvaluator.iterate(context);
                }
                return ((PullEvaluator)actionEvaluators.get(selection)).iterate(context);
            };
        }

        @Override
        public ItemEvaluator elaborateForItem() {
            SwitchExpression expr = (SwitchExpression)this.getExpression();
            ItemEvaluator subjectEvaluator = expr.getSubjectExpression().makeElaborator().elaborateForItem();
            ArrayList<ItemEvaluator> actionEvaluators = new ArrayList<ItemEvaluator>(expr.getActions().size());
            for (Operand o : expr.getActions()) {
                actionEvaluators.add(o.getChildExpression().makeElaborator().elaborateForItem());
            }
            ItemEvaluator otherwiseEvaluator = expr.getOtherwiseExpression().makeElaborator().elaborateForItem();
            return context -> {
                AtomicValue subjectValue = (AtomicValue)subjectEvaluator.eval(context);
                if (subjectValue == null) {
                    return otherwiseEvaluator.eval(context);
                }
                AtomicMatchKey key = subjectValue.getXPathMatchKey(expr.getCollation(), context.getImplicitTimezone());
                int selection = expr.getIndex(key);
                if (selection == -1) {
                    return otherwiseEvaluator.eval(context);
                }
                return ((ItemEvaluator)actionEvaluators.get(selection)).eval(context);
            };
        }

        @Override
        public PushEvaluator elaborateForPush() {
            SwitchExpression expr = (SwitchExpression)this.getExpression();
            ItemEvaluator subjectEvaluator = expr.getSubjectExpression().makeElaborator().elaborateForItem();
            ArrayList<PushEvaluator> actionEvaluators = new ArrayList<PushEvaluator>(expr.getActions().size());
            for (Operand o : expr.getActions()) {
                actionEvaluators.add(o.getChildExpression().makeElaborator().elaborateForPush());
            }
            PushEvaluator otherwiseEvaluator = expr.getOtherwiseExpression().makeElaborator().elaborateForPush();
            return (out, context) -> {
                AtomicValue subjectValue = (AtomicValue)subjectEvaluator.eval(context);
                if (subjectValue == null) {
                    return otherwiseEvaluator.processLeavingTail(out, context);
                }
                AtomicMatchKey key = subjectValue.getXPathMatchKey(expr.getCollation(), context.getImplicitTimezone());
                int selection = expr.getIndex(key);
                if (selection == -1) {
                    return otherwiseEvaluator.processLeavingTail(out, context);
                }
                return ((PushEvaluator)actionEvaluators.get(selection)).processLeavingTail(out, context);
            };
        }
    }

    public static class SwitchCaseInfo {
        public HashMap<AtomicMatchKey, Expression> index = new HashMap();
        public HashMap<AtomicMatchKey, AtomicValue> originalValues = new HashMap();
        public Expression commonlhs = null;
        public BuiltInAtomicType commontype = null;
        public StringCollator collation = null;
        public List<AtomicValue> values = new ArrayList<AtomicValue>();
        public List<Expression> actions = new ArrayList<Expression>();
        public Expression defaultAction = null;

        public boolean makeIndex() {
            for (int i = 0; i < this.values.size(); ++i) {
                AtomicValue value = this.values.get(i);
                Expression action = this.actions.get(i);
                try {
                    AtomicMatchKey key = value.getXPathMatchKey(this.collation, Integer.MAX_VALUE);
                    if (key == null) {
                        return false;
                    }
                    if (this.index.get(key) != null) continue;
                    this.index.put(key, action);
                    this.originalValues.put(key, value);
                    continue;
                }
                catch (NoDynamicContextException e) {
                    return false;
                }
            }
            return true;
        }
    }
}

