/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import java.util.ArrayList;
import java.util.HashSet;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.InsertBefore;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.TwoItemIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class GeneralEqualityEE
extends GeneralComparison {
    public GeneralEqualityEE(Expression p0, int op, Expression p1) {
        super(p0, op, p1);
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        if (this.singletonOperator == 50 && !(this.getParentExpression() instanceof FilterExpression)) {
            Expression rhs;
            Expression lhs = this.getLhsExpression();
            Expression e2 = this.tryIndexedComparison(lhs, rhs = this.getRhsExpression());
            if (e2 != null) {
                return e2.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
            e2 = this.tryIndexedComparison(rhs, lhs);
            if (e2 != null) {
                return e2.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
            }
        }
        return super.optimize(visitor, contextItemType);
    }

    private Expression tryIndexedComparison(Expression lhs, Expression rhs) {
        if (lhs instanceof VariableReference && Cardinality.allowsMany(lhs.getCardinality()) && (rhs.getDependencies() & 0x1E) == 0) {
            GeneralEqualityEE predicate = new GeneralEqualityEE(new ContextItemExpression(), 6, rhs);
            FilterExpression filterExp = new FilterExpression(lhs, predicate);
            return SystemFunction.makeCall("exists", this.getRetainedStaticContext(), filterExp);
        }
        return null;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        GeneralEqualityEE gc = new GeneralEqualityEE(this.getLhsExpression().copy(rebindings), this.operator, this.getRhsExpression().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, gc);
        gc.setRetainedStaticContext(this.getRetainedStaticContext());
        gc.comparer = this.comparer;
        gc.singletonOperator = this.singletonOperator;
        gc.runtimeCheckNeeded = this.runtimeCheckNeeded;
        gc.comparisonCardinality = this.comparisonCardinality;
        return gc;
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.makeElaborator().elaborateForBoolean().eval(context);
    }

    private static SequenceIterator prependTwo(Item first, Item second, SequenceIterator rest) {
        return new InsertBefore.InsertIterator(rest, new TwoItemIterator(first, second), 1);
    }

    @Override
    protected GeneralComparison getInverseComparison() {
        GeneralEqualityEE gc = new GeneralEqualityEE(this.getRhsExpression(), Token.inverse(this.operator), this.getLhsExpression());
        gc.setRetainedStaticContext(this.getRetainedStaticContext());
        return gc;
    }

    @Override
    protected String tag() {
        return "gcEE";
    }

    @Override
    public Elaborator getElaborator() {
        return new GeneralEqualityElaboratorEE();
    }

    public static class GeneralEqualityElaboratorEE
    extends GeneralComparison.GeneralComparisonElaborator {
        @Override
        public boolean evaluateManyToMany(SequenceIterator lhsIter, SequenceIterator rhsIter, int singletonOperator, AtomicComparer comparer, boolean runTimeCheckNeeded, RetainedStaticContext staticContext, Location loc, XPathContext context) throws XPathException {
            Item lhsFirst = lhsIter.next();
            if (lhsFirst == null) {
                return false;
            }
            Item rhsFirst = rhsIter.next();
            if (rhsFirst == null) {
                lhsIter.close();
                return false;
            }
            if (this.compareOneToOne((AtomicValue)lhsFirst, (AtomicValue)rhsFirst, comparer, runTimeCheckNeeded, loc, staticContext, context)) {
                lhsIter.close();
                rhsIter.close();
                return true;
            }
            Item rhsSecond = rhsIter.next();
            if (rhsSecond == null) {
                return this.compareManyToOne(lhsIter, (AtomicValue)rhsFirst, comparer, runTimeCheckNeeded, loc, staticContext, context);
            }
            Item lhsSecond = lhsIter.next();
            if (lhsSecond == null) {
                if (this.compareOneToOne((AtomicValue)lhsFirst, (AtomicValue)rhsSecond, comparer, runTimeCheckNeeded, loc, staticContext, context)) {
                    lhsIter.close();
                    rhsIter.close();
                    return true;
                }
                return this.compareOneToMany((AtomicValue)lhsFirst, rhsIter, comparer, runTimeCheckNeeded, loc, staticContext, context);
            }
            return this.hashJoin(GeneralEqualityEE.prependTwo(lhsFirst, lhsSecond, lhsIter), GeneralEqualityEE.prependTwo(rhsFirst, rhsSecond, rhsIter), staticContext, context, comparer, loc);
        }

        private boolean compareOneToOne(AtomicValue lhsValue, AtomicValue rhsValue, AtomicComparer comparer, boolean needsRunTimeCheck, Location loc, RetainedStaticContext staticContext, XPathContext context) throws XPathException {
            if (needsRunTimeCheck && !UType.isGenerallyComparable(lhsValue.getUType(), rhsValue.getUType())) {
                throw new XPathException("Cannot compare " + Type.displayTypeName(lhsValue) + " to " + Type.displayTypeName(rhsValue)).withErrorCode("XPTY0004").withLocation(loc).asTypeError();
            }
            return GeneralComparison.compare(lhsValue, 50, rhsValue, comparer.provideContext(context), false, context, staticContext);
        }

        private boolean compareManyToOne(SequenceIterator lhsIter, AtomicValue rhsValue, AtomicComparer comparer, boolean needsRunTimeCheck, Location loc, RetainedStaticContext staticContext, XPathContext context) throws XPathException {
            AtomicValue lhsValue;
            while ((lhsValue = (AtomicValue)lhsIter.next()) != null) {
                if (!this.compareOneToOne(lhsValue, rhsValue, comparer, needsRunTimeCheck, loc, staticContext, context)) continue;
                lhsIter.close();
                return true;
            }
            return false;
        }

        private boolean compareOneToMany(AtomicValue lhsValue, SequenceIterator rhsIter, AtomicComparer comparer, boolean needsRunTimeCheck, Location loc, RetainedStaticContext staticContext, XPathContext context) throws XPathException {
            AtomicValue rhsValue;
            while ((rhsValue = (AtomicValue)rhsIter.next()) != null) {
                if (!this.compareOneToOne(lhsValue, rhsValue, comparer, needsRunTimeCheck, loc, staticContext, context)) continue;
                rhsIter.close();
                return true;
            }
            return false;
        }

        private boolean hashJoin(SequenceIterator iter1, SequenceIterator iter2, RetainedStaticContext staticContext, XPathContext context, AtomicComparer comparer, Location loc) throws XPathException {
            UType ut2;
            AtomicValue first1 = (AtomicValue)iter1.next();
            if (first1 == null) {
                iter2.close();
                return false;
            }
            AtomicValue first2 = (AtomicValue)iter2.next();
            if (first2 == null) {
                iter1.close();
                return false;
            }
            ConversionRules rules = context.getConfiguration().getConversionRules();
            AtomicComparer boundComparer = comparer.provideContext(context);
            UType ut1 = first1.getItemType().getUType();
            if (UType.NUMERIC.subsumes(ut1)) {
                ut1 = UType.NUMERIC;
            }
            if (UType.NUMERIC.subsumes(ut2 = first2.getItemType().getUType())) {
                ut2 = UType.NUMERIC;
            }
            UType hashTableType = ut1.equals(ut2) ? ut1 : (ut1.equals(UType.UNTYPED_ATOMIC) ? ut2 : ut1);
            StringConverter untypedConverter = hashTableType.equals(UType.NUMERIC) ? rules.getStringToDoubleConverter() : ((BuiltInAtomicType)hashTableType.toItemType()).getStringConverter(rules);
            StringCollator collator = comparer.getCollator();
            int implicitTimezone = context.getImplicitTimezone();
            HashSet<AtomicMatchKey> set1 = new HashSet<AtomicMatchKey>(20);
            HashSet<AtomicMatchKey> set2 = null;
            ArrayList<AtomicValue> strays1 = null;
            ArrayList<AtomicValue> strays2 = null;
            boolean exhausted1 = false;
            boolean exhausted2 = false;
            do {
                String msg;
                ConversionResult result;
                if (!exhausted1) {
                    UType t1 = ut1;
                    AtomicValue v1 = first1;
                    if (t1 == UType.UNTYPED_ATOMIC && hashTableType != UType.UNTYPED_ATOMIC) {
                        t1 = hashTableType;
                        result = untypedConverter.convertString(v1.getUnicodeStringValue());
                        if (result instanceof ValidationFailure) {
                            msg = "Failure converting untypedAtomic value to " + hashTableType + " during comparison operation. " + ((ValidationFailure)result).getMessage();
                            throw new XPathException(msg, "FORG0001", context).withLocation(loc);
                        }
                        v1 = (AtomicValue)result;
                    }
                    if (t1 == hashTableType) {
                        AtomicMatchKey k1 = v1.getXPathMatchKey(collator, implicitTimezone);
                        if (set2 != null && set2.contains(k1)) {
                            iter1.close();
                            iter2.close();
                            return true;
                        }
                        if (!exhausted2) {
                            set1.add(k1);
                        }
                    } else if (hashTableType != UType.UNTYPED_ATOMIC && !UType.isPossiblyComparable(t1, hashTableType, false)) {
                        String msg2 = "Cannot compare " + t1 + " to " + hashTableType;
                        throw new XPathException(msg2, "XPTY0004", context).withLocation(loc);
                    }
                    if (ut1 != hashTableType && strays2 != null) {
                        for (AtomicValue stray2 : strays2) {
                            try {
                                if (!GeneralComparison.compare(first1, 50, stray2, boundComparer, false, context, staticContext)) continue;
                                return true;
                            }
                            catch (XPathException e) {
                                BuiltInAtomicType it1 = first1.getPrimitiveType();
                                BuiltInAtomicType it2 = stray2.getPrimitiveType();
                                XPathException err = it1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) ? new XPathException("Cannot convert untypedAtomic value to type of second operand (" + it2 + ")").withErrorCode("FORG0001") : (it2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) ? new XPathException("Cannot convert untypedAtomic value to type of first operand (" + it1 + ")").withErrorCode("FORG0001") : new XPathException("Cannot compare " + it1 + " to " + it2).withErrorCode("XPTY0004"));
                                throw err.withXPathContext(context).withLocation(loc);
                            }
                        }
                    }
                    if (!(ut1 == hashTableType && ut1 != UType.UNTYPED_ATOMIC || exhausted2)) {
                        if (strays1 == null) {
                            strays1 = new ArrayList<AtomicValue>(10);
                        }
                        strays1.add(first1);
                    }
                    if ((first1 = (AtomicValue)iter1.next()) == null) {
                        exhausted1 = true;
                    } else {
                        ut1 = first1.getItemType().getUType();
                        if (UType.NUMERIC.subsumes(ut1)) {
                            ut1 = UType.NUMERIC;
                        }
                    }
                }
                if (exhausted2) continue;
                UType t2 = ut2;
                AtomicValue v2 = first2;
                if (t2 == UType.UNTYPED_ATOMIC && hashTableType != UType.UNTYPED_ATOMIC) {
                    t2 = hashTableType;
                    result = untypedConverter.convertString(v2.getUnicodeStringValue());
                    if (result instanceof ValidationFailure) {
                        msg = "Failure converting untypedAtomic value to " + hashTableType + " during comparison operation. " + ((ValidationFailure)result).getMessage();
                        throw new XPathException(msg, "FORG0001", context).withLocation(loc);
                    }
                    v2 = (AtomicValue)result;
                }
                if (t2 == hashTableType) {
                    AtomicMatchKey k2 = v2.getXPathMatchKey(collator, implicitTimezone);
                    if (set1.contains(k2)) {
                        iter1.close();
                        iter2.close();
                        return true;
                    }
                    if (!exhausted1) {
                        if (set2 == null) {
                            set2 = new HashSet<AtomicMatchKey>(20);
                        }
                        set2.add(k2);
                    }
                }
                if (ut2 != hashTableType && strays1 != null) {
                    for (AtomicValue stray1 : strays1) {
                        try {
                            if (!GeneralComparison.compare(first2, 50, stray1, boundComparer, false, context, staticContext)) continue;
                            return true;
                        }
                        catch (XPathException e) {
                            BuiltInAtomicType it2 = first2.getPrimitiveType();
                            BuiltInAtomicType it1 = stray1.getPrimitiveType();
                            XPathException err = it1.equals(BuiltInAtomicType.UNTYPED_ATOMIC) ? new XPathException("Cannot convert untypedAtomic value to type of second operand (" + it2 + ")").withErrorCode("FORG0001") : (it2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) ? new XPathException("Cannot convert untypedAtomic value to type of first operand (" + it1 + ")").withErrorCode("FORG0001") : new XPathException("Cannot compare " + it1 + " to " + it2).withErrorCode("XPTY0004"));
                            throw err.withXPathContext(context).withLocation(loc);
                        }
                    }
                }
                if (!(ut2 == hashTableType && ut2 != UType.UNTYPED_ATOMIC || exhausted1)) {
                    if (strays2 == null) {
                        strays2 = new ArrayList<AtomicValue>(10);
                    }
                    strays2.add(first2);
                }
                if ((first2 = (AtomicValue)iter2.next()) == null) {
                    exhausted2 = true;
                    continue;
                }
                ut2 = first2.getItemType().getUType();
                if (!UType.NUMERIC.subsumes(ut2)) continue;
                ut2 = UType.NUMERIC;
            } while (!exhausted1 || !exhausted2);
            return false;
        }
    }
}

