/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.IntegratedFunctionCall;
import net.sf.saxon.functions.UnparsedTextFunction;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.json.ParseJsonFn;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.z.IntPredicateLambda;

public class StubFunctionLibrary
implements FunctionLibrary {
    private final Map<SymbolicName.F, SpecificFunctionType> signatures = new HashMap<SymbolicName.F, SpecificFunctionType>();
    private final Configuration config;
    private static final StringValue NAMESPACE = new StringValue("namespace");
    private static final StringValue SIGNATURES = new StringValue("signatures");
    private static final StringValue AS = new StringValue("as");
    private static final StringValue PARAM = new StringValue("param");
    private static final StringValue ARITY = new StringValue("arity");

    public StubFunctionLibrary(Configuration config) {
        this.config = config;
    }

    public void loadSignatures(StreamSource input) throws XPathException {
        UnicodeString content;
        XPathContext context = this.config.getConversionContext();
        try {
            Reader reader = StandardUnparsedTextResolver.getReaderFromStreamSource(input, "utf-8", this.config, this.config.isTiming());
            content = UnparsedTextFunction.readFile(IntPredicateLambda.of(ch -> true), reader);
        }
        catch (IOException ioErr) {
            throw new XPathException("Failed to read function signatures", ioErr);
        }
        Item result = ParseJsonFn.parse(content.toString(), ParseJsonFn.OPTION_DETAILS.getDefaultOptions(), context);
        if (result instanceof ArrayItem) {
            for (GroundedValue member : ((ArrayItem)result).members()) {
                if (member instanceof MapItem) {
                    this.loadSignatureMap((MapItem)member);
                    continue;
                }
                StubFunctionLibrary.badInput("Top level is an array but contents are not maps");
            }
        } else if (result instanceof MapItem) {
            this.loadSignatureMap((MapItem)result);
        } else {
            StubFunctionLibrary.badInput("Neither an array nor a map");
        }
    }

    private void loadSignatureMap(MapItem map) throws XPathException {
        String namespace = map.get(NAMESPACE).getStringValue();
        GroundedValue sigs = map.get(SIGNATURES);
        IndependentContext env = new IndependentContext(this.config);
        if (sigs instanceof MapItem) {
            for (KeyValuePair kvp : ((MapItem)sigs).keyValuePairs()) {
                StructuredQName name = new StructuredQName("", namespace, kvp.key.toString());
                StubFunctionLibrary.expect(kvp.value instanceof MapItem, "Value of " + name + " must be a map");
                MapItem sigValue = (MapItem)kvp.value;
                GroundedValue asValue = sigValue.get(AS);
                StubFunctionLibrary.expect(asValue instanceof StringValue, "In " + name + ", as must exist and be a string");
                SequenceType resultType = StubFunctionLibrary.parseSequenceType(asValue.getStringValue(), env);
                ArrayList<SequenceType> paramTypes = new ArrayList<SequenceType>();
                GroundedValue params = sigValue.get(PARAM);
                StubFunctionLibrary.expect(params instanceof ArrayItem, "In " + name + ", param must exist and be an array");
                for (GroundedValue paramDetails : ((ArrayItem)params).members()) {
                    StubFunctionLibrary.expect(paramDetails instanceof StringValue, "In " + name + ", param members must be strings");
                    SequenceType paramType = StubFunctionLibrary.parseSequenceType(paramDetails.getStringValue(), env);
                    paramTypes.add(paramType);
                }
                GroundedValue arityValue = sigValue.get(ARITY);
                StubFunctionLibrary.expect(arityValue instanceof ArrayItem, "In " + name + ", as must exist and be an array");
                for (GroundedValue arity : ((ArrayItem)arityValue).members()) {
                    StubFunctionLibrary.expect(arity instanceof NumericValue, "In " + name + ", arity must be a number");
                    int arityInt = (int)((NumericValue)arity).getDoubleValue();
                    StubFunctionLibrary.expect(arityInt >= 0, "In " + name + " arity is less than zero");
                    SymbolicName.F functionName = new SymbolicName.F(name, arityInt);
                    StubFunctionLibrary.expect(arityInt <= paramTypes.size(), "In " + name + " arity exceeds number of params");
                    SequenceType[] st = new SequenceType[arityInt];
                    for (int i = 0; i < arityInt; ++i) {
                        st[i] = (SequenceType)paramTypes.get(i);
                    }
                    SpecificFunctionType sig = new SpecificFunctionType(st, resultType);
                    this.signatures.put(functionName, sig);
                }
            }
        }
    }

    private static SequenceType parseSequenceType(String designator, StaticContext env) throws XPathException {
        XPathParser p = new XPathParser(env);
        return p.parseSequenceType(designator, env);
    }

    private static void expect(boolean condition, String description) throws XPathException {
        if (!condition) {
            throw new XPathException("Invalid function signature file: " + description);
        }
    }

    private static void badInput(String message) throws XPathException {
        throw new XPathException("Invalid content in function signatures file", message);
    }

    @Override
    public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
        return this.signatures.containsKey(functionName);
    }

    @Override
    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) {
        if (this.signatures.containsKey(functionName)) {
            SpecificFunctionType type = this.signatures.get(functionName);
            StubExtensionDefinition defn = new StubExtensionDefinition(functionName.getComponentName(), type);
            ExtensionFunctionCall f = ((ExtensionFunctionDefinition)defn).makeCallExpression();
            f.setDefinition(defn);
            IntegratedFunctionCall fc = new IntegratedFunctionCall(((ExtensionFunctionDefinition)defn).getFunctionQName(), f);
            fc.setArguments(staticArgs);
            return fc;
        }
        return null;
    }

    @Override
    public FunctionLibrary copy() {
        return this;
    }

    @Override
    public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) throws XPathException {
        if (this.signatures.containsKey(functionName)) {
            SpecificFunctionType type = this.signatures.get(functionName);
            StubExtensionDefinition defn = new StubExtensionDefinition(functionName.getComponentName(), type);
            try {
                return defn.asFunction(functionName.getArity());
            }
            catch (Exception err) {
                throw new XPathException("Failed to create call to extension function " + functionName.getComponentName().getDisplayName(), err);
            }
        }
        return null;
    }

    private static class StubFunctionCall
    extends ExtensionFunctionCall {
        private StubFunctionCall() {
        }

        @Override
        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            throw new XPathException("Function " + this.getDefinition().getFunctionQName().getEQName() + " has no implementation");
        }
    }

    private static class StubExtensionDefinition
    extends ExtensionFunctionDefinition {
        private final StructuredQName functionName;
        private final SpecificFunctionType functionType;

        public StubExtensionDefinition(StructuredQName name, SpecificFunctionType type) {
            this.functionName = name;
            this.functionType = type;
        }

        @Override
        public StructuredQName getFunctionQName() {
            return this.functionName;
        }

        @Override
        public SequenceType[] getArgumentTypes() {
            return this.functionType.getArgumentTypes();
        }

        @Override
        public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
            return this.functionType.getResultType();
        }

        @Override
        public ExtensionFunctionCall makeCallExpression() {
            return new StubFunctionCall();
        }
    }
}

