/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;

public class StreamFn
extends SystemFunction {
    @Override
    public Expression makeFunctionCall(Expression ... arguments) {
        return new SystemFunctionCall(this, arguments){

            @Override
            public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
                visitor.setOptimizeForStreaming(true);
                return super.optimize(visitor, contextItemType);
            }
        };
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        Expression result = opt.optimizeSaxonStreamFunction(visitor, contextInfo, arguments[0]);
        if (result == null) {
            if (visitor.getConfiguration().getBooleanProperty(Feature.STREAMING_FALLBACK)) {
                return arguments[0];
            }
            throw new XPathException("The argument to saxon:stream() has the wrong form for streaming to be possible", "XTSE3430");
        }
        if (result.isCallOn(StreamFn.class)) {
            return ((SystemFunctionCall)result).getArg(0);
        }
        return result;
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        throw new XPathException("The function saxon:stream() cannot be called dynamically");
    }
}

