/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.functions.ExecutableFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.functions.registry.XPath31FunctionSet;
import net.sf.saxon.functions.registry.XSLT30FunctionSet;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.PublicStylesheetFunctionLibrary;
import net.sf.saxon.style.StylesheetFunctionLibrary;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AtomicIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class CompileXPath
extends SystemFunction {
    private static final NamespaceUri exportURI = NamespaceUri.of("http://ns.saxonica.com/xslt/export");

    @Override
    public MapItem call(XPathContext context, Sequence[] arguments) throws XPathException {
        Expression expr;
        Controller controller = context.getController();
        Configuration configuration = controller.getConfiguration();
        AtomicValue content = (AtomicValue)arguments[0].head();
        MapItem options = (MapItem)arguments[1].head();
        MapItem locals = (MapItem)arguments[2].head();
        StringValue type = (StringValue)options.get(StringValue.bmp("type"));
        String exprText = content.getStringValue();
        IndependentContext env = new IndependentContext(configuration);
        env.setWarningHandler((msg, locator) -> {
            String message = "In dynamic expression {" + exprText + "}: " + msg;
            context.getController().warning(message, null, null);
        });
        BooleanValue backwards = (BooleanValue)options.get(StringValue.bmp("backwardCompatibility"));
        env.setBackwardsCompatibilityMode(backwards != null && backwards.getBooleanValue());
        env.setXPathLanguageLevel(configuration.getConfigurationProperty(Feature.XPATH_VERSION_FOR_XSLT));
        BooleanValue inCatchVal = (BooleanValue)options.get(StringValue.bmp("inCatch"));
        boolean inCatch = inCatchVal != null && inCatchVal.getBooleanValue();
        StringValue contextType = (StringValue)options.get(StringValue.bmp("context-type"));
        AnyItemType contextItemType = AnyItemType.getInstance();
        MapItem namespaces = (MapItem)options.get(StringValue.bmp("namespaces"));
        if (namespaces != null) {
            AtomicValue key;
            AtomicIterator keys = namespaces.keys();
            while ((key = keys.next()) != null) {
                String prefix = key.getStringValue();
                String uri = namespaces.get(key).getUnicodeStringValue().toString();
                if (uri.equals("~")) {
                    uri = NamespaceConstant.getUriForConventionalPrefix(prefix);
                }
                if (uri == null) {
                    switch (prefix) {
                        case "map": {
                            uri = "http://www.w3.org/2005/xpath-functions/map";
                            break;
                        }
                        case "array": {
                            uri = "http://www.w3.org/2005/xpath-functions/array";
                            break;
                        }
                        default: {
                            throw new XPathException("Unknown URI for defaulted prefix " + prefix);
                        }
                    }
                }
                env.declareNamespace(prefix, NamespaceUri.of(uri));
            }
        }
        MapItem globals = (MapItem)options.get(StringValue.bmp("globals"));
        ArrayList<String> knownGlobals = new ArrayList<String>();
        if (globals != null) {
            AtomicValue key;
            AtomicIterator keys = globals.keys();
            while ((key = keys.next()) != null) {
                knownGlobals.add(key.getStringValue());
                NodeInfo n = (NodeInfo)globals.get(key);
                String t = n.getAttributeValue(NamespaceUri.NULL, "sType");
                XPathVariable v = env.declareVariable(StructuredQName.fromClarkName(key.getStringValue()));
                v.setRequiredType(this.makeType(t));
            }
        }
        for (StructuredQName errorVariable : StandardNames.errorVariables) {
            env.declareVariable(errorVariable);
        }
        int maxSlot = 0;
        if (locals != null) {
            AtomicValue key;
            AtomicIterator keys = locals.keys();
            while ((key = keys.next()) != null) {
                SequenceExtent s = (SequenceExtent)locals.get(key);
                String staticType = s.itemAt(2).getStringValue();
                int slot = (int)((Int64Value)s.itemAt(1)).longValue();
                if (slot > maxSlot) {
                    maxSlot = slot;
                }
                XPathVariable v = env.declareVariable(StructuredQName.fromClarkName(key.getStringValue()));
                v.setSlotNumber(slot);
                v.setRequiredType(this.makeType(staticType));
            }
        }
        FunctionLibraryList libraryList = new FunctionLibraryList();
        LocalFunctionLibrary userFunctionLibrary = new LocalFunctionLibrary(context.getConfiguration());
        FunctionLibraryList libraryList0 = ((StylesheetPackage)this.getRetainedStaticContext().getPackageData()).getFunctionLibrary();
        for (FunctionLibrary lib : libraryList0.getLibraryList()) {
            if (lib instanceof BuiltInFunctionSet && ((BuiltInFunctionSet)lib).getNamespace().equals(NamespaceUri.FN)) {
                libraryList.addFunctionLibrary(XPath31FunctionSet.getInstance());
                libraryList.addFunctionLibrary(XSLT30FunctionSet.getInstance());
                libraryList.addFunctionLibrary(configuration.getVendorFunctionSet());
                continue;
            }
            if (lib instanceof StylesheetFunctionLibrary || lib instanceof ExecutableFunctionLibrary) {
                libraryList.addFunctionLibrary(new PublicStylesheetFunctionLibrary(lib));
                continue;
            }
            libraryList.addFunctionLibrary(lib);
        }
        MapItem globalFunctions = (MapItem)options.get(StringValue.bmp("globalFunctions"));
        XPathParser parser = configuration.newExpressionParser("XP", false, env);
        IndependentContext parseContext = new IndependentContext(configuration);
        if (globalFunctions != null) {
            AtomicValue key;
            NameTest argTest = new NameTest(1, exportURI, "arg", configuration.getNamePool());
            StylesheetPackage sheet = new StylesheetPackage(configuration);
            AtomicIterator keys = globalFunctions.keys();
            while ((key = keys.next()) != null) {
                NodeInfo arg;
                int arity;
                String nameArity = key.getStringValue();
                NodeInfo decl = (NodeInfo)globalFunctions.get(key);
                decl = decl.getParent();
                SequenceType reqType = SequenceType.ANY_SEQUENCE;
                String rType = decl.getAttributeValue(NamespaceUri.NULL, "as");
                if (rType != null) {
                    reqType = parser.parseSequenceType(rType, parseContext);
                }
                String[] parts = nameArity.split("#");
                try {
                    arity = Integer.parseInt(parts[1]);
                }
                catch (NumberFormatException e) {
                    throw new XPathException("Function arity must be an integer");
                }
                SymbolicName.F functionName = new SymbolicName.F(StructuredQName.fromClarkName(parts[0]), arity);
                UserFunction fn = new UserFunction();
                fn.setFunctionName(functionName.getComponentName());
                Component component = Component.makeComponent(fn, Visibility.PUBLIC, VisibilityProvenance.DEFAULTED, sheet, sheet);
                fn.setDeclaringComponent(component);
                fn.setResultType(reqType);
                fn.setBody(new StringLiteral("BODY(" + nameArity + ")"));
                UserFunctionParameter[] params = new UserFunctionParameter[arity];
                int i = 0;
                AxisIterator iter = decl.iterateAxis(3, argTest);
                while ((arg = iter.next()) != null) {
                    UserFunctionParameter p = new UserFunctionParameter();
                    String name = arg.getAttributeValue(NamespaceUri.NULL, "name");
                    reqType = SequenceType.ANY_SEQUENCE;
                    rType = decl.getAttributeValue(NamespaceUri.NULL, "as");
                    if (rType != null) {
                        reqType = parser.parseSequenceType(rType, parseContext);
                    }
                    p.setRequiredType(reqType);
                    p.setVariableQName(StructuredQName.fromEQName(name));
                    params[i++] = p;
                }
                fn.setParameterDefinitions(params);
                fn.setStackFrameMap(new SlotManager(i));
                ((ExecutableFunctionLibrary)userFunctionLibrary).addFunction(fn);
            }
        }
        libraryList.addFunctionLibrary(userFunctionLibrary);
        env.setFunctionLibrary(libraryList);
        try {
            expr = type != null && "pattern".equals(type.getStringValue()) ? Pattern.make(exprText, env, null) : CompileXPath.make(exprText, env, 0, 0, null, inCatch);
        }
        catch (XPathException e) {
            throw new XPathException("Static error in XPath expression supplied to saxon:compile-XPath: " + e.getMessage() + ". Expression: {" + exprText + "}").withErrorCode("XTDE3160");
        }
        ExpressionVisitor visitor = new ExpressionVisitor(configuration);
        visitor.setStaticContext(env);
        expr = expr.typeCheck(visitor, new ContextItemStaticInfo(contextItemType, false));
        HashMap<StructuredQName, LocalVariableBinding> internalSlotMap = new HashMap<StructuredQName, LocalVariableBinding>();
        expr = this.setSlots(expr, knownGlobals, internalSlotMap, maxSlot + 1);
        Builder b = controller.makeBuilder();
        b.setTiming(false);
        ExpressionPresenter out = new ExpressionPresenter(configuration, b);
        out.setDefaultNamespace(exportURI);
        expr.export(out);
        NodeInfo node = b.getCurrentRoot().iterateAxis(3).next();
        StringValue st = new StringValue(expr.getStaticType().toAlphaCode());
        HashTrieMap result = new HashTrieMap();
        result.initialPut(StringValue.bmp("expr"), node);
        result.initialPut(StringValue.bmp("type"), st);
        return result;
    }

    private SequenceType makeType(String type) {
        SequenceType result = SequenceType.ANY_SEQUENCE;
        if (type.startsWith("map(")) {
            result = new SequenceType(MapType.ANY_MAP_TYPE, 16384);
        }
        return result;
    }

    public static Expression make(String expression, StaticContext env, int start, int terminator, CodeInjector codeInjector, boolean inCatch) throws XPathException {
        int languageLevel = env.getXPathVersion();
        XPathParser parser = env.getConfiguration().newExpressionParser("XP", false, env);
        if (inCatch) {
            parser.setCatchDepth(1);
        }
        if (codeInjector != null) {
            parser.setCodeInjector(codeInjector);
        }
        if (terminator == -1) {
            terminator = 0;
        }
        Expression exp = parser.parse(expression, start, terminator, env);
        ExpressionTool.setDeepRetainedStaticContext(exp, env.makeRetainedStaticContext());
        exp = exp.simplify();
        return exp;
    }

    private Expression setSlots(Expression expr, ArrayList<String> globals, HashMap<StructuredQName, LocalVariableBinding> internalSlotMap, int nextSlot) {
        LocalVariableReference lvr;
        StructuredQName name;
        Assignation f;
        Expression possible = this.isGlobalReference(expr, globals);
        if (possible != null) {
            return possible;
        }
        if (expr instanceof Assignation && (f = (Assignation)expr).getLocalSlotNumber() == -999) {
            name = f.getVariableQName();
            LocalVariableBinding b = new LocalVariableBinding(name, f.getStaticType());
            b.setSlotNumber(nextSlot);
            f.setSlotNumber(nextSlot);
            internalSlotMap.put(name, b);
            ++nextSlot;
        }
        if (expr instanceof LocalVariableReference && (lvr = (LocalVariableReference)expr).getBinding().getLocalSlotNumber() == -999) {
            name = lvr.getVariableName();
            lvr.fixup(internalSlotMap.get(name));
        }
        Iterable<Operand> ops = expr.operands();
        for (Operand o : ops) {
            Expression e = o.getChildExpression();
            possible = this.isGlobalReference(e, globals);
            if (possible != null) {
                o.setChildExpression(possible);
                continue;
            }
            this.setSlots(e, globals, internalSlotMap, nextSlot);
        }
        return expr;
    }

    private Expression isGlobalReference(Expression expr, ArrayList<String> globals) {
        if (expr instanceof VariableReference) {
            String n = ((VariableReference)expr).getEQName();
            if (!n.startsWith("Q{")) {
                n = "Q{}" + n;
            }
            if (globals.contains(n)) {
                GlobalVariableReference g = new GlobalVariableReference(((VariableReference)expr).getVariableName());
                g.setRetainedStaticContext(expr.getRetainedStaticContext());
                return g;
            }
        }
        return null;
    }

    private static class LocalFunctionLibrary
    extends ExecutableFunctionLibrary {
        final HashMap<SymbolicName.F, UserFunction> lib = new HashMap();

        public LocalFunctionLibrary(Configuration config) {
            super(config);
        }

        @Override
        public boolean isAvailable(SymbolicName.F functionName, int languageLevel) {
            return this.lib.containsKey(functionName);
        }

        @Override
        public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, Map<StructuredQName, Integer> keywords, StaticContext env, List<String> reasons) {
            UserFunction fn = this.lib.get(functionName);
            UserFunctionParameter[] params = new UserFunctionParameter[staticArgs.length];
            int i = 0;
            for (Expression s : staticArgs) {
                UserFunctionParameter p = new UserFunctionParameter();
                p.setRequiredType(SequenceType.ANY_SEQUENCE);
                params[i++] = p;
            }
            fn.setParameterDefinitions(params);
            UserFunctionCall call = new UserFunctionCall();
            call.setArguments(staticArgs);
            call.setFunctionName(functionName.getComponentName());
            return call;
        }

        @Override
        public FunctionLibrary copy() {
            return null;
        }

        @Override
        public void addFunction(UserFunction fn) {
            this.lib.put(new SymbolicName.F(fn.getFunctionName(), fn.getArity()), fn);
        }

        @Override
        public FunctionItem getFunctionItem(SymbolicName.F functionName, StaticContext staticContext) {
            return this.lib.get(functionName);
        }
    }
}

