/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.domino;

import com.saxonica.ee.domino.DominoNode;
import com.saxonica.ee.domino.DominoTree;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.z.IntPredicateProxy;

final class PrecedingSiblingIterator
implements AxisIterator {
    private final DominoTree document;
    private final DominoNode startNode;
    private int nextNodeNr;
    private final NodeTest test;
    private final DominoNode parentNode;
    private final IntPredicateProxy matcher;

    PrecedingSiblingIterator(DominoTree doc, DominoNode node, NodeTest nodeTest) {
        this.document = doc;
        this.document.ensurePriorIndex();
        this.test = nodeTest;
        this.matcher = nodeTest.getMatcher(doc);
        this.startNode = node;
        this.nextNodeNr = node.getNodeNr();
        this.parentNode = node.getParent();
    }

    @Override
    public NodeInfo next() {
        if (this.nextNodeNr < 0) {
            return null;
        }
        do {
            this.nextNodeNr = this.document.prior[this.nextNodeNr];
            if (this.nextNodeNr >= 0) continue;
            return null;
        } while (!this.matcher.test(this.nextNodeNr));
        DominoNode next = this.document.getNode(this.nextNodeNr);
        next.setParentNode(this.parentNode);
        return next;
    }
}

