/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.config;

import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.ee.config.MultithreadingFactory;
import com.saxonica.ee.config.SlotManagerEE;
import com.saxonica.ee.config.StandardSchemaResolver;
import com.saxonica.ee.config.StyleNodeFactoryEE;
import com.saxonica.ee.config.TypeHierarchyEE;
import com.saxonica.ee.extfn.VendorFunctionSetEE;
import com.saxonica.ee.extfn.js.IXSLElementFactory;
import com.saxonica.ee.extfn.js.StubFunctionLibrary;
import com.saxonica.ee.optim.OptimizerEE;
import com.saxonica.ee.optim.QuickXPathParser;
import com.saxonica.ee.optim.SearchableValue;
import com.saxonica.ee.optim.StaticQueryContextEE;
import com.saxonica.ee.optim.XQueryExpressionEE;
import com.saxonica.ee.parallel.MultithreadedFocusTrackingIterator;
import com.saxonica.ee.parallel.ThreadManagerEE;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelLoader;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserDefinedType;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.UserUnionType;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XMLNamespaceSchema;
import com.saxonica.ee.schema.sdoc.XSINamespaceSchema;
import com.saxonica.ee.stream.AccumulatorRegistryEE;
import com.saxonica.ee.stream.ContentDetector;
import com.saxonica.ee.stream.ManualGroupIterator;
import com.saxonica.ee.stream.ManualRegexIterator;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Projector;
import com.saxonica.ee.stream.StreamInstr;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.StreamableUserFunction;
import com.saxonica.ee.stream.feed.DecomposingFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.watch.ApplyTemplatesAction;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import com.saxonica.ee.trans.ExpressionPresenterToJson;
import com.saxonica.ee.trans.ModeEE;
import com.saxonica.ee.trans.Outcome;
import com.saxonica.ee.trans.PackageLoaderEE;
import com.saxonica.ee.trans.SaxonElementFactoryEE;
import com.saxonica.ee.trans.StylesheetPackageEE;
import com.saxonica.ee.trans.TemplateRuleEE;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.update.XQueryParserExtensionEE;
import com.saxonica.ee.validate.AssertionTreeBuilder;
import com.saxonica.ee.validate.AttributeInheritor;
import com.saxonica.ee.validate.ConstraintChecker;
import com.saxonica.ee.validate.ContentValidator;
import com.saxonica.ee.validate.EntityValidator;
import com.saxonica.ee.validate.IdValidator;
import com.saxonica.ee.validate.InvalidityReportGeneratorEE;
import com.saxonica.ee.validate.SkipValidator;
import com.saxonica.ee.validate.ValidationContext;
import com.saxonica.ee.validate.ValidationStack;
import com.saxonica.ee.validate.XSIAttributeHandler;
import com.saxonica.expr.XQueryParserExtensionPE;
import com.saxonica.trans.ModePE;
import com.saxonica.xsltextn.style.Saxon6ElementFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.Version;
import net.sf.saxon.event.DocumentValidator;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.PathMaintainer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.MemoFunction;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.OptimizerOptions;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.registry.BuiltInFunctionSet;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.FeatureData;
import net.sf.saxon.lib.FeatureIndex;
import net.sf.saxon.lib.InvalidityHandlerWrappingErrorReporter;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.StaticQueryContextFactory;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.IgnorableSpaceStrippingRule;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.query.XQueryParser;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.s9api.HostLanguage;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.serialize.JSONEmitter;
import net.sf.saxon.serialize.UTF8Writer;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.LicenseException;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.type.ValidationParams;

public final class EnterpriseConfiguration
extends ProfessionalConfiguration {
    private int licensedFeatures = 0;
    private HashMap<NamespaceUri, Integer> namespaceStatus = new HashMap();
    private int[] occurrenceLimits = new int[]{100, 250};
    private SchemaURIResolver schemaURIResolver = null;
    private final SchemaURIResolver standardSchemaResolver;
    private transient PreparedSchema superSchema;
    private int resultDocumentThreadsLimit = Runtime.getRuntime().availableProcessors();
    private int thresholdForCompilingTypes = 100;
    private int thresholdForInliningFunctions = 100;
    private int maxCompiledClasses = 10000;
    private Optional<Boolean> streamabilityEnabled = Optional.empty();
    private final ConcurrentHashMap<String, RegularExpression> regexCache = new ConcurrentHashMap();
    private long regexAttempts = 0L;
    private MultithreadingFactory multithreadingFactory = new MultithreadingFactory(this);

    public EnterpriseConfiguration() {
        this.internalSetBooleanProperty(2, "http://saxon.sf.net/feature/allow-multithreading", true);
        this.setStaticQueryContextFactory(new StaticQueryContextFactory(){

            @Override
            public StaticQueryContext newStaticQueryContext(Configuration config, boolean copyFromDefault) {
                return new StaticQueryContextEE(EnterpriseConfiguration.this, copyFromDefault);
            }
        });
        this.optimizerOptions = OptimizerOptions.FULL_EE_OPTIMIZATION;
        this.defaultXsltCompilerInfo.setOptimizerOptions(this.optimizerOptions);
        this.standardSchemaResolver = new StandardSchemaResolver(this);
        this.superSchema = new PreparedSchema(this);
    }

    @Override
    protected StaticQueryContext makeStaticQueryContext(boolean copyFromDefault) {
        StaticQueryContext sqc = super.makeStaticQueryContext(copyFromDefault);
        if (this.defaultStaticQueryContext != null) {
            sqc.setSchemaAware(this.defaultStaticQueryContext.isSchemaAware());
        }
        return sqc;
    }

    @Override
    public String getEditionCode() {
        return "EE";
    }

    @Override
    protected void setFeature(FeatureData feature, Object value) {
        int code = feature.code;
        FeatureData featureData = FeatureIndex.getData(code);
        String name = featureData.uri;
        block1 : switch (code) {
            case 33: {
                break;
            }
            case 123: {
                break;
            }
            case 16: {
                break;
            }
            case 47: {
                String val = value.toString();
                int comma = val.indexOf(44);
                if (comma < 1) {
                    throw new IllegalArgumentException("Value of " + name + "must be two integers, comma-separated");
                }
                try {
                    int min = Integer.parseInt(val.substring(0, comma));
                    int max = Integer.parseInt(val.substring(comma + 1));
                    this.setOccurrenceLimits(min, max);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Value of " + name + "must be two integers, comma-separated");
                }
            }
            case 56: {
                this.resultDocumentThreadsLimit = this.requireInteger(name, value);
                break;
            }
            case 58: {
                if (!(value instanceof SchemaURIResolver)) {
                    throw new IllegalArgumentException("SCHEMA_URI_RESOLVER value must be an instance of net.sf.saxon.lib.SchemaURIResolver");
                }
                this.setSchemaURIResolver((SchemaURIResolver)value);
                break;
            }
            case 59: {
                this.setSchemaURIResolver((SchemaURIResolver)this.instantiateClassName(name, value, SchemaURIResolver.class));
                break;
            }
            case 68: {
                String s;
                switch (s = this.requireString(name, value)) {
                    case "off": {
                        this.setStreamabilityEnabled(false);
                        break block1;
                    }
                    case "standard": {
                        this.setStreamabilityEnabled(true);
                        break block1;
                    }
                    case "extended": {
                        throw new IllegalArgumentException("The value STREAMABILITY = 'extended' is no longer recognized");
                    }
                }
                throw new IllegalArgumentException("Unrecognized value STREAMABILITY = '" + value + "': must be 'off' or 'standard'");
            }
            case 76: {
                this.thresholdForCompilingTypes = this.requireInteger(name, value);
                break;
            }
            case 122: {
                this.thresholdForInliningFunctions = this.requireInteger(name, value);
                break;
            }
            case 40: {
                this.maxCompiledClasses = this.requireInteger(name, value);
                break;
            }
            default: {
                super.setFeature(feature, value);
            }
        }
    }

    @Override
    protected Object getFeature(FeatureData feature) {
        int code = feature.code;
        if (booleanFeatures.contains(code)) {
            return super.getFeature(feature);
        }
        switch (code) {
            case 16: {
                return "";
            }
            case 47: {
                return this.occurrenceLimits[0] + "," + this.occurrenceLimits[1];
            }
            case 76: {
                return this.thresholdForCompilingTypes;
            }
            case 122: {
                return this.thresholdForInliningFunctions;
            }
            case 40: {
                return this.maxCompiledClasses;
            }
            case 56: {
                return this.resultDocumentThreadsLimit;
            }
            case 58: {
                return this.getSchemaURIResolver();
            }
            case 59: {
                return this.getSchemaURIResolver().getClass().getName();
            }
            case 68: {
                return this.isStreamabilityEnabled() ? "standard" : "off";
            }
        }
        return super.getFeature(feature);
    }

    @Override
    public void checkLicensedFeature(int feature, String name, int localLicenseId) throws LicenseException {
        if (localLicenseId >= 0 && this.isFeatureAllowedBySecondaryLicense(localLicenseId, feature)) {
            return;
        }
        if (this.isLicenseNotFound()) {
            try {
                this.forceLoadLicense();
            }
            catch (Exception err) {
                int reason = err instanceof LicenseException ? ((LicenseException)err).getReason() : 5;
                String msg = err.getMessage() + ". A license is needed to use " + name;
                throw new LicenseException(msg, reason);
            }
        }
        if (!this.isLicenseFound()) {
            try {
                this.loadLicense();
            }
            catch (Exception err) {
                int reason = err instanceof LicenseException ? ((LicenseException)err).getReason() : 5;
                String msg = err.getMessage() + ". A license is needed to use " + name;
                throw new LicenseException(msg, reason);
            }
        }
        this.reportIfMissingLicenseFeature(feature, name);
    }

    @Override
    protected void setLicensedFeatures() {
        this.licensedFeatures = 8;
        if ("yes".equals(this.getFeature("SAV"))) {
            this.licensedFeatures |= 1;
        }
        if ("yes".equals(this.getFeature("SAQ"))) {
            this.licensedFeatures |= 4;
        }
        if ("yes".equals(this.getFeature("SAT"))) {
            this.licensedFeatures |= 2;
        }
    }

    @Override
    protected boolean testFeature(int feature) {
        return (this.licensedFeatures & feature) != 0;
    }

    @Override
    protected void needEnterpriseEdition() {
        throw new UnsupportedOperationException("This operation requires a valid Saxon-EE license file");
    }

    @Override
    public StyleNodeFactory makeStyleNodeFactory(Compilation compilation) {
        int feature;
        int locLic;
        PackageData pack = compilation.getPackageData();
        if (pack != null && !this.isFeatureAllowedBySecondaryLicense(locLic = pack.getLocalLicenseId(), feature = 1) && !this.isLicensedFeature(feature)) {
            return super.makeStyleNodeFactory(compilation);
        }
        return new StyleNodeFactoryEE(this, compilation);
    }

    @Override
    public StylesheetPackage makeStylesheetPackage() {
        return this.isLicensedFeature(2) ? new StylesheetPackageEE(this) : new StylesheetPackage(this);
    }

    @Override
    public AccumulatorRegistry makeAccumulatorRegistry() {
        return new AccumulatorRegistryEE();
    }

    @Override
    public BuiltInFunctionSet getVendorFunctionSet() {
        if (this.isLicensedFeature(1)) {
            return VendorFunctionSetEE.getInstance();
        }
        return super.getVendorFunctionSet();
    }

    @Override
    public UserFunction newUserFunction(boolean memoFunction, FunctionStreamability streamability) {
        if (memoFunction) {
            return new MemoFunction();
        }
        if (streamability != FunctionStreamability.UNCLASSIFIED) {
            return new StreamableUserFunction();
        }
        return new UserFunction();
    }

    @Override
    public TypeHierarchy getTypeHierarchy() {
        if (this.typeHierarchy == null) {
            this.typeHierarchy = new TypeHierarchyEE(this);
        }
        return this.typeHierarchy;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
        resolver.setConfiguration(this);
    }

    @Override
    public InvalidityReportGeneratorEE createValidityReporter() {
        return new InvalidityReportGeneratorEE(this);
    }

    @Override
    public PackageLoaderEE makePackageLoader() {
        return new PackageLoaderEE(this);
    }

    public SchemaCompiler newSchemaCompiler() {
        SchemaCompiler compiler = new SchemaCompiler(this);
        compiler.setLanguageVersion(this.xsdVersion);
        return compiler;
    }

    public void setOccurrenceLimits(int minimum, int maximum) {
        if (minimum < 1 || minimum >= maximum) {
            throw new IllegalArgumentException("Invalid occurrence limits: min<1 or max<min");
        }
        this.occurrenceLimits = new int[]{minimum, maximum};
    }

    public int[] getOccurrenceLimits() {
        return this.occurrenceLimits;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        SchemaURIResolver r = this.schemaURIResolver;
        if (r == null) {
            r = this.standardSchemaResolver;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamespaceUri readSchema(PipelineConfiguration pipe, String baseURI, String schemaLocation, NamespaceUri expected) throws SchemaException {
        PreparedSchema preparedSchema = this.superSchema;
        synchronized (preparedSchema) {
            int status = this.getNamespaceStatus(expected);
            if (status == 1 || status == 3 && this.getConfigurationProperty(Feature.MULTIPLE_SCHEMA_IMPORTS).booleanValue()) {
                SchemaCompiler schemaCompiler = this.newSchemaCompiler();
                if (pipe.getErrorReporter() != null) {
                    schemaCompiler.setErrorReporter(pipe.getErrorReporter());
                }
                NamespaceUri ns = schemaCompiler.readSchema(pipe, baseURI, schemaLocation, expected);
                schemaCompiler.makeAllAutomata();
                schemaCompiler.checkAllAutomata();
                return ns;
            }
            return expected;
        }
    }

    @Override
    public void readMultipleSchemas(PipelineConfiguration pipe, String baseURI, List<String> schemaLocations, NamespaceUri expected) throws SchemaException {
        this.newSchemaCompiler().readMultipleSchemas(pipe, baseURI, schemaLocations, expected);
    }

    @Override
    public NamespaceUri readInlineSchema(NodeInfo root, NamespaceUri expected, ErrorReporter errorReporter) throws SchemaException {
        return this.newSchemaCompiler().readInlineSchema(root, expected, errorReporter);
    }

    @Override
    public void addSchemaSource(Source schemaSource, ErrorReporter errorReporter) throws SchemaException {
        this.addSchemaSource(schemaSource, errorReporter, this.newSchemaCompiler());
    }

    public synchronized void addSchemaSource(Source schemaSource, ErrorReporter errorReporter, SchemaCompiler compiler) throws SchemaException {
        block8: {
            try {
                if (schemaSource instanceof SAXSource && this.getBooleanProperty(Feature.IGNORE_SAX_SOURCE_PARSER)) {
                    ((SAXSource)schemaSource).setXMLReader(null);
                }
                if (errorReporter != null) {
                    compiler.setErrorReporter(errorReporter);
                }
                PipelineConfiguration pipe = this.makePipelineConfiguration();
                pipe.setErrorReporter(errorReporter == null ? this.makeErrorReporter() : errorReporter);
                pipe.setHostLanguage(HostLanguage.XML_SCHEMA);
                SchemaDocument schemadoc = SchemaReader.read(schemaSource, compiler, pipe, null);
                if (schemadoc.isCompiledSchemaDocument()) {
                    try {
                        this.importComponents(schemadoc.getDocument().getRootNode().asActiveSource());
                        break block8;
                    }
                    catch (XPathException e) {
                        throw new SchemaException(e);
                    }
                }
                compiler.validate(schemadoc);
                this.setNamespaceStatus(schemadoc.getTargetNamespace(), 3);
            }
            catch (UncheckedXPathException e) {
                XPathException xe = e.getXPathException();
                if (xe instanceof SchemaException) {
                    throw (SchemaException)xe;
                }
                throw new SchemaException(xe);
            }
        }
    }

    public synchronized void addSchema(PreparedSchema pschema) throws SchemaException {
        this.checkLicensedFeature(1, "schema processing", pschema.getLocalLicenseId());
        if (pschema == this.superSchema) {
            return;
        }
        if (pschema instanceof SingleNamespaceSchema) {
            NamespaceUri targetNamespace = ((SingleNamespaceSchema)pschema).getTargetNamespace();
            this.setNamespaceStatus(targetNamespace, 3);
        } else {
            for (NamespaceUri ns : pschema.getTargetNamespaces()) {
                this.setNamespaceStatus(ns, 3);
            }
        }
        pschema.copyTo(this.superSchema, this.newSchemaCompiler());
        this.superSchema.setLocalLicenseId(pschema.getLocalLicenseId());
    }

    public synchronized void addSurrogateSchema(NamespaceUri namespace) {
        this.checkLicensedFeature(1, "schema processing", -1);
        this.setNamespaceStatus(namespace, 2);
    }

    @Override
    public void addSchemaForBuiltInNamespace(NamespaceUri namespace) {
        if (this.getNamespaceStatus(namespace) != 1) {
            return;
        }
        if (namespace == NamespaceUri.XML) {
            this.addSchemaForXmlNamespace();
        } else if (namespace == NamespaceUri.SCHEMA_INSTANCE) {
            this.addSchemaForXsiNamespace();
        } else if (namespace == NamespaceUri.FN) {
            InputStream in = Version.platform.locateResource("xpath-functions.scm", new ArrayList<String>());
            if (this.isTiming()) {
                this.getLogger().info("Loading schema from resources for: http://www.w3.org/2005/xpath-functions");
            }
            try {
                this.addSchemaSource(new StreamSource(in), this.makeErrorReporter());
                in.close();
            }
            catch (IOException | SchemaException e) {
                throw new IllegalStateException("Failed to load internal copy of xpath-functions.scm");
            }
        } else {
            throw new IllegalArgumentException(namespace.toString());
        }
    }

    private synchronized void addSchemaForXmlNamespace() {
        if (this.getNamespaceStatus(NamespaceUri.XML) == 1) {
            try {
                this.addSchema(XMLNamespaceSchema.buildSchema(this));
            }
            catch (SchemaException err) {
                throw new AssertionError((Object)err);
            }
            this.setNamespaceStatus(NamespaceUri.XML, 3);
        }
    }

    private synchronized void addSchemaForXsiNamespace() {
        if (this.getNamespaceStatus(NamespaceUri.SCHEMA_INSTANCE) == 1) {
            try {
                this.addSchema(XSINamespaceSchema.buildSchema(this));
            }
            catch (SchemaException err) {
                throw new AssertionError((Object)err);
            }
            this.setNamespaceStatus(NamespaceUri.SCHEMA_INSTANCE, 3);
        }
    }

    public synchronized int getNamespaceStatus(NamespaceUri namespace) {
        return this.namespaceStatus.getOrDefault(namespace, 1);
    }

    public synchronized void setNamespaceStatus(NamespaceUri namespace, int status) {
        if (status == 1) {
            this.namespaceStatus.remove(namespace);
        } else {
            this.namespaceStatus.put(namespace, status);
        }
    }

    @Override
    public boolean isSchemaAvailable(NamespaceUri targetNamespace) {
        return this.getNamespaceStatus(targetNamespace) != 1;
    }

    public synchronized void removeSchema(NamespaceUri namespace) {
        this.namespaceStatus.remove(namespace);
    }

    @Override
    public synchronized Set<NamespaceUri> getImportedNamespaces() {
        return this.namespaceStatus.keySet();
    }

    public PreparedSchema getSuperSchema() {
        return this.superSchema;
    }

    @Override
    public void sealNamespace(NamespaceUri namespace) {
        if (!namespace.equals(NamespaceUri.ANONYMOUS)) {
            this.setNamespaceStatus(namespace, 4);
        }
    }

    public boolean isSealedNamespace(NamespaceUri namespace) {
        return this.getNamespaceStatus(namespace) == 4;
    }

    @Override
    public Collection<GlobalParam> getDeclaredSchemaParameters() {
        return this.getSuperSchema().getGlobalParams();
    }

    @Override
    public Iterable<? extends SchemaType> getExtensionsOfType(SchemaType type) {
        if (type instanceof UserDefinedType) {
            return ((UserDefinedType)type).getExtensionTypes();
        }
        return this.getSuperSchema().getExtensionsOfBuiltInType(type.getFingerprint());
    }

    @Override
    public void importComponents(Source source) throws XPathException {
        try {
            SchemaModelLoader loader = new SchemaModelLoader(this);
            PreparedSchema schema = loader.load(source);
            this.addSchema(schema);
            schema.copyTo(this.superSchema, this.newSchemaCompiler());
            for (NamespaceUri ns : schema.getTargetNamespaces()) {
                this.setNamespaceStatus(ns, 3);
            }
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public FunctionLibrary loadStubFunctionLibrary(StreamSource jsonSignatures) throws XPathException {
        StubFunctionLibrary lib = new StubFunctionLibrary(this);
        lib.loadSignatures(jsonSignatures);
        return lib;
    }

    @Override
    public void exportComponents(Receiver out) throws XPathException {
        SchemaModelSerializer serializer = new SchemaModelSerializer(this, out);
        serializer.serialize();
    }

    @Override
    public void clearSchemaCache() {
        this.superSchema = new PreparedSchema(this);
        this.namespaceStatus = new HashMap();
    }

    @Override
    public SchemaDeclaration getElementDeclaration(int fingerprint) {
        return this.superSchema.getElementDecl(fingerprint);
    }

    @Override
    public SchemaDeclaration getElementDeclaration(StructuredQName qName) {
        return this.superSchema.getElementDecl(qName);
    }

    @Override
    public SchemaDeclaration getAttributeDeclaration(int fingerprint) {
        return this.superSchema.getAttributeDecl(fingerprint);
    }

    @Override
    public SchemaDeclaration getAttributeDeclaration(StructuredQName attributeName) {
        return this.superSchema.getAttributeDecl(attributeName);
    }

    @Override
    public SchemaType getSchemaType(StructuredQName name) {
        SchemaType t;
        if (name.hasURI(NamespaceUri.SCHEMA) && (t = BuiltInType.getSchemaTypeByLocalName(name.getLocalPart())) != null) {
            return t;
        }
        return this.superSchema.getType(name);
    }

    @Override
    public UserUnionType makeUserUnionType(List<AtomicType> memberTypes) {
        ArrayList<TypeReference> memberRefs = new ArrayList<TypeReference>(memberTypes.size());
        for (AtomicType at : memberTypes) {
            TypeReference ref = new TypeReference(at.getFingerprint(), this, Loc.NONE);
            memberRefs.add(ref);
        }
        UserUnionType uut = new UserUnionType(this);
        StringBuilder fsb = new StringBuilder(256);
        String sep = "";
        for (AtomicType at : memberTypes) {
            fsb.append(sep);
            sep = "-";
            fsb.append(at.getName());
        }
        String localName = fsb.toString();
        StructuredQName name = new StructuredQName("anon", NamespaceUri.ANONYMOUS, localName);
        uut.setTypeName(name, this.getNamePool().allocateFingerprint(NamespaceUri.ANONYMOUS, localName));
        uut.setMemberTypeReferences(memberRefs);
        return uut;
    }

    @Override
    public boolean isDeclaredNotation(NamespaceUri uri, String local) {
        return this.superSchema.getNotation(new StructuredQName("", uri, local)) != null;
    }

    @Override
    public void checkTypeDerivationIsOK(SchemaType derived, SchemaType base, int block) throws SchemaException {
        if (derived.isSimpleType()) {
            String s = UserSimpleType.isTypeDerivationOK((SimpleType)derived, base, block);
            if (s != null) {
                throw new SchemaException(s);
            }
        } else {
            UserComplexType.checkTypeDerivation((ComplexType)derived, base, block);
        }
    }

    @Override
    public void prepareValidationReporting(XPathContext context, ParseOptions options) {
    }

    @Override
    public Receiver getDocumentValidator(Receiver receiver, String systemId, ParseOptions validationOptions, Location initiatingLocation) {
        int validationMode = validationOptions.getSchemaValidationMode();
        SpaceStrippingRule stripRules = validationOptions.getSpaceStrippingRule();
        SchemaType schemaType = validationOptions.getTopLevelType();
        StructuredQName topLevelElementName = validationOptions.getTopLevelElement();
        ValidationParams params = validationOptions.getValidationParams();
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        if (validationMode == 1 || validationMode == 2 || schemaType != null) {
            HostLanguage hostLanguage;
            Receiver destination = receiver;
            if (stripRules == null) {
                stripRules = this.getParseOptions().getSpaceStrippingRule();
            }
            if (stripRules == IgnorableSpaceStrippingRule.getInstance()) {
                destination = stripRules.makeStripper(destination);
            }
            ValidationContext vc = new ValidationContext(this.getConversionRules());
            vc.setInitiatingLocation(initiatingLocation);
            vc.setErrorLimit(validationOptions.getValidationErrorLimit());
            if (pipe.getController() == null) {
                pipe.setController(new Controller(this));
                pipe.getController().getExecutable().setSchemaAware(true);
            }
            vc.setController(pipe.getController());
            vc.setValidationParams(params);
            pipe.setComponent("com.saxonica.ee.validate.ValidationContext", vc);
            if (validationOptions.isCheckEntityReferences()) {
                EntityValidator ev = new EntityValidator(destination);
                ev.setValidationContext(vc);
                destination = ev;
            }
            this.allocateInvalidityHandler(validationOptions, vc);
            IdValidator idval = new IdValidator(destination);
            idval.setValidationContext(vc);
            ConstraintChecker checker = new ConstraintChecker(pipe);
            checker.setValidationContext(vc);
            destination = new TeeOutputter(idval, checker);
            destination = this.allocateAssertionTreeBuilder(destination, pipe, vc);
            ValidationStack val = new ValidationStack(destination, validationMode, schemaType);
            val.setPipelineConfiguration(pipe);
            val.setValidationContext(vc);
            vc.setConstraintChecker(checker);
            if (topLevelElementName != null) {
                val.setTopLevelElement(new FingerprintedQName(topLevelElementName.getPrefix(), topLevelElementName.getNamespaceUri(), topLevelElementName.getLocalPart()));
            }
            if ((hostLanguage = pipe.getHostLanguage()) == HostLanguage.XSLT) {
                if (schemaType != null) {
                    vc.setErrorCode("XTTE1540");
                } else if (validationMode == 1) {
                    vc.setErrorCode("XTTE1510");
                } else {
                    vc.setErrorCode("XTTE1515");
                }
            } else if (hostLanguage == HostLanguage.XQUERY) {
                vc.setErrorCode("XQDY0027");
            } else if (hostLanguage == HostLanguage.XML_SCHEMA) {
                vc.setErrorCode(null);
            }
            XSIAttributeHandler xsi = new XSIAttributeHandler(val);
            xsi.setSystemId(systemId);
            AttributeInheritor stb = new AttributeInheritor(xsi);
            vc.setAttributeInheritor(stb);
            xsi.setValidationContext(vc);
            PathMaintainer pathMaintainer = new PathMaintainer(stb);
            pipe.setComponent("net.sf.saxon.event.PathMaintainer", pathMaintainer);
            DocumentValidator dv = new DocumentValidator(pathMaintainer, hostLanguage == HostLanguage.XSLT ? "XTTE1550" : "XQDY0061");
            LocationCopier copier = new LocationCopier(true, systemId);
            pipe.setCopyInformee(CSharp.methodRef(copier::notifyElementNode));
            vc.startValidation(systemId);
            return dv;
        }
        if (validationMode == 4) {
            SkipValidator a = new SkipValidator(receiver);
            ValidationContext vc = new ValidationContext(this.getConversionRules());
            a.setValidationContext(vc);
            a.setSystemId(systemId);
            return a;
        }
        return receiver;
    }

    private void allocateInvalidityHandler(ParseOptions validationOptions, ValidationContext vc) {
        if (validationOptions.getInvalidityHandler() == null) {
            ErrorReporter reporter = validationOptions.getErrorReporter();
            if (reporter == null) {
                Controller controller = vc.getController();
                reporter = controller != null ? controller.getErrorReporter() : this.makeErrorReporter();
            }
            vc.setInvalidityHandler(new InvalidityHandlerWrappingErrorReporter(reporter));
        } else {
            vc.setInvalidityHandler(validationOptions.getInvalidityHandler());
        }
    }

    @Override
    public Receiver getElementValidator(Receiver receiver, ParseOptions options, Location location) throws XPathException {
        int validation = options.getSchemaValidationMode();
        SchemaType schemaType = options.getTopLevelType();
        StructuredQName elemName = options.getTopLevelElement();
        if (validation == 4) {
            if (receiver.usesTypeAnnotations()) {
                return new SkipValidator(receiver);
            }
            return receiver;
        }
        Receiver destination = receiver;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        pipe.setRecoverFromValidationErrors(this.isValidationWarnings() || options.isContinueAfterValidationErrors());
        ValidationContext vc = new ValidationContext(this.getConversionRules());
        vc.setErrorLimit(options.getValidationErrorLimit());
        vc.setController(pipe.getController());
        vc.setValidationParams(options.getValidationParams());
        vc.setInitiatingLocation(location);
        this.allocateInvalidityHandler(options, vc);
        ConstraintChecker checker = new ConstraintChecker(pipe);
        checker.setValidationContext(vc);
        destination = new TeeOutputter(destination, checker);
        vc.setConstraintChecker(checker);
        destination = this.allocateAssertionTreeBuilder(destination, pipe, vc);
        ContentValidator contentValidator = null;
        if (validation == 8) {
            ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>(1);
            contentValidator = ContentValidator.makeValidatorForType(null, schemaType, pipe, destination, failures);
            if (!failures.isEmpty()) {
                throw ((ValidationFailure)failures.get(0)).makeException();
            }
            assert (contentValidator != null);
            contentValidator.setContainingElement(options.getTopLevelElement(), location);
            contentValidator.setValidationContext(vc);
        } else if (validation != 3) {
            if (elemName == null) {
                throw new IllegalArgumentException("When validating an element, either a type or an element name must be supplied");
            }
            ElementDecl decl = (ElementDecl)this.getElementDeclaration(elemName);
            if (decl == null || !decl.hasTypeAlternatives()) {
                ArrayList<ValidationFailure> failures = new ArrayList<ValidationFailure>(1);
                contentValidator = ContentValidator.makeValidator(decl, elemName, location, vc, schemaType, validation, pipe, destination, failures);
                if (!failures.isEmpty()) {
                    throw ((ValidationFailure)failures.get(0)).makeException();
                }
            }
        }
        ValidationStack vs = new ValidationStack(destination, 1, null);
        vs.setValidationContext(vc);
        vs.setPipelineConfiguration(pipe);
        HostLanguage hostLanguage = pipe.getHostLanguage();
        if (hostLanguage == HostLanguage.XSLT) {
            if (validation == 8) {
                vc.setErrorCode("XTTE1540");
            } else if (validation == 1) {
                vc.setErrorCode("XTTE1510");
            } else {
                vc.setErrorCode("XTTE1515");
            }
        } else if (hostLanguage == HostLanguage.XQUERY) {
            vc.setErrorCode("XQDY0027");
        } else if (hostLanguage == HostLanguage.XML_SCHEMA) {
            vc.setErrorCode(null);
        }
        if (contentValidator != null) {
            vs.setInitialValidator(contentValidator);
        }
        XSIAttributeHandler xsi = new XSIAttributeHandler(vs);
        AttributeInheritor inheritor = new AttributeInheritor(xsi);
        vc.setAttributeInheritor(inheritor);
        xsi.setValidationContext(vc);
        destination = inheritor;
        vc.startValidation(location.getSystemId());
        return destination;
    }

    private Receiver allocateAssertionTreeBuilder(Receiver destination, PipelineConfiguration pipe, ValidationContext vc) {
        if (this.xsdVersion == 11) {
            boolean retainComments = this.getBooleanProperty(Feature.ASSERTIONS_CAN_SEE_COMMENTS);
            AssertionTreeBuilder atb = new AssertionTreeBuilder(destination, retainComments);
            atb.setPipelineConfiguration(pipe);
            vc.setAssertionTreeBuilder(atb);
            pipe.setComponent("com.saxonica.ee.validate.AssertionTreeBuilder", atb);
            destination = atb;
        }
        return destination;
    }

    @Override
    public SimpleType validateAttribute(StructuredQName nodeName, UnicodeString value, int validation) throws ValidationException, MissingComponentException {
        if (this.isLicenseNotFound()) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        AttributeDecl decl = (AttributeDecl)this.getAttributeDeclaration(nodeName);
        if (decl == null) {
            if (validation == 1) {
                ValidationFailure ve = new ValidationFailure("No global attribute declaration found for attribute " + nodeName.getDisplayName());
                ve.setErrorCode("XTTE1512");
                throw ve.makeException();
            }
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        SimpleType type = decl.getSimpleType();
        if (type.isNamespaceSensitive()) {
            ValidationFailure nsErr = new ValidationFailure("Cannot create a parentless attribute whose type is namespace-sensitive (such as xs:QName)");
            nsErr.setSchemaType(type);
            nsErr.setErrorCode("XTTE1545");
            throw nsErr.makeException();
        }
        ValidationFailure contentErr = type.validateContent(value, DummyNamespaceResolver.getInstance(), this.getConversionRules());
        if (contentErr != null) {
            contentErr.setSchemaType(type);
            contentErr.setErrorCode(validation == 1 ? "XTTE1510" : "XTTE1515");
            throw contentErr.makeException();
        }
        return type;
    }

    @Override
    public Receiver getAnnotationStripper(Receiver destination) {
        return new SkipValidator(destination);
    }

    @Override
    public XPathParser newExpressionParser(String language, boolean updating, StaticContext env) throws XPathException {
        if (updating && !this.isLicensedFeature(4)) {
            throw new IllegalArgumentException("XQuery Update requires a Saxon-EE license");
        }
        if ("XQ".equals(language)) {
            XQueryParser parser = new XQueryParser(env);
            if (this.isLicensedFeature(4)) {
                parser.setParserExtension(new XQueryParserExtensionEE(updating));
            } else if (this.isLicensedFeature(8)) {
                parser.setParserExtension(new XQueryParserExtensionPE());
            }
            return parser;
        }
        XPathParser parser = super.newExpressionParser(language, updating, env);
        if (this.isLicensedFeature(1)) {
            parser.setAccelerator(new QuickXPathParser());
        }
        return parser;
    }

    @Override
    public ExpressionPresenter newExpressionExporter(String target, OutputStream destination, StylesheetPackage rootPackage) throws XPathException {
        this.checkLicensedFeature(2, "stylesheet export", -1);
        ExpressionPresenter presenter = new ExpressionPresenter();
        ExpressionPresenter.ExportOptions options = new ExpressionPresenter.ExportOptions();
        options.rootPackage = rootPackage;
        presenter.setOptions(options);
        switch (target) {
            case "JS": 
            case "JS2": 
            case "JS3": {
                if (rootPackage.getHostLanguageVersion() >= 40) {
                    throw new XPathException("Cannot export SEF files to SaxonJS if 4.0 language extensions are enabled");
                }
                options.target = "JS";
                options.targetVersion = target.equals("JS3") ? 3 : 2;
                PipelineConfiguration pipe = this.makePipelineConfiguration();
                JSONEmitter writer = new JSONEmitter(pipe, new UTF8Writer(destination), new Properties());
                presenter.init((Configuration)this, new ExpressionPresenterToJson(writer, pipe), true);
                break;
            }
            default: {
                options.target = target;
                options.targetVersion = 1;
                presenter.init((Configuration)this, new StreamResult(destination), true);
            }
        }
        return presenter;
    }

    @Override
    public PendingUpdateList newPendingUpdateList() {
        return new PendingUpdateListImpl();
    }

    @Override
    public SchemaURIResolver makeSchemaURIResolver(ResourceResolver resolver) {
        StandardSchemaResolver schemaResolver = new StandardSchemaResolver(this);
        schemaResolver.setResourceResolver(resolver);
        return schemaResolver;
    }

    @Override
    public FilterFactory makeDocumentProjector(PathMap.PathMapRoot map) {
        this.checkLicensedFeature(4, "document projection", -1);
        return next -> new Projector(map, next);
    }

    @Override
    public FilterFactory makeDocumentProjector(XQueryExpression exp) {
        PathMap map;
        PathMap.PathMapRoot contextRoot;
        if (exp instanceof XQueryExpressionEE && (contextRoot = (map = ((XQueryExpressionEE)exp).getPathMap()).getContextDocumentRoot()) != null && !contextRoot.hasUnknownDependencies()) {
            return this.makeDocumentProjector(contextRoot);
        }
        return null;
    }

    @Override
    public Function<SequenceIterator, FocusTrackingIterator> getFocusTrackerFactory(Executable exec, boolean multithreaded) {
        if (multithreaded || this.getBooleanProperty(Feature.ALLOW_MULTITHREADING) && exec.createsSecondaryResult() && this.isLicensedFeature(2)) {
            return CSharp.constructorRef(MultithreadedFocusTrackingIterator::new, 1);
        }
        return CSharp.constructorRef(FocusTrackingIterator::new, 1);
    }

    public void setStreamabilityEnabled(boolean enabled) {
        this.streamabilityEnabled = Optional.of(enabled);
    }

    @Override
    public boolean isStreamabilityEnabled() {
        if (!this.streamabilityEnabled.isPresent()) {
            this.streamabilityEnabled = Optional.of(this.isLicensedFeature(2) || this.isLicensedFeature(4));
        }
        return this.streamabilityEnabled.get();
    }

    @Override
    public Receiver makeStreamingTransformer(Mode mode, ParameterSet ordinaryParams, ParameterSet tunnelParams, Outputter out, XPathContext context) throws XPathException {
        Set<? extends Accumulator> modeAccs;
        this.checkLicensedFeature(2, "streaming", -1);
        PipelineConfiguration pipe = context.getController().makePipelineConfiguration();
        AccumulatorRegistryEE am = (AccumulatorRegistryEE)((PreparedStylesheet)context.getController().getExecutable()).getTopLevelPackage().getAccumulatorRegistry();
        Set<Object> accumulators = null;
        if (mode instanceof ModeEE && (modeAccs = ((ModeEE)mode).getAccumulators()) != null) {
            accumulators = modeAccs;
        }
        if (accumulators == null) {
            accumulators = Collections.emptySet();
        }
        WatchManager wm = new WatchManager(pipe);
        wm.setXPathContext(context);
        wm.setOutputter(out);
        if (am != null) {
            AccumulatorRegistryEE.registerSelectedAccumulators(wm, accumulators);
        }
        DecomposingFeed feed = new DecomposingFeed(out, context);
        ApplyTemplatesAction docWatch = new ApplyTemplatesAction(null, feed, context);
        docWatch.setMode(mode.getDeclaringComponent());
        docWatch.setWatchManager(wm);
        docWatch.setActualParams(ordinaryParams);
        docWatch.setTunnelParams(tunnelParams);
        Trigger watch = new Trigger(new NodeTestPattern(NodeKindTest.DOCUMENT), docWatch, context);
        wm.addWatch(watch, true);
        return new ContentDetector(wm);
    }

    @Override
    public Expression makeStreamInstruction(Expression hrefExp, Expression body, boolean streaming, ParseOptions options, PackageData packageData, Location location, RetainedStaticContext rsc) throws XPathException {
        if (streaming && this.isLicensedFeature(2)) {
            StreamInstr si = new StreamInstr(hrefExp, body, options);
            si.setLocation(location);
            si.setRetainedStaticContext(rsc);
            if (this.getBooleanProperty(Feature.STRICT_STREAMABILITY)) {
                ArrayList<String> reasons = new ArrayList<String>();
                si.checkStreamability(reasons, this.isStreamabilityEnabled(), true);
                ExpressionTool.clearStreamabilityData(si);
            }
            if (packageData != null) {
                return si.prepareForStreaming(packageData);
            }
            return si;
        }
        return super.makeStreamInstruction(hrefExp, body, streaming, options, packageData, location, rsc);
    }

    @Override
    public void checkStrictStreamability(XSLTemplate template, Expression body) throws XPathException {
        ContextItemStaticInfoEE info = (ContextItemStaticInfoEE)this.makeContextItemStaticInfo(template.getMatch().getItemType(), false);
        info.setContextPostureStriding();
        ArrayList<String> reasons = new ArrayList<String>();
        PostureAndSweep s = Streamability.getStreamability(body, info, reasons);
        if (s.getPosture() != Posture.GROUNDED) {
            StringBuilder message = new StringBuilder("Template rule is not guaranteed-streamable");
            for (String r : reasons) {
                message.append("\n  *  ").append(r);
            }
            template.compileError(message.toString(), "XTSE3430");
        }
        ExpressionTool.clearStreamabilityData(body);
    }

    @Override
    public boolean isStreamedNode(NodeInfo node) {
        return node instanceof FleetingNode;
    }

    @Override
    public OptimizerOptions getOptimizerOptions() {
        return this.optimizerOptions.intersect(OptimizerOptions.FULL_EE_OPTIMIZATION);
    }

    @Override
    public OptimizerOptions getPermittedOptimizerOptions() {
        return OptimizerOptions.FULL_EE_OPTIMIZATION;
    }

    @Override
    public Optimizer obtainOptimizer() {
        if (!this.isLicensedFeature(1)) {
            return super.obtainOptimizer();
        }
        if (this.optimizer == null) {
            this.optimizer = new OptimizerEE(this);
            this.optimizer.setOptimizerOptions(this.optimizerOptions.intersect(OptimizerOptions.FULL_EE_OPTIMIZATION));
        }
        return this.optimizer;
    }

    @Override
    public Optimizer obtainOptimizer(OptimizerOptions options) {
        if (!this.isLicensedFeature(1)) {
            return super.obtainOptimizer(options);
        }
        OptimizerEE optimizer = new OptimizerEE(this);
        optimizer.setOptimizerOptions(options.intersect(OptimizerOptions.FULL_EE_OPTIMIZATION));
        return optimizer;
    }

    @Override
    public boolean isJITEnabled() {
        return this.optimizerOptions.isSet(1024) && this.isLicensedFeature(2);
    }

    @Override
    public XQueryExpression makeXQueryExpression(Expression exp, QueryModule mainModule, boolean streaming) throws XPathException {
        if (!this.isLicensedFeature(4)) {
            return super.makeXQueryExpression(exp, mainModule, streaming);
        }
        XQueryExpressionEE xqe = new XQueryExpressionEE(exp, mainModule, streaming);
        if (mainModule.getCodeInjector() != null) {
            mainModule.getCodeInjector().process(xqe);
        }
        return xqe;
    }

    @Override
    public RegularExpression compileRegularExpression(UnicodeString regex, String flags, String hostLanguage, List<String> warnings) throws XPathException {
        if (this.optimizerOptions.isSet(4096)) {
            ++this.regexAttempts;
            String key = hostLanguage + flags + '=' + regex.toString();
            RegularExpression re = this.regexCache.get(key);
            if (re == null) {
                re = super.compileRegularExpression(regex, flags, hostLanguage, warnings);
                this.regexCache.put(key, re);
                if (this.regexCache.size() == 1000 && this.regexAttempts < 5000L) {
                    this.optimizerOptions = new OptimizerOptions(this.optimizerOptions.getOptions() & 0xFFFFEFFF);
                    this.regexCache.clear();
                }
            }
            return re;
        }
        return super.compileRegularExpression(regex, flags, hostLanguage, warnings);
    }

    @Override
    public SlotManager makeSlotManager() {
        if (this.getDebugger() != null) {
            return super.makeSlotManager();
        }
        if (this.isLicensedFeature(1)) {
            return new SlotManagerEE();
        }
        return new SlotManager();
    }

    public int getResultDocumentThreadsLimit() {
        return this.resultDocumentThreadsLimit;
    }

    @Override
    public void processResultDocument(ResultDocument instruction, PushEvaluator content, XPathContext context) throws XPathException {
        RegexIterator regexItr;
        GroupIterator groupItr;
        if (this.resultDocumentThreadsLimit <= 1 || !this.getBooleanProperty(Feature.ALLOW_MULTITHREADING) || !instruction.isAsynchronous() || !this.isLicensedFeature(2) || instruction.getHref() == null || context.getContextItem() instanceof FleetingNode || context.getThreadManager() == null) {
            super.processResultDocument(instruction, content, context);
            return;
        }
        ThreadManagerEE manager = (ThreadManagerEE)context.getThreadManager();
        XPathContextMajor c3 = XPathContextMajor.newThreadContext((XPathContextMinor)context);
        c3.setOrigin(instruction);
        if (context.getCurrentIterator() != null) {
            ManualIterator manualIterator = new ManualIterator(context.getContextItem(), context.getCurrentIterator().position());
            manualIterator.setLengthFinder(CSharp.methodRef(context::getLast));
            c3.setCurrentIterator(manualIterator);
        }
        if ((groupItr = context.getCurrentGroupIterator()) != null) {
            ManualGroupIterator manualGroupIterator = groupItr.getSnapShot(context);
            c3.setCurrentGroupIterator(manualGroupIterator);
        }
        if ((regexItr = context.getCurrentRegexIterator()) != null) {
            ManualRegexIterator manualRegexIterator = new ManualRegexIterator(regexItr);
            c3.setCurrentRegexIterator(manualRegexIterator);
        }
        Callable<Outcome> task = () -> {
            try {
                instruction.processInstruction(content, c3);
                return new Outcome<Boolean>(true);
            }
            catch (Exception e) {
                return new Outcome(e);
            }
        };
        manager.getCompletionService().submit(task);
    }

    public MultithreadingFactory getMultithreadingFactory() {
        return this.multithreadingFactory;
    }

    public void setMultithreadingFactory(MultithreadingFactory factory) {
        this.multithreadingFactory = factory;
    }

    @Override
    public SequenceIterator getMultithreadedItemMappingIterator(SequenceIterator base, ItemMappingFunction action) throws XPathException {
        if (this.isLicensedFeature(1) && this.getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            return this.multithreadingFactory.makeMultithreadedItemMappingIterator(base, action);
        }
        return super.getMultithreadedItemMappingIterator(base, action);
    }

    @Override
    public GroundedValue makeSequenceExtent(Expression expression, int ref, XPathContext context) throws XPathException {
        if (ref == 10000) {
            return SearchableValue.makeSearchableValue(expression.iterate(context));
        }
        try {
            return SequenceTool.toGroundedValue(expression.iterate(context));
        }
        catch (UncheckedXPathException e) {
            throw e.getXPathException();
        }
    }

    @Override
    public void declareBuiltInExtensionElementNamespaces() {
        try {
            this.setExtensionElementCreator(NamespaceUri.SAXON, SaxonElementFactoryEE.FACTORY);
            this.setExtensionElementCreator(NamespaceUri.SAXON6, Saxon6ElementFactory.FACTORY);
            this.setExtensionElementCreator(NamespaceUri.of("http://saxonica.com/ns/interactiveXSLT"), IXSLElementFactory.FACTORY);
        }
        catch (XPathException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public ContextItemStaticInfo makeContextItemStaticInfo(ItemType itemType, boolean maybeUndefined) {
        if (this.isLicensedFeature(2) || this.isLicensedFeature(4)) {
            ContextItemStaticInfoEE cit = new ContextItemStaticInfoEE(itemType, maybeUndefined);
            cit.setStrictStreamabilityRules(this.getBooleanProperty(Feature.STRICT_STREAMABILITY));
            return cit;
        }
        return super.makeContextItemStaticInfo(itemType, maybeUndefined);
    }

    @Override
    public ContextItemStaticInfo getDefaultContextItemStaticInfo() {
        return ContextItemStaticInfoEE.DEFAULT;
    }

    @Override
    public SimpleMode makeMode(StructuredQName modeName, CompilerInfo compilerInfo) {
        if (this.isLicensedFeature(2)) {
            return new ModeEE(modeName, compilerInfo);
        }
        return new ModePE(modeName);
    }

    @Override
    public TemplateRuleEE makeTemplateRule() {
        return new TemplateRuleEE();
    }

    @Override
    public XPathContextMajor.ThreadManager makeThreadManager() {
        if (this.getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            return this.multithreadingFactory.makeThreadManager();
        }
        return null;
    }

    @Override
    public CompilerInfo makeCompilerInfo() {
        return super.makeCompilerInfo();
    }
}

