/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica;

import com.saxonica.config.EnterpriseConfiguration;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.lib.DirectResourceResolver;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.InvalidityReportGenerator;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.StandardInvalidityHandler;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SchemaManager;
import net.sf.saxon.s9api.SchemaValidator;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.trace.Instrumentation;
import net.sf.saxon.trans.CommandLineOptions;
import net.sf.saxon.trans.Timer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationException;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class Validate {
    private Processor processor;
    private EnterpriseConfiguration config;
    private boolean useURLs = false;
    private boolean showTime = false;
    private int repeat = 1;
    private String validationMode = "strict";
    private int xsdLanguageVersion = 11;
    private String topLevelElementName = null;
    private boolean allowExit = true;

    public static void main(String[] args) {
        Validate validate = new Validate();
        int rc = validate.doValidate(args);
        if (rc != 0 && validate.allowExit) {
            System.exit(rc);
        }
    }

    protected void setConfiguration() {
        this.config = new EnterpriseConfiguration();
    }

    protected void setPermittedOptions(CommandLineOptions options) {
        options.addRecognizedOption("config", 258, "Use specified configuration file");
        options.addRecognizedOption("catalog", 258, "Use specified catalog file to resolve URIs");
        options.addRecognizedOption("dtd", 4, "Validate using DTD");
        options.setPermittedValues("dtd", new String[]{"on", "off", "recover"}, "on");
        options.addRecognizedOption("export", 258, "Schema output file in SCM format");
        options.addRecognizedOption("ext", 1, "Allow calls to Java extension functions");
        options.addRecognizedOption("init", 3, "User-supplied code to initialize the Saxon configuration");
        options.addRecognizedOption("limits", 10, "Limits for correct processing of minOccurs and maxOccurs");
        options.addRecognizedOption("opt", 261, "Use optimization level 0..10");
        options.addRecognizedOption("quit", 257, "Quit JVM if execution fails");
        options.addRecognizedOption("r", 259, "Use named URIResolver class");
        options.addRecognizedOption("report", 259, "Report XML file name for validation error reporting");
        options.addRecognizedOption("s", 263, "List of source files to be validated");
        options.addRecognizedOption("scmin", 258, "Schema input file in SCM format");
        options.addRecognizedOption("scmout", 258, "Retained synonym of -export");
        options.addRecognizedOption("stats", 258, "Statistics output file");
        options.addRecognizedOption("t", 1, "Display version and timing information, and names of schema documents loaded");
        options.addRecognizedOption("top", 6, "QName of required outermost element node");
        options.addRecognizedOption("u", 1, "Interpret filename arguments as URIs");
        options.setPermittedValues("u", new String[]{"on", "off"}, "on");
        options.addRecognizedOption("val", 260, "Apply strict or lax validation");
        options.setPermittedValues("val", new String[]{"strict", "lax"}, "strict");
        options.addRecognizedOption("x", 259, "Use named XMLReader class for parsing source documents");
        options.addRecognizedOption("xi", 1, "Expand XInclude directives in source documents");
        options.addRecognizedOption("xmlversion", 260, "Indicate whether XML 1.1 is supported");
        options.setPermittedValues("xmlversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsd", 263, "List of schema documents to be preloaded");
        options.addRecognizedOption("xsdversion", 260, "Indicate whether XSD 1.1 is supported");
        options.setPermittedValues("xsdversion", new String[]{"1.0", "1.1"}, null);
        options.addRecognizedOption("xsiloc", 1, "Load schemas named in xsi:schemaLocation (default on)");
        options.addRecognizedOption("y", 259, "Use named XMLReader class for parsing schema documents");
        options.addRecognizedOption("?", 512, "Display command line help text");
    }

    public int doValidate(String[] args) {
        ArrayList<String> sourceFileNames = new ArrayList<String>();
        ArrayList<String> schemaFileNames = new ArrayList<String>();
        int validCount = 0;
        int invalidCount = 0;
        int unreadableCount = 0;
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        try {
            options.setActualOptions(args);
        }
        catch (XPathException err) {
            return this.quit(err.getMessage(), 2);
        }
        String configFile = options.getOptionValue("config");
        if (configFile != null) {
            try {
                Configuration fconfig = Configuration.readConfiguration(new StreamSource(configFile));
                if (!(fconfig instanceof EnterpriseConfiguration)) {
                    return this.quit("Configuration produced from the configuration file is an instance of " + fconfig.getClass() + " (not EnterpriseConfiguration): check the value of configuration/@edition", 2);
                }
                this.config = (EnterpriseConfiguration)fconfig;
            }
            catch (XPathException e) {
                return this.quit(e.getMessage(), 2);
            }
        }
        if (this.config == null) {
            this.setConfiguration();
        }
        this.processor = new Processor(this.config);
        try {
            options.applyToConfiguration(this.processor);
            this.allowExit = !"off".equals(options.getOptionValue("quit"));
            String value = options.getOptionValue("?");
            if (value != null) {
                this.badUsage("");
                return 0;
            }
            value = options.getOptionValue("limits");
            if (value != null) {
                int comma = value.indexOf(44);
                if (comma < 1) {
                    this.badUsage("format: -limits:min,max");
                    return 2;
                }
                try {
                    int min = Integer.parseInt(value.substring(0, comma));
                    int max = Integer.parseInt(value.substring(comma + 1));
                    this.config.setOccurrenceLimits(min, max);
                }
                catch (NumberFormatException e) {
                    this.badUsage("format: -limits:min,max where min and max are integers");
                }
            }
            String scmInput = options.getOptionValue("scmin");
            String scmOutput = options.getOptionValue("export");
            if (scmOutput == null) {
                scmOutput = options.getOptionValue("scmout");
            }
            if ((value = options.getOptionValue("s")) != null) {
                String delim = File.pathSeparator;
                if (this.useURLs || CommandLineOptions.isImplicitURI(value)) {
                    delim = " \t\n\r\f";
                }
                StringTokenizer tokenizer = new StringTokenizer(value, delim);
                while (tokenizer.hasMoreTokens()) {
                    sourceFileNames.add(tokenizer.nextToken());
                }
            }
            if ((value = options.getOptionValue("t")) != null) {
                this.processor.setConfigurationProperty(Feature.TIMING, true);
                this.showTime = true;
            }
            this.topLevelElementName = options.getOptionValue("top");
            this.useURLs = "on".equals(options.getOptionValue("u"));
            value = options.getOptionValue("val");
            if (value != null) {
                this.validationMode = value;
            }
            if ((value = options.getOptionValue("xsd")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(value, ";");
                while (tokenizer.hasMoreTokens()) {
                    schemaFileNames.add(tokenizer.nextToken());
                }
            }
            this.xsdLanguageVersion = "1.1".equals(this.processor.getConfigurationProperty(Feature.XSD_VERSION)) ? 11 : 10;
            sourceFileNames.addAll(options.getPositionalOptions());
            this.applyLocalOptions(options, this.config);
            if (!schemaFileNames.isEmpty() && scmInput != null) {
                this.badUsage("Cannot mix xsd and scm input");
                return 2;
            }
            if (schemaFileNames.isEmpty() && scmInput == null && sourceFileNames.isEmpty()) {
                this.badUsage("No action requested");
                return 2;
            }
            if (this.showTime) {
                this.config.getLogger().info(this.config.getProductTitle());
                this.config.getLogger().info(Version.platform.getPlatformVersion());
            }
            this.config.displayLicenseMessage();
            this.processor.setConfigurationProperty(Feature.SCHEMA_VALIDATION_MODE, this.validationMode);
            long startTime = Validate.now();
            SchemaManager manager = this.processor.getSchemaManager();
            for (String schemaFileName : schemaFileNames) {
                Source schemaSource;
                if (this.useURLs || CommandLineOptions.isImplicitURI(schemaFileName)) {
                    ResourceRequest request = new ResourceRequest();
                    request.relativeUri = schemaFileName;
                    URI cwd = CommandLineOptions.getCurrentWorkingDirectory();
                    request.baseUri = cwd.toString();
                    request.uri = cwd.resolve(schemaFileName).toString();
                    request.nature = "http://www.w3.org/2001/XMLSchema";
                    request.purpose = "http://www.rddl.org/purposes#validation";
                    schemaSource = request.resolve(this.config.getResourceResolver(), new DirectResourceResolver(this.config));
                } else if (schemaFileName.equals("-")) {
                    if (Version.platform.isJava()) {
                        InputSource inputSource = new InputSource(System.in);
                        inputSource.setSystemId(CommandLineOptions.getCurrentWorkingDirectory().toASCIIString());
                        schemaSource = new SAXSource(this.config.getStyleParser(), inputSource);
                    } else {
                        schemaSource = new StreamSource(System.in);
                    }
                } else {
                    File schemaFile = new File(schemaFileName);
                    if (!schemaFile.exists()) {
                        return this.quit("Schema file " + schemaFile + " does not exist", 2);
                    }
                    if (Version.platform.isJava()) {
                        InputSource eis = new InputSource(schemaFile.toURI().toString());
                        schemaSource = new SAXSource(this.config.getStyleParser(), eis);
                    } else {
                        schemaSource = new StreamSource(schemaFile.toURI().toString());
                    }
                }
                if (schemaSource == null) {
                    return this.quit("URIResolver for schema file must return a Source", 2);
                }
                try {
                    manager.load(schemaSource);
                }
                catch (SaxonApiException e) {
                    if (e.getCause() instanceof SchemaException) {
                        throw (SchemaException)e.getCause();
                    }
                    throw e;
                }
            }
            if (scmInput != null) {
                StreamSource scm = new StreamSource(new File(scmInput));
                manager.importComponents(scm);
            }
            if (this.showTime && !schemaFileNames.isEmpty()) {
                long endTime = Validate.now();
                this.config.getLogger().info("Schema checking successful. Time: " + (endTime - startTime) / 1000000L + "ms.");
                this.config.getLogger().info(Timer.showMemoryUsed());
            }
            SchemaValidator validator = manager.newSchemaValidator();
            validator.setLax("lax".equals(this.validationMode));
            if (this.topLevelElementName != null) {
                validator.setDocumentElementName(QName.fromClarkName(this.topLevelElementName));
            }
            if (options.definesParameterValues()) {
                options.setParams(this.processor, CSharp.methodRef(validator::setParameter));
            }
            Serializer statsSerializer = null;
            value = options.getOptionValue("stats");
            if (value != null) {
                validator.setCollectStatistics(true);
                File statsFile = new File(value);
                statsSerializer = this.processor.newSerializer(statsFile);
                statsSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                statsSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
            }
            if ((value = options.getOptionValue("report")) != null) {
                String reportXsdVersion;
                String reportFileName = value;
                Serializer reportDestination = this.processor.newSerializer();
                reportDestination.setOutputProperty(Serializer.Property.INDENT, "yes");
                reportDestination.setOutputFile(new File(reportFileName));
                validator.setValidityReporting(reportDestination);
                InvalidityReportGenerator reportHandler = (InvalidityReportGenerator)validator.getInvalidityHandler();
                String reportSchemaNames = options.getOptionValue("xsd");
                if (reportSchemaNames != null) {
                    reportHandler.setSchemaName(reportSchemaNames);
                }
                if ((reportXsdVersion = options.getOptionValue("xsdversion")) != null) {
                    reportHandler.setXsdVersion(reportXsdVersion);
                }
            } else {
                validator.setInvalidityHandler(new StandardInvalidityHandler(this.config));
            }
            if (sourceFileNames.size() > 1) {
                ArrayList sources = new ArrayList(sourceFileNames.size());
                for (String sourceFileName : sourceFileNames) {
                    Source source = Validate.loadDocument(sourceFileName, this.useURLs, this.config);
                    sources.add(source);
                }
                validator.validateMultiple(sources);
            } else {
                for (String sourceFileName : sourceFileNames) {
                    try {
                        XMLReader parser;
                        Source source = Validate.loadDocument(sourceFileName, this.useURLs, this.config);
                        this.processFile(source, validator);
                        if (this.showTime) {
                            this.config.getLogger().info("Validation successful");
                        }
                        ++validCount;
                        if (!(source instanceof SAXSource) || (parser = ((SAXSource)source).getXMLReader()) == null) continue;
                        this.config.reuseSourceParser(parser);
                    }
                    catch (SaxonApiException e) {
                        if (e.getCause() instanceof ValidationException) {
                            if (this.showTime) {
                                this.config.getLogger().warning("Validation complete: errors found");
                            } else {
                                this.config.getLogger().warning("Validation of file " + sourceFileName + " completed: errors found");
                            }
                            ++invalidCount;
                            continue;
                        }
                        this.config.getLogger().error("Failed to process file " + sourceFileName + ": " + e.getMessage());
                        ++unreadableCount;
                    }
                }
                if (this.showTime && validCount + invalidCount > 1) {
                    this.config.getLogger().info(validCount + " valid document" + (validCount == 1 ? "" : "s") + "; " + invalidCount + " invalid document" + (invalidCount == 1 ? "" : "s") + (unreadableCount == 0 ? "" : "; " + unreadableCount + " unreadable or ill-formed document" + (unreadableCount == 1 ? "" : "s")));
                }
            }
            if (statsSerializer != null) {
                validator.reportValidationStatistics(statsSerializer);
            }
            Instrumentation.report();
            if (scmOutput != null) {
                File scmOutputFile = new File(scmOutput);
                Serializer scmSerializer = this.processor.newSerializer(scmOutputFile);
                scmSerializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                scmSerializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                manager.exportComponents(scmSerializer);
                if (this.showTime) {
                    this.config.getLogger().info("Schema component model written to " + scmOutputFile.getAbsolutePath());
                }
            }
        }
        catch (SchemaException err) {
            return this.quit("Schema processing failed: " + err.getMessage(), 2);
        }
        catch (ValidationException err) {
            this.config.reportFatalError(err);
            return this.quit("Validation of source document failed", 2);
        }
        catch (XPathException err) {
            this.config.reportFatalError(err);
            return this.quit("Processing failed", 2);
        }
        catch (TransformerFactoryConfigurationError err) {
            return this.quit("Validation failed: " + err.getMessage(), 2);
        }
        catch (Exception err2) {
            err2.printStackTrace();
            return this.quit("Fatal error during validation: " + err2.getMessage(), 2);
        }
        if (unreadableCount > 0) {
            return 2;
        }
        if (invalidCount > 0) {
            return 1;
        }
        return 0;
    }

    protected void applyLocalOptions(CommandLineOptions options, Configuration config) {
    }

    protected int quit(String message, int code) {
        if (this.config != null && this.config.getLogger() != null) {
            this.config.getLogger().warning(message);
        } else {
            System.err.println(message);
        }
        if (!this.allowExit) {
            throw new RuntimeException(message);
        }
        System.exit(code);
        return code;
    }

    public static Source loadDocument(String sourceFileName, boolean useURLs, Configuration config) throws XPathException {
        Source sourceInput;
        if (useURLs || CommandLineOptions.isImplicitURI(sourceFileName)) {
            ResourceRequest request = new ResourceRequest();
            request.relativeUri = sourceFileName;
            URI cwd = CommandLineOptions.getCurrentWorkingDirectory();
            request.baseUri = cwd.toString();
            request.uri = cwd.resolve(sourceFileName).toString();
            request.nature = "https://www.iana.org/assignments/media-types/application/xml";
            request.purpose = ResourceRequest.ANY_PURPOSE;
            sourceInput = request.resolve(config.getResourceResolver(), new DirectResourceResolver(config));
        } else if (sourceFileName.equals("-")) {
            if (Version.platform.isJava()) {
                String sysId = CommandLineOptions.getCurrentWorkingDirectory().toASCIIString();
                InputSource inputSource = new InputSource(System.in);
                inputSource.setSystemId(sysId);
                sourceInput = new SAXSource(inputSource);
            } else {
                sourceInput = new StreamSource(System.in);
            }
        } else {
            File sourceFile = new File(sourceFileName);
            if (!sourceFile.exists()) {
                throw new XPathException("Source file " + sourceFile + " does not exist");
            }
            if (Version.platform.isJava()) {
                InputSource eis = new InputSource(sourceFile.toURI().toString());
                sourceInput = new SAXSource(eis);
            } else {
                sourceInput = new StreamSource(sourceFile.toURI().toString());
            }
        }
        return sourceInput;
    }

    public void processFile(Source source, SchemaValidator validator) throws SaxonApiException {
        if (this.showTime) {
            this.config.getLogger().info("Processing " + source.getSystemId());
        }
        long startTime = Validate.now();
        for (int r = 0; r < this.repeat; ++r) {
            validator.validate(source);
        }
        if (this.showTime) {
            long endTime = Validate.now();
            this.config.getLogger().info("Validation time: " + (endTime - startTime) / 1000000L + "ms.");
            this.config.getLogger().info(Timer.showMemoryUsed());
        }
    }

    protected static long now() {
        return System.nanoTime();
    }

    protected void badUsage(String message) {
        if (!"".equals(message)) {
            this.config.getLogger().error(message);
        }
        if (!this.showTime) {
            this.config.getLogger().info(this.config.getProductTitle());
        }
        this.config.getLogger().info("Usage: see http://www.saxonica.com/documentation/index.html#!schema-processing/commandline");
        this.config.getLogger().info("Format: " + CommandLineOptions.getCommandName(this) + " options");
        CommandLineOptions options = new CommandLineOptions();
        this.setPermittedOptions(options);
        this.config.getLogger().info("Options available:" + options.displayPermittedOptions());
        this.config.getLogger().info("Use -XYZ:? for details of option XYZ");
        if (this.allowExit) {
            if ("".equals(message)) {
                System.exit(0);
            } else {
                System.exit(2);
            }
        } else {
            throw new RuntimeException(message);
        }
    }
}

