/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;

public class JideToggleButton
extends JideButton
implements Accessible {
    private ItemListener _itemListener;

    public JideToggleButton() {
        this(null, null, false);
    }

    public JideToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public JideToggleButton(Icon icon, boolean selected) {
        this(null, icon, selected);
    }

    public JideToggleButton(String text) {
        this(text, null, false);
    }

    public JideToggleButton(String text, boolean selected) {
        this(text, null, selected);
    }

    public JideToggleButton(Action a) {
        this();
        this.setAction(a);
    }

    public JideToggleButton(String text, Icon icon) {
        this(text, icon, false);
    }

    public JideToggleButton(String text, Icon icon, boolean selected) {
        this.setModel(new ToggleButtonModel());
        this.model.setSelected(selected);
        this.init(text, icon);
    }

    static boolean hasSelectedKey(Action a) {
        return SystemInfo.isJdk6Above() && a != null && a.getValue("SwingSelectedKey") != null;
    }

    static boolean isSelected(Action a) {
        return SystemInfo.isJdk6Above() && Boolean.TRUE.equals(a.getValue("SwingSelectedKey"));
    }

    private void setSelectedFromAction(Action a) {
        boolean selected = false;
        if (a != null) {
            selected = JideToggleButton.isSelected(a);
        }
        if (selected != this.isSelected()) {
            ButtonGroup group;
            this.setSelected(selected);
            if (!selected && this.isSelected() && this.getModel() instanceof DefaultButtonModel && (group = ((DefaultButtonModel)this.getModel()).getGroup()) != null && SystemInfo.isJdk6Above()) {
                group.clearSelection();
            }
        }
    }

    @Override
    protected void actionPropertyChanged(Action action, String propertyName) {
        if (SystemInfo.isJdk6Above()) {
            super.actionPropertyChanged(action, propertyName);
            if ("SwingSelectedKey".equals(propertyName) && JideToggleButton.hasSelectedKey(action)) {
                this.setSelectedFromAction(action);
            }
        }
    }

    @Override
    protected void configurePropertiesFromAction(Action a) {
        super.configurePropertiesFromAction(a);
        if (JideToggleButton.hasSelectedKey(a)) {
            this.setSelectedFromAction(a);
        }
    }

    @Override
    protected ItemListener createItemListener() {
        if (this._itemListener == null) {
            this._itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    JideToggleButton.this.fireItemStateChanged(event);
                    Action action = JideToggleButton.this.getAction();
                    if (action != null && JideToggleButton.hasSelectedKey(action)) {
                        boolean selected = JideToggleButton.this.isSelected();
                        boolean isActionSelected = JideToggleButton.isSelected(action);
                        if (isActionSelected != selected && SystemInfo.isJdk6Above()) {
                            action.putValue("SwingSelectedKey", selected);
                        }
                    }
                }
            };
        }
        return this._itemListener;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        @Override
        public boolean isSelected() {
            return (this.stateMask & 2) != 0;
        }

        @Override
        public void setSelected(boolean b) {
            ButtonGroup group = this.getGroup();
            if (group != null) {
                group.setSelected(this, b);
                b = group.isSelected(this);
            }
            if (this.isSelected() == b) {
                return;
            }
            this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }

        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            if (!b && this.isArmed()) {
                this.setSelected(!this.isSelected());
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiers();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        }
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton
    implements ItemListener {
        public AccessibleJToggleButton() {
            super(JideToggleButton.this);
            JideToggleButton.this.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            JideToggleButton button = (JideToggleButton)e.getSource();
            if (JideToggleButton.this.accessibleContext != null) {
                if (button.isSelected()) {
                    JideToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    JideToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }
    }
}

