/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.SearchableProvider;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ComboBoxSearchable
extends Searchable
implements ListDataListener,
PropertyChangeListener,
PopupMenuListener {
    private boolean _refreshPopupDuringSearching = false;
    private boolean _showPopupDuringSearching = true;

    public ComboBoxSearchable(final JComboBox comboBox) {
        super(comboBox);
        comboBox.setKeySelectionManager(new JComboBox.KeySelectionManager(){

            public int selectionForKey(char aKey, ComboBoxModel aModel) {
                return -1;
            }
        });
        comboBox.getModel().addListDataListener(this);
        comboBox.addPropertyChangeListener("model", this);
        comboBox.addPopupMenuListener(this);
        if (comboBox.isEditable()) {
            Component editorComponent = comboBox.getEditor().getEditorComponent();
            final JTextField textField = (JTextField)editorComponent;
            textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if (e.getKeyChar() != '\uffff' && e.getKeyCode() != 10 && e.getKeyCode() != 27) {
                        String text = textField.getText();
                        ComboBoxModel model = comboBox.getModel();
                        ListDataListener removedListener = null;
                        if (model instanceof AbstractListModel) {
                            ListDataListener[] listeners;
                            for (ListDataListener listener : listeners = ((AbstractListModel)((Object)model)).getListDataListeners()) {
                                if (listener.getClass().toString().indexOf("BasicComboBoxUI") == -1) continue;
                                removedListener = listener;
                                model.removeListDataListener(listener);
                            }
                        }
                        if (ComboBoxSearchable.this.isShowPopupDuringSearching()) {
                            if (!comboBox.getUI().getClass().getName().contains("ExComboBoxUI")) {
                                comboBox.hidePopup();
                            }
                            comboBox.showPopup();
                        }
                        ComboBoxSearchable.this.textChanged(text);
                        if (removedListener != null) {
                            model.addListDataListener(removedListener);
                        }
                    }
                }
            });
            this.setSearchableProvider(new SearchableProvider(){

                @Override
                public String getSearchingText() {
                    return textField.getText();
                }

                @Override
                public boolean isPassive() {
                    return true;
                }

                @Override
                public void processKeyEvent(KeyEvent e) {
                }
            });
        }
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JComboBox) {
            ((JComboBox)this._component).getModel().removeListDataListener(this);
            ((JComboBox)this._component).removePopupMenuListener(this);
        }
        this._component.removePropertyChangeListener("model", this);
    }

    public boolean isShowPopupDuringSearching() {
        return this._showPopupDuringSearching;
    }

    public void setShowPopupDuringSearching(boolean showPopupDuringSearching) {
        this._showPopupDuringSearching = showPopupDuringSearching;
    }

    public boolean isRefreshPopupDuringSearching() {
        return this._refreshPopupDuringSearching;
    }

    public void setRefreshPopupDuringSearching(boolean refreshPopupDuringSearching) {
        this._refreshPopupDuringSearching = refreshPopupDuringSearching;
    }

    @Override
    protected void setSelectedIndex(int index, boolean incremental) {
        if (((JComboBox)this._component).getSelectedIndex() != index) {
            ((JComboBox)this._component).setSelectedIndex(index);
        }
        if (this.isShowPopupDuringSearching() || this.isRefreshPopupDuringSearching()) {
            if (this._component.getClientProperty("ShrinkSearchableSupport") != null && ((JComboBox)this._component).isPopupVisible()) {
                boolean old = this.isHideSearchPopupOnEvent();
                this.setHideSearchPopupOnEvent(false);
                ((JComboBox)this._component).hidePopup();
                this.setHideSearchPopupOnEvent(old);
            }
            try {
                if (!((JComboBox)this._component).isPopupVisible() && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() != null && SwingUtilities.isDescendingFrom(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this._component)) {
                    ((JComboBox)this._component).showPopup();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    @Override
    protected int getSelectedIndex() {
        return ((JComboBox)this._component).getSelectedIndex();
    }

    @Override
    protected Object getElementAt(int index) {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getElementAt(index);
    }

    @Override
    protected int getElementCount() {
        ComboBoxModel comboBoxModel = ((JComboBox)this._component).getModel();
        return comboBoxModel.getSize();
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        if (e.getIndex0() != -1 || e.getIndex1() != -1) {
            this.hidePopup();
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (!this.isProcessModelChangeEvent()) {
            return;
        }
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            this.hidePopup();
            if (evt.getOldValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)evt.getOldValue()).removeListDataListener(this);
            }
            if (evt.getNewValue() instanceof ComboBoxModel) {
                ((ComboBoxModel)evt.getNewValue()).addListDataListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        if (this.isHideSearchPopupOnEvent()) {
            this.hidePopup();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

