/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.plaf.basic.BasicSidePaneUI;
import com.jidesoft.plaf.eclipse.EclipseUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class EclipseSidePaneUI
extends BasicSidePaneUI {
    public static ComponentUI createUI(JComponent c) {
        return new EclipseSidePaneUI();
    }

    protected void drawEastPane(Graphics g, JComponent c, FontMetrics metrics, int indexOfButton) {
        int location = this._margin.top;
        int start = this._margin.left;
        int end = c.getWidth() - this._margin.left - this._margin.right - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            ++location;
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            String longestTitle = group.getLongestTitle();
            int widthOfTitle = longestTitle.length() != 0 ? SwingUtilities.computeStringWidth(metrics, longestTitle) + this._textBorderGap : 0;
            int heightOfTitle = metrics.getHeight();
            for (int j = 0; j < group.size(); ++j) {
                SidePaneItem item = (SidePaneItem)group.get(j);
                int oldLocation = location;
                if (this._alwaysShowText || group.getSelectedItem().equals(item)) {
                    int length = 2 + (item.getIcon() != null ? 2 + item.getIcon().getIconHeight() : 0);
                    if (this._alwaysShowText) {
                        widthOfTitle = SwingUtilities.computeStringWidth(metrics, item.getTitle()) + this._textBorderGap;
                        length += (widthOfTitle != 0 ? this._iconTextGap : 0) + widthOfTitle;
                    } else if (this._showText) {
                        length += (widthOfTitle != 0 ? this._iconTextGap : 0) + widthOfTitle;
                    }
                    if (group.getSelectedItem().equals(item)) {
                        g.setColor(Color.gray);
                        g.drawLine(start, location, end, location);
                        g.drawLine(start, location, start, location + length);
                        g.setColor(Color.white);
                        g.drawLine(start, location + length, end, location + length);
                        g.drawLine(end, location, end, location + length);
                        g.setColor(this._buttonBackground);
                        g.drawRect(start + 1, location + 1, end - start - 2, length - 2);
                        Graphics2D g2d = (Graphics2D)g;
                        EclipseUtils.fillRectWithHatch(g2d, new Rectangle(start + 2, location + 2, end - start - 3, length - 3), this._buttonBackground.darker());
                    }
                } else {
                    g.setColor(this._buttonBackground);
                    g.fillRect(start, location, end, this._itemGap + (item.getIcon() != null ? 2 + item.getIcon().getIconHeight() : 0));
                }
                if (item.getIcon() != null) {
                    item.getIcon().paintIcon(c, g, end + start - item.getIcon().getIconWidth() >> 1, location += 3);
                    location += item.getIcon().getIconHeight() - 1;
                }
                location += this._itemGap;
                if (this._alwaysShowText || this._showText && group.getSelectedItem().equals(item)) {
                    if (item.getTitle().length() != 0) {
                        Graphics2D g2d = (Graphics2D)g.create();
                        g2d.setFont(this._font);
                        g2d.rotate(1.5707963267948966);
                        g2d.translate(location += this._iconTextGap, -end);
                        if (item.getForeground() != null) {
                            g2d.setColor(item.getForeground());
                        } else if (item.isSelected()) {
                            g2d.setColor(this._selectedButtonForeground);
                        } else {
                            g2d.setColor(c.getForeground());
                        }
                        JideSwingUtilities.drawString(c, g2d, item.getTitle(), 0, (end - start - heightOfTitle >> 1) + metrics.getAscent());
                        g2d.dispose();
                    }
                    location += widthOfTitle;
                }
                this._rects[indexOfButton].x = start + 1;
                this._rects[indexOfButton].y = oldLocation;
                this._rects[indexOfButton].width = end - start - 1;
                this._rects[indexOfButton].height = location - oldLocation;
                ++indexOfButton;
                ++location;
            }
            g.setColor(Color.gray);
            g.drawLine(start, location += this._groupGap, end, location);
            g.setColor(Color.white);
            g.drawLine(start, ++location, end, location);
            location += this._groupGap;
        }
    }

    protected void drawWestPane(Graphics g, JComponent c, FontMetrics metrics, int indexOfButton) {
        this.drawEastPane(g, c, metrics, indexOfButton);
    }

    protected void drawNorthPane(Graphics g, JComponent c, FontMetrics metrics, int indexOfButton) {
        int location = this._margin.top;
        int start = this._margin.left;
        int end = c.getHeight() - this._margin.left - this._margin.right - 1;
        for (int i = 0; i < this._sidePane.getGroups().size(); ++i) {
            ++location;
            SidePaneGroup group = this._sidePane.getGroups().get(i);
            String longestTitle = group.getLongestTitle();
            int widthOfTitle = longestTitle.length() != 0 ? SwingUtilities.computeStringWidth(metrics, longestTitle) + this._textBorderGap : 0;
            int heightOfTitle = metrics.getHeight();
            for (int j = 0; j < group.size(); ++j) {
                SidePaneItem item = (SidePaneItem)group.get(j);
                int oldLocation = location;
                if (this._alwaysShowText || group.getSelectedItem().equals(item)) {
                    int length = 2 + (item.getIcon() != null ? 2 + item.getIcon().getIconWidth() : 0);
                    if (this._alwaysShowText) {
                        widthOfTitle = SwingUtilities.computeStringWidth(metrics, item.getTitle()) + this._textBorderGap;
                        length += (widthOfTitle != 0 ? this._iconTextGap : 0) + widthOfTitle;
                    } else if (this._showText) {
                        length += (widthOfTitle != 0 ? this._iconTextGap : 0) + widthOfTitle;
                    }
                    if (group.getSelectedItem().equals(item)) {
                        g.setColor(Color.gray);
                        g.drawLine(location, start, location, end);
                        g.drawLine(location, start, location + length, start);
                        g.setColor(Color.white);
                        g.drawLine(location + length, start, location + length, end);
                        g.drawLine(location, end, location + length, end);
                        g.setColor(this._buttonBackground);
                        g.drawRect(location + 1, start + 1, length - 2, end - start - 2);
                        Graphics2D g2d = (Graphics2D)g;
                        EclipseUtils.fillRectWithHatch(g2d, new Rectangle(location + 2, start + 2, length - 3, end - start - 3), this._buttonBackground.darker());
                    }
                } else {
                    g.setColor(this._buttonBackground);
                    g.fillRect(location, start, this._itemGap + (item.getIcon() != null ? 2 + item.getIcon().getIconWidth() : 0), end);
                }
                if (item.getIcon() != null) {
                    item.getIcon().paintIcon(c, g, location += 3, (end - item.getIcon().getIconHeight() >> 1) + start);
                    location += item.getIcon().getIconWidth() - 1;
                }
                location += this._itemGap;
                if (this._alwaysShowText || this._showText && group.getSelectedItem().equals(item)) {
                    if (item.getTitle().length() != 0) {
                        location += this._iconTextGap;
                        g.setFont(this._font);
                        if (item.getForeground() != null) {
                            g.setColor(item.getForeground());
                        } else if (item.isSelected()) {
                            g.setColor(this._selectedButtonForeground);
                        } else {
                            g.setColor(c.getForeground());
                        }
                        JideSwingUtilities.drawString(c, g, item.getTitle(), location, (end - heightOfTitle - start >> 1) + metrics.getAscent());
                    }
                    location += widthOfTitle;
                }
                this._rects[indexOfButton].y = start + 1;
                this._rects[indexOfButton].x = oldLocation;
                this._rects[indexOfButton].height = end - start - 1;
                this._rects[indexOfButton].width = location - oldLocation;
                ++indexOfButton;
                ++location;
            }
            g.setColor(Color.gray);
            g.drawLine(location += this._groupGap, start, location, end);
            g.setColor(Color.white);
            g.drawLine(++location, start, location, end);
            location += this._groupGap;
        }
    }

    protected void drawSouthPane(Graphics g, JComponent c, FontMetrics metrics, int indexOfButton) {
        this.drawNorthPane(g, c, metrics, indexOfButton);
    }
}

