/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.action.Chevron;
import com.jidesoft.action.CommandBar;
import com.jidesoft.action.CommandBarTitleBar;
import com.jidesoft.action.CommandMenuBar;
import com.jidesoft.action.DockableBar;
import com.jidesoft.plaf.CommandBarUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.basic.WLFUtil;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;

public class BasicCommandBarUI
extends CommandBarUI
implements SwingConstants {
    protected JComponent _target;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener containerListener;
    protected ChangeListener changeListener;
    private Gripper _gripper;
    private Chevron _chevron;
    private CommandBarTitleBar _titleBar;
    private ThemePainter _painter;
    protected JMenuBar _menuBar = null;
    MenuBar _screenMenuBar;
    FixupMenuBarWindowAdapter _fixupAdapter;

    boolean setScreenMenuBar(Frame frame) {
        if (frame == null) {
            return false;
        }
        try {
            if (this._screenMenuBar == null) {
                this._screenMenuBar = this.createMenuBar(this._menuBar);
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        if (SystemInfo.isJdk6Above()) {
            frame.setMenuBar(this._screenMenuBar);
        } else {
            if (this._fixupAdapter == null) {
                this._fixupAdapter = new FixupMenuBarWindowAdapter();
            }
            frame.setMenuBar(this._screenMenuBar);
            frame.addWindowListener(this._fixupAdapter);
        }
        return true;
    }

    MenuBar getScreenMenuBar() {
        if (this._screenMenuBar == null) {
            this._screenMenuBar = this.createMenuBar(this._menuBar);
        }
        return this._screenMenuBar;
    }

    MenuBar createMenuBar(JMenuBar m) {
        try {
            Class<?> c = Class.forName("com.apple.laf.ScreenMenuBar");
            return this.construct(c, m);
        }
        catch (Throwable c) {
            try {
                Class<?> c2 = Class.forName("apple.laf.ScreenMenuBar");
                return this.construct(c2, m);
            }
            catch (Throwable throwable) {
                return new MenuBar();
            }
        }
    }

    MenuBar construct(Class c, JMenuBar m) throws Exception {
        return (MenuBar)c.getConstructor(JMenuBar.class).newInstance(m);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (CommandBar.isScreenMenuBar((JMenuBar)c)) {
            Container ancestor = c.getTopLevelAncestor();
            if (ancestor instanceof Frame) {
                this.setScreenMenuBar((Frame)ancestor);
            }
            return new Dimension(0, 0);
        }
        return null;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicCommandBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        this._target = c;
        this._menuBar = (JMenuBar)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (this._screenMenuBar != null) {
            Frame frame;
            Container ancestor = c.getTopLevelAncestor();
            if (ancestor instanceof Frame && (frame = (Frame)ancestor).getMenuBar() == this._screenMenuBar) {
                frame.setMenuBar(null);
                frame.removeWindowListener(this._fixupAdapter);
            }
            this._screenMenuBar = null;
        }
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
    }

    protected void installDefaults() {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        this.updateBorder();
        LookAndFeel.installColorsAndFont(this._target, "CommandBar.background", "CommandBar.foreground", "CommandBar.font");
    }

    private void updateBorder() {
        if (!(this._target instanceof CommandBar)) {
            return;
        }
        CommandBar commandBar = (CommandBar)this._target;
        if (commandBar.getContext() == null) {
            return;
        }
        if (commandBar.isFloating()) {
            LookAndFeel.installBorder(commandBar, "CommandBar.borderFloating");
        } else if (commandBar.isStretch()) {
            LookAndFeel.installBorder(commandBar, "MenuBar.border");
        } else if (commandBar.isHoriDocked()) {
            LookAndFeel.installBorder(commandBar, "CommandBar.border");
        } else if (commandBar.isVertDocked()) {
            LookAndFeel.installBorder(commandBar, "CommandBar.borderVert");
        } else {
            LookAndFeel.installBorder(commandBar, "CommandBar.border");
        }
    }

    protected void uninstallDefaults() {
        this._painter = null;
    }

    @Override
    public Component getGripper() {
        return this._gripper;
    }

    @Override
    public Component getTitleBar() {
        return this._titleBar;
    }

    protected void installComponents() {
        if (CommandBar.isScreenMenuBar((JMenuBar)this._target)) {
            return;
        }
        this._gripper = new Gripper();
        this._gripper.setSize(9, this._target.getHeight());
        int orientation = this.getOrientation(this._target);
        this._gripper.setOrientation(orientation);
        this._target.add((Component)this._gripper, 0);
        this._titleBar = new CommandBarTitleBar(this.getTitle(this._target));
        this._titleBar.setSize(this._target.getWidth(), 14);
        this._target.add((Component)this._titleBar, 1);
        this._chevron = new Chevron();
        this._chevron.setOrientation(orientation);
        this._chevron.setOpaque(true);
        this._target.add((Component)this._chevron, 2);
    }

    private int getOrientation(Component commandBar) {
        int orientation = 0;
        if (commandBar instanceof CommandBar) {
            orientation = ((CommandBar)commandBar).getOrientation();
        } else if (commandBar instanceof JToolBar) {
            orientation = ((JToolBar)commandBar).getOrientation();
        } else if (commandBar instanceof JComponent) {
            orientation = JideSwingUtilities.getOrientationOf(commandBar);
        }
        return orientation;
    }

    private String getTitle(Component commandBar) {
        String title = "";
        if (commandBar instanceof CommandBar) {
            title = ((CommandBar)commandBar).getTitle();
        } else if (commandBar instanceof JComponent) {
            title = commandBar.getName();
        }
        return title;
    }

    protected void uninstallComponents() {
        if (this._chevron != null) {
            this._target.remove(this._chevron);
            this._chevron = null;
        }
        if (this._titleBar != null) {
            this._target.remove(this._titleBar);
            this._titleBar = null;
        }
        if (this._gripper != null) {
            this._target.remove(this._gripper);
            this._gripper = null;
        }
    }

    protected void installListeners() {
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this._target.addPropertyChangeListener(this.propertyListener);
        }
        this.containerListener = this.createContainerListener();
        if (this.containerListener != null) {
            this._target.addContainerListener(this.containerListener);
        }
        this.changeListener = this.createChangeListener();
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = this._target.getComponent(i);
            if (!(component instanceof JMenu)) continue;
            ((JMenu)component).getModel().addChangeListener(this.changeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.propertyListener != null) {
            this._target.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.containerListener != null) {
            this._target.removeContainerListener(this.containerListener);
            this.containerListener = null;
        }
        for (int i = 0; i < this._target.getComponentCount(); ++i) {
            Component component = this._target.getComponent(i);
            if (!(component instanceof JMenu)) continue;
            ((JMenu)component).getModel().removeChangeListener(this.changeListener);
        }
        this.changeListener = null;
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this._target, 1, km);
        ActionMap am = this.getActionMap();
        if (am != null) {
            SwingUtilities.replaceUIActionMap(this._target, am);
            if (this._target instanceof CommandMenuBar && SystemInfo.isWindows()) {
                InputMap inputMap = this.getInputMap(2);
                SwingUtilities.replaceUIInputMap(this._target, 2, inputMap);
                am.put("takeFocus", new TakeFocus());
            }
        }
    }

    static void repaintRootPane(Component c) {
        Component root = null;
        while (c != null) {
            if (c instanceof JRootPane) {
                root = (JRootPane)c;
            }
            c = c.getParent();
        }
        if (root != null) {
            root.repaint();
        } else {
            c.repaint();
        }
    }

    InputMap getInputMap(int condition) {
        Object[] bindings;
        if (condition == 1) {
            return (InputMap)UIDefaultsLookup.get("CommandBar.ancestorInputMap");
        }
        if (condition == 2 && (bindings = (Object[])UIDefaultsLookup.get("MenuBar.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this._target, bindings);
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIDefaultsLookup.get("CommandBar.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("CommandBar.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        return new ActionMapUIResource();
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this._target, null);
        SwingUtilities.replaceUIInputMap(this._target, 1, null);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int c = BasicCommandBarUI.this._target.getComponentCount();
                for (int i = 0; i < c; ++i) {
                    Component component = BasicCommandBarUI.this._target.getComponent(i);
                    if (component == null || !(component instanceof JMenu) || !((JMenu)component).isSelected()) continue;
                    ((CommandBar)BasicCommandBarUI.this._target).getSelectionModel().setSelectedIndex(i);
                    break;
                }
            }
        };
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    protected ContainerListener createContainerListener() {
        return new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (c instanceof JMenu) {
                    ((JMenu)c).getModel().addChangeListener(BasicCommandBarUI.this.changeListener);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (c instanceof JMenu) {
                    ((JMenu)c).getModel().removeChangeListener(BasicCommandBarUI.this.changeListener);
                }
            }
        };
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        boolean isPaintBackground;
        boolean isFloating;
        if (c instanceof CommandBar) {
            isFloating = ((CommandBar)c).isFloating();
            isPaintBackground = ((CommandBar)c).isPaintBackground();
        } else {
            isFloating = false;
            isPaintBackground = c.isOpaque();
        }
        if (isFloating) {
            try {
                this._painter.paintContentBackground(c, g, new Rectangle(0, 0, c.getWidth(), c.getHeight()), 0, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (isPaintBackground) {
            Rectangle rect = new Rectangle();
            if (isFloating && this._titleBar != null && this._titleBar.isVisible()) {
                g.setColor(this.getPainter().getColor("control"));
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                rect.x = 3;
                rect.width = c.getWidth() - 2 * rect.x;
                rect.y = 20;
                rect.height = c.getHeight() - 3 - rect.y;
            } else {
                rect.x = 0;
                rect.y = 0;
                rect.width = c.getWidth();
                rect.height = c.getHeight();
            }
            if (isFloating) {
                this.getPainter().paintFloatingCommandBarBackground(c, g, rect, JideSwingUtilities.getOrientationOf(c), 0);
            } else {
                this.getPainter().paintCommandBarBackground(c, g, rect, JideSwingUtilities.getOrientationOf(c), 0);
            }
        }
    }

    public ThemePainter getPainter() {
        if (this._painter == null) {
            this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        }
        return this._painter;
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("lookAndFeel")) {
                BasicCommandBarUI.this._target.updateUI();
            } else if (propertyName.equals("title")) {
                if (BasicCommandBarUI.this._titleBar != null) {
                    BasicCommandBarUI.this._titleBar.setTitle(BasicCommandBarUI.this.getTitle(BasicCommandBarUI.this._target));
                }
            } else if (propertyName.equals("floatable")) {
                BasicCommandBarUI.this._target.invalidate();
                BasicCommandBarUI.this._target.doLayout();
            } else if (propertyName.equals("rearrangable")) {
                BasicCommandBarUI.this._target.invalidate();
                BasicCommandBarUI.this._target.doLayout();
            } else if (propertyName.equals("hidable")) {
                if (BasicCommandBarUI.this.getTitleBar() != null) {
                    BasicCommandBarUI.this.getTitleBar().invalidate();
                    BasicCommandBarUI.this.getTitleBar().doLayout();
                }
            } else if (propertyName.equals("stretch")) {
                BasicCommandBarUI.this._target.invalidate();
                BasicCommandBarUI.this._target.doLayout();
            } else if (propertyName.equals("orientation")) {
                int orientation = (Integer)e.getNewValue();
                ((DockableBar)BasicCommandBarUI.this._target).adjustChildrenOrientation(orientation);
            } else if (propertyName.equals("paintBackground")) {
                BasicCommandBarUI.this._target.repaint();
            } else if (propertyName.equals("menuBar") || propertyName.equals("chevronAlwaysVisible")) {
                BasicCommandBarUI.this._target.invalidate();
                BasicCommandBarUI.this._target.doLayout();
            } else if (propertyName.equals("floating")) {
                if (e.getNewValue().equals(Boolean.TRUE)) {
                    BasicCommandBarUI.this.updateBorder();
                }
            } else if (propertyName.equals("horiDocked")) {
                if (e.getNewValue().equals(Boolean.TRUE)) {
                    BasicCommandBarUI.this.updateBorder();
                }
            } else if (propertyName.equals("vertDocked") && e.getNewValue().equals(Boolean.TRUE)) {
                BasicCommandBarUI.this.updateBorder();
            }
        }
    }

    private static class TakeFocus
    extends AbstractAction {
        private TakeFocus() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuBar menuBar = (JMenuBar)e.getSource();
            JMenu menu = menuBar.getMenu(0);
            if (menu != null) {
                MenuSelectionManager msm = MenuSelectionManager.defaultManager();
                MenuElement[] path = new MenuElement[]{menuBar, menu};
                msm.setSelectedPath(path);
                WLFUtil.setMnemonicHidden(false);
                BasicCommandBarUI.repaintRootPane(menuBar);
            }
        }
    }

    class FixupMenuBarWindowAdapter
    extends WindowAdapter {
        @Override
        public void windowActivated(WindowEvent e) {
            if (e.getWindow() instanceof JFrame) {
                JFrame frame = (JFrame)e.getWindow();
                JMenuBar jMenuBar = frame.getJMenuBar();
                MenuBar menuBar = frame.getMenuBar();
                if (jMenuBar == null) {
                    if (menuBar == BasicCommandBarUI.this._screenMenuBar) {
                        frame.setMenuBar(null);
                    }
                    frame.removeWindowListener(this);
                } else if (jMenuBar != BasicCommandBarUI.this._menuBar) {
                    frame.removeWindowListener(BasicCommandBarUI.this._fixupAdapter);
                    MenuBarUI ui = jMenuBar.getUI();
                    if (ui instanceof BasicCommandBarUI) {
                        ((BasicCommandBarUI)ui).setScreenMenuBar(frame);
                    }
                }
            }
        }

        FixupMenuBarWindowAdapter() {
        }
    }
}

