/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.aqua.AquaDockableFrameTitlePane;
import com.jidesoft.plaf.aqua.AquaJideUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

class AquaDFButtonIcon
implements Icon {
    static ImageIcon HIDE_BUTTON_ICONS = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/hide_buttons.gif");
    static Icon HIDE_ICON = IconsFactory.getIcon(null, HIDE_BUTTON_ICONS, 0, 0, 12, 13);
    static Icon HIDE_FOCUSED_ICON = IconsFactory.getIcon(null, HIDE_BUTTON_ICONS, 12, 0, 12, 13);
    static Icon HIDE_PRESSED_ICON = IconsFactory.getIcon(null, HIDE_BUTTON_ICONS, 24, 0, 12, 13);
    static ImageIcon TITLE_BUTTON_ICONS = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/title_buttons.gif");
    static final int SIZE = 12;
    static Icon FLOAT_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 0, 0, 12, 12);
    static Icon FLOAT_FOCUSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 12, 0, 12, 12);
    static Icon FLOAT_PRESSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 24, 0, 12, 12);
    static Icon DOCK_ICON = FLOAT_ICON;
    static Icon DOCK_FOCUSED_ICON = FLOAT_FOCUSED_ICON;
    static Icon DOCK_PRESSED_ICON = FLOAT_PRESSED_ICON;
    static Icon AUTOHIDE_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 0, 12, 12, 12);
    static Icon AUTOHIDE_FOCUSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 12, 12, 12, 12);
    static Icon AUTOHIDE_PRESSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 24, 12, 12, 12);
    static Icon STOP_AUTOHIDE_ICON = AUTOHIDE_ICON;
    static Icon STOP_AUTOHIDE_FOCUSED_ICON = AUTOHIDE_FOCUSED_ICON;
    static Icon STOP_AUTOHIDE_PRESSED_ICON = AUTOHIDE_PRESSED_ICON;
    static Icon MAXIMIZE_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 0, 24, 12, 12);
    static Icon MAXIMIZE_FOCUSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 12, 24, 12, 12);
    static Icon MAXIMIZE_PRESSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 24, 24, 12, 12);
    static Icon RESTORE_ICON = MAXIMIZE_ICON;
    static Icon RESTORE_FOCUSED_ICON = MAXIMIZE_FOCUSED_ICON;
    static Icon RESTORE_PRESSED_ICON = MAXIMIZE_PRESSED_ICON;
    static Icon DISABLED_ICON = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/disabled.gif");
    static Icon EMPTY_ICON = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/empty.gif");
    static Icon GRAPHITE_ICON = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/graphite.gif");
    private JButton _button;
    private DockableFrame _frame;
    private AquaDockableFrameTitlePane _titlePane;
    private int _type;

    public AquaDFButtonIcon(DockableFrame frame, AquaDockableFrameTitlePane titlePane, JButton button, int buttonKind) {
        this._type = buttonKind;
        this._frame = frame;
        this._button = button;
        this._titlePane = titlePane;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int type) {
        this._type = type;
    }

    @Override
    public void paintIcon(Component component, Graphics g, int x, int y) {
        boolean rollover = this._titlePane.anyRollovers();
        ButtonModel model = this._button.getModel();
        boolean pressed = model.isPressed() && model.isArmed();
        Graphics2D g2d = (Graphics2D)g.create();
        Icon icon = null;
        boolean usingMacStandardIcons = UIDefaultsLookup.getBoolean("DockableFrame.usingMacStandardIcons");
        if (AquaJideUtils.isGraphite() && (pressed || rollover) && this.getType() != 0) {
            icon = GRAPHITE_ICON;
        } else {
            switch (this.getType()) {
                case 0: {
                    if (pressed) {
                        icon = usingMacStandardIcons ? FLOAT_PRESSED_ICON : HIDE_PRESSED_ICON;
                        break;
                    }
                    if (rollover) {
                        icon = usingMacStandardIcons ? FLOAT_FOCUSED_ICON : HIDE_FOCUSED_ICON;
                        break;
                    }
                    icon = usingMacStandardIcons ? FLOAT_ICON : HIDE_ICON;
                    break;
                }
                case 1: {
                    if (pressed) {
                        icon = AUTOHIDE_PRESSED_ICON;
                        break;
                    }
                    if (rollover) {
                        icon = AUTOHIDE_FOCUSED_ICON;
                        break;
                    }
                    icon = AUTOHIDE_ICON;
                    break;
                }
                case 2: {
                    if (pressed) {
                        icon = STOP_AUTOHIDE_PRESSED_ICON;
                        break;
                    }
                    if (rollover) {
                        icon = STOP_AUTOHIDE_FOCUSED_ICON;
                        break;
                    }
                    icon = STOP_AUTOHIDE_ICON;
                    break;
                }
                case 3: {
                    if (pressed) {
                        icon = FLOAT_PRESSED_ICON;
                        break;
                    }
                    if (rollover) {
                        icon = FLOAT_FOCUSED_ICON;
                        break;
                    }
                    icon = FLOAT_ICON;
                    break;
                }
                case 4: {
                    if (pressed) {
                        icon = DOCK_PRESSED_ICON;
                        break;
                    }
                    if (rollover) {
                        icon = DOCK_FOCUSED_ICON;
                        break;
                    }
                    icon = DOCK_ICON;
                    break;
                }
                case 5: {
                    if (pressed) {
                        icon = MAXIMIZE_PRESSED_ICON;
                        break;
                    }
                    if (rollover) {
                        icon = MAXIMIZE_FOCUSED_ICON;
                        break;
                    }
                    icon = MAXIMIZE_ICON;
                    break;
                }
                case 6: {
                    icon = pressed ? RESTORE_PRESSED_ICON : (rollover ? RESTORE_FOCUSED_ICON : RESTORE_ICON);
                }
            }
        }
        if (icon != null) {
            icon.paintIcon(component, g2d, x, y);
        }
        g2d.dispose();
    }

    @Override
    public int getIconWidth() {
        return 11;
    }

    @Override
    public int getIconHeight() {
        return 11;
    }
}

