/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.Dockable;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockedFrameContainer;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.docking.Workspace;
import com.jidesoft.swing.SidePaneGroup;
import com.jidesoft.swing.SidePaneItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

class PreviousState
implements Serializable {
    private static final long serialVersionUID = 1372217730835756351L;
    int mode;
    int dockID;
    int rootID;
    Rectangle rcBounds;
    int side;
    int index;
    int fcID;
    ArrayList<Integer> fcChildren;
    ArrayList<ParentState> parentStates;

    PreviousState() {
    }

    public static PreviousState createPreviousState(DockableFrame f) {
        PreviousState state = new PreviousState();
        state.mode = f.getContext().getCurrentMode();
        state.dockID = f.getDockID();
        if (state.mode == 2 || state.mode == 3) {
            state.side = f.getContext().getCurrentDockSide();
            state.index = state.side == 4 || state.side == 8 || state.side == 1 || state.side == 2 ? (f.getDockingManager() == null || f.getDockingManager().getAutoHideContainer(state.side) == null ? 0 : f.getDockingManager().getAutoHideContainer(state.side).getGroupIndex(f)) : 0;
            if (f.getDockingManager() != null && f.getDockingManager().getAutoHideContainer(state.side) != null && f.getDockingManager().getAutoHideContainer(state.side).getGroups() != null && f.getDockingManager().getAutoHideContainer(state.side).getGroups().size() > state.index && state.index >= 0) {
                List<SidePaneGroup> groups = f.getDockingManager().getAutoHideContainer(state.side).getGroups();
                ParentState parentState = new ParentState();
                parentState.ccChildren = new ArrayList();
                SidePaneGroup group = groups.get(state.index);
                for (SidePaneItem item : group) {
                    parentState.ccChildren.add(((DockableFrame)item.getComponent()).getDockID());
                }
                state.parentStates = new ArrayList();
                state.parentStates.add(parentState);
            }
        } else {
            Container rootContainer;
            Container container = f.getParent();
            if (container instanceof FrameContainer) {
                state.fcID = ((FrameContainer)container).getDockID();
                state.fcChildren = DockingUtils.getAllChildrenIDOf((FrameContainer)container);
                container = container.getParent();
            }
            state.parentStates = new ArrayList();
            int myID = state.fcID;
            while (container instanceof ContainerContainer) {
                ContainerContainer cContainer = (ContainerContainer)container;
                ParentState pState = new ParentState();
                pState.ccID = cContainer.getDockID();
                pState.myID = myID;
                pState.orientation = cContainer.getOrientation();
                pState.ccChildren = DockingUtils.getAllChildrenIDOf(cContainer);
                pState.proportions = cContainer.getProportions();
                state.parentStates.add(pState);
                if (pState.ccChildren.contains(new Integer(-1))) break;
                myID = pState.ccID;
                if (!((container = container.getParent()) instanceof FloatingContainer) && !(container instanceof DockedFrameContainer)) continue;
                break;
            }
            if (container instanceof Workspace) {
                ParentState pState = new ParentState();
                pState.ccID = 3;
                pState.myID = myID;
                state.parentStates.add(pState);
            }
            if ((rootContainer = DockingUtils.getRootContainer(f)) != null) {
                state.rcBounds = rootContainer.getBounds();
                state.side = f.getContext().getCurrentDockSide();
                state.rootID = 2;
            }
        }
        return state;
    }

    public static void disposePreviousState(PreviousState state) {
        if (state == null) {
            return;
        }
        state.rcBounds = null;
        if (state.fcChildren != null) {
            state.fcChildren.clear();
        }
        if (state.parentStates != null) {
            for (ParentState parentState : state.parentStates) {
                PreviousState.disposeParentState(parentState);
            }
            if (state.parentStates != null) {
                state.parentStates.clear();
            }
        }
        state.parentStates = null;
    }

    private static void disposeParentState(ParentState state) {
        if (state == null || state.ccChildren == null) {
            return;
        }
        state.ccChildren.clear();
    }

    public static Component findComponentByDockID(DockingManager dockingManager, Container container, int id) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component childComp;
            Component comp = container.getComponent(i);
            if (comp instanceof Dockable && ((Dockable)((Object)comp)).getDockID() == id && ((Dockable)((Object)comp)).getDockingManager() == dockingManager) {
                return comp;
            }
            if (comp instanceof Workspace && id == 3 && ((Workspace)comp).getDockingManager() == dockingManager) {
                return comp;
            }
            if (!(comp instanceof Container) || (childComp = PreviousState.findComponentByDockID(dockingManager, (Container)comp, id)) == null) continue;
            return childComp;
        }
        return null;
    }

    public static Component findDockedComponentByInitState(DockingManager dockingManager, Container container, int side, int index) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component childComp;
            DockableFrame dockableFrame;
            Component comp = container.getComponent(i);
            if (comp instanceof DockableFrame && dockingManager == (dockableFrame = (DockableFrame)comp).getDockingManager() && dockableFrame.getContext().getInitIndex() == index && dockableFrame.getContext().getInitSide() == side && dockableFrame.getContext().getCurrentDockSide() == side) {
                return comp;
            }
            if (!(comp instanceof Container) || (childComp = PreviousState.findDockedComponentByInitState(dockingManager, (Container)comp, side, index)) == null) continue;
            return childComp;
        }
        return null;
    }

    static class ParentState
    implements Serializable {
        private static final long serialVersionUID = 8771757301606568363L;
        int ccID;
        int myID;
        int orientation;
        ArrayList<Integer> ccChildren;
        double[] proportions;

        ParentState() {
        }
    }
}

