/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.ContainerContainer;
import com.jidesoft.docking.DockID;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.ResizableFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

public class FrameFloatingContainer
extends ResizableFrame
implements FloatingContainer {
    private final DockingManager _dockingManager;
    private final FloatingContainer.FloatingContainerManager _floatingContainerManager;
    private int _dockID = 0;

    FrameFloatingContainer() throws HeadlessException {
        this((DockingManager)null, (FloatingContainer.FloatingContainerManager)null);
    }

    public FrameFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager) throws HeadlessException {
        this(dockingManager, floatingContainerManager, "");
    }

    public FrameFloatingContainer(DockingManager dockingManager, FloatingContainer.FloatingContainerManager floatingContainerManager, String title) throws HeadlessException {
        super(title);
        this._dockingManager = dockingManager;
        this._floatingContainerManager = floatingContainerManager;
        this.setName("Dialog");
        this.setFocusableWindowState(true);
        this.setFocusCycleRoot(true);
        this.setRoutingKeyStrokes(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.initListeners();
        this.resetDockID();
    }

    protected void initListeners() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                super.windowActivated(e);
                if (!(e.getOppositeWindow() instanceof FloatingContainer) && FrameFloatingContainer.this._floatingContainerManager != null) {
                    FrameFloatingContainer.this._floatingContainerManager.floatingFrameActivated(e);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                super.windowDeactivated(e);
                if (FrameFloatingContainer.this._floatingContainerManager != null) {
                    FrameFloatingContainer.this._floatingContainerManager.floatingFrameDeactivated(e);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                DockingUtils.closeFloatingContainer(FrameFloatingContainer.this.getDockingManager(), FrameFloatingContainer.this);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                DockingUtils.closeFloatingContainer(FrameFloatingContainer.this.getDockingManager(), FrameFloatingContainer.this);
            }
        });
    }

    @Override
    public boolean hasTitleBar() {
        return !this.isUndecorated() || UIManager.getLookAndFeel().getSupportsWindowDecorations() && this.getRootPane().getWindowDecorationStyle() != 0;
    }

    @Override
    public Rectangle getInitialBounds(Rectangle savedBounds) {
        return savedBounds;
    }

    @Override
    public void updateUndecorated() {
        boolean changed = false;
        boolean show = this.isVisible();
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            if (!JFrame.isDefaultLookAndFeelDecorated() && this.isUndecorated()) {
                changed = true;
                this.setVisible(false);
                this.setUndecorated(false);
                this.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder()));
            }
            if (this.isUndecorated()) {
                this.getRootPane().setWindowDecorationStyle(1);
            } else {
                this.getRootPane().setWindowDecorationStyle(0);
            }
        } else {
            if (JFrame.isDefaultLookAndFeelDecorated() && this.isUndecorated()) {
                changed = true;
                this.setVisible(false);
                this.setUndecorated(true);
                this.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
            }
            this.getRootPane().setWindowDecorationStyle(0);
        }
        if (changed) {
            this.updateBorders();
        }
        if (this.getDockingManager().getMainContainer().isShowing() && (show || !this.getDockingManager().isUseDecoratedFloatingContainer())) {
            this.setVisible(true);
        }
        this.updateTitle();
    }

    @Override
    public void updateBorders() {
        if (DockingUtils.shouldUseDecoratedFloatingContainer(this.getDockingManager(), this.getContentPane())) {
            Border border = UIDefaultsLookup.getBorder("JideTabbedPane.border");
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.border");
            DockingUtils.setDockableFrameBorder(this.getContentPane(), border);
            this.getResizable().setResizableCorners(0);
            if (this._dockingManager.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        } else {
            Border border = new BorderUIResource(BorderFactory.createEmptyBorder());
            DockingUtils.setFrameContainerBorder(this.getContentPane(), border);
            border = UIDefaultsLookup.getBorder("DockableFrame.floatingBorder");
            DockingUtils.setDockableFrameBorder(this.getContentPane(), border);
            this.getResizable().setResizableCorners(255);
            if (this._dockingManager.isUseDecoratedFloatingContainer()) {
                ((JComponent)this.getContentPane()).setBorder(border);
            }
        }
    }

    @Override
    public Component getRoutingComponent() {
        return this._dockingManager.getMainContainer();
    }

    @Override
    public DockingManager getDockingManager() {
        return this._dockingManager;
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public void hideItselfIfEmpty() {
        List<DockableFrame> frames = DockingUtils.getAllDockableFrameOf(this.getContentPane());
        if (frames == null || frames.size() == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void updateTitle() {
        Component[] components = this.getContentPane().getComponents();
        Component comp = null;
        for (Component component : components) {
            if (!(component instanceof ContainerContainer) && !(component instanceof FrameContainer)) continue;
            if (comp == null) {
                comp = component;
                continue;
            }
            comp = null;
            break;
        }
        Object title = null;
        int tabCount = 0;
        if (comp != null) {
            if (comp instanceof ContainerContainer) {
                Component o;
                List<Component> allChildrenOf = DockingUtils.getAllChildrenOf((ContainerContainer)comp);
                tabCount = allChildrenOf.size();
                if (tabCount == 1) {
                    o = allChildrenOf.get(0);
                    if (o instanceof DockableFrame) {
                        title = ((DockableFrame)o).getTitle();
                    }
                } else if (tabCount > 1 && (o = allChildrenOf.get(0)) instanceof DockableFrame) {
                    title = ((DockableFrame)o).getTitle();
                }
            } else {
                tabCount = ((FrameContainer)comp).getTabCount();
                if (tabCount == 1) {
                    title = ((FrameContainer)comp).getSelectedFrame() == null ? "" : ((FrameContainer)comp).getSelectedFrame().getTitle();
                } else if (tabCount > 1) {
                    title = ((FrameContainer)comp).getFrame(0).getTitle();
                }
            }
        }
        if (title == null) {
            title = "";
        } else {
            String fName = new File((String)title).getName();
            if (fName.equals(title)) {
                title = "[#] " + (String)title;
                if (tabCount > 1) {
                    title = (String)title + " (" + tabCount + ")";
                }
            } else {
                title = "[#] " + fName + " [" + (String)title + "]";
                if (tabCount > 1) {
                    title = (String)title + " (" + tabCount + ")";
                }
            }
        }
        if (!((String)title).equals(this.getTitle())) {
            this.setTitle((String)title);
        }
    }

    @Override
    public int getDockID() {
        return this._dockID;
    }

    @Override
    public void setDockID(int id) {
        this._dockID = id;
    }

    @Override
    public void resetDockID() {
        this._dockID = -1;
        if (this._dockingManager != null) {
            this._dockID = DockID.getInstance(this._dockingManager).getID(this.getDockID());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Component getMostRecentFocusOwner() {
        Component component;
        if (this.getContentPane().getComponentCount() < 1) return super.getMostRecentFocusOwner();
        Component comp = this.getContentPane().getComponent(0);
        List<Component> dockableFrameList = null;
        if (comp instanceof ContainerContainer) {
            dockableFrameList = DockingUtils.getAllChildrenOf((ContainerContainer)comp);
        } else if (comp instanceof FrameContainer) {
            dockableFrameList = DockingUtils.getAllChildrenOf((FrameContainer)comp);
        }
        if (dockableFrameList == null || dockableFrameList.size() <= 0 || !((component = dockableFrameList.get(0)) instanceof DockableFrame)) return super.getMostRecentFocusOwner();
        DockableFrame dockableFrame = (DockableFrame)component;
        Container parent = dockableFrame.getParent();
        if (parent != null && parent instanceof FrameContainer) {
            FrameContainer frameContainer = (FrameContainer)parent;
            DockableFrame selectedFrame = frameContainer.getSelectedFrame();
            if (selectedFrame == null) return frameContainer;
            Component lastFocusedComp = selectedFrame.getFocusedComponent();
            if (lastFocusedComp == null || lastFocusedComp == selectedFrame) {
                lastFocusedComp = selectedFrame.getDefaultFocusComponent();
            }
            if (lastFocusedComp == selectedFrame) return super.getMostRecentFocusOwner();
            return lastFocusedComp;
        }
        Component lastFocusedComp = dockableFrame.getFocusedComponent();
        if (lastFocusedComp == dockableFrame) {
            lastFocusedComp = dockableFrame.getDefaultFocusComponent();
        }
        if (lastFocusedComp == dockableFrame) return super.getMostRecentFocusOwner();
        return lastFocusedComp;
    }

    @Override
    public void setResizable(boolean resizable) {
        super.setResizable(resizable);
        this.getResizable().setResizableCorners(resizable ? 255 : 0);
    }

    @Override
    protected void beginResizing() {
        this.getDockingManager().addUndo(this.getDockingManager().getResourceString("Undo.resizing"));
        super.beginResizing();
    }
}

