/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.Dockable;
import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.DockingUtils;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.docking.FrameContainer;
import com.jidesoft.plaf.JideTabbedPaneUI;
import com.jidesoft.swing.Gripper;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.MouseInputListener;

class DockableFrameMouseInputAdapter
extends MouseInputAdapter
implements SwingConstants {
    private int _eventMouseScreenX;
    private int _eventMouseScreenY;
    private int _eventMouseRelativeX;
    private int _eventMouseRelativeY;
    private static Rectangle _startingBounds;
    private int _resizeDir;
    protected static final int RESIZE_NONE = 0;
    private boolean _discardRelease = false;
    private boolean _glassPaneVisibility;
    private int resizeCornerSize = 16;
    private DockableFrame _frame;
    private FrameContainer _tabbedPane;
    private boolean _needClearTabbedPane;
    private JComponent _component;
    private Object _mouseOnComponent;
    private DockingManager _dockingManager;
    private Rectangle[] _savedTabRects;
    private boolean _dragged = false;
    private MouseEvent dndArmedEvent = null;

    public DockableFrameMouseInputAdapter(DockableFrame frame) {
        this._frame = frame;
        this._component = this._frame;
    }

    public DockableFrameMouseInputAdapter(FrameContainer tabbedPane) {
        this._tabbedPane = tabbedPane;
        this._component = this._tabbedPane;
    }

    private void initDockingManager(MouseEvent e) {
        if (this._tabbedPane != null && this._tabbedPane.getTabCount() > 0) {
            Point point = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this._tabbedPane);
            int index = this._tabbedPane.getTabAtLocation(point.x, point.y);
            if (index != -1) {
                this._frame = (DockableFrame)this._tabbedPane.getComponentAt(index);
                this._dockingManager = this._frame.getDockingManager();
            } else {
                this._dockingManager = this._tabbedPane.getFrame(0).getDockingManager();
                this._frame = this._tabbedPane.getSelectedFrame();
            }
        } else if (this._component instanceof Dockable) {
            this._dockingManager = ((Dockable)((Object)this._component)).getDockingManager();
        } else {
            throw new IllegalStateException("Internal Error: Non-dockable is passed to BorderListener.");
        }
    }

    private int getDragThreshold() {
        int th = 20;
        try {
            th = Integer.parseInt(System.getProperty("jide.tabs.dnd.drag.threshold"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return th;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mousePressed(MouseEvent e) {
        block61: {
            block60: {
                Insets i;
                block62: {
                    int index;
                    Point point;
                    if (SwingUtilities.isMiddleMouseButton(e)) {
                        return;
                    }
                    this.initDockingManager(e);
                    if (this._dockingManager != null) {
                        this._dockingManager.setActiveMouseInputListener(this);
                    }
                    if (this.isFrameDisabled()) {
                        return;
                    }
                    if (((Dockable)((Object)this._component)).getDockingManager() == null) {
                        JideSwingUtilities.retargetMouseEvent(e.getID(), e, this._frame);
                        return;
                    }
                    this.setDrag(false);
                    this.dndArmedEvent = null;
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        this.dndArmedEvent = e;
                    }
                    if (this._mouseOnComponent != null && e.getSource() != this._mouseOnComponent) {
                        return;
                    }
                    this._mouseOnComponent = e.getSource();
                    if (e.isPopupTrigger() && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
                        this.showContextMenu(e);
                    }
                    if (this._component != null) {
                        Point point2 = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this._component);
                        this._eventMouseRelativeX = point2.x;
                        this._eventMouseRelativeY = point2.y;
                    }
                    Object clientProperty = this._component.getClientProperty("HeavyweightWrapper");
                    _startingBounds = this._frame != null && this._frame.isAutohideShowing() && clientProperty instanceof HeavyweightWrapper ? ((HeavyweightWrapper)clientProperty).getBounds() : this._component.getBounds();
                    double relativeX = (double)this._eventMouseRelativeX / (double)DockableFrameMouseInputAdapter._startingBounds.width;
                    double relativeY = (double)this._eventMouseRelativeY / (double)(DockableFrameMouseInputAdapter._startingBounds.height + (this._tabbedPane != null && this._tabbedPane.isTabShown() ? 22 : 0));
                    this._resizeDir = 0;
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), (Component)((Object)((Dockable)((Object)this._component)).getDockingManager().getRootPaneContainer()));
                    this._eventMouseScreenX = p.x;
                    this._eventMouseScreenY = p.y;
                    Component draggingTarget = null;
                    if (this._frame != null && (draggingTarget = this._frame.getDraggingTarget(e)) == this._frame && this._frame.getParent() instanceof FrameContainer && this._tabbedPane == null) {
                        this._tabbedPane = (FrameContainer)this._frame.getParent();
                        this._needClearTabbedPane = true;
                    }
                    if (this._frame != null && this.isDraggingTarget(e) && draggingTarget != this._frame) {
                        if (!this._frame.isDockable() && this._frame.isDocked()) {
                            this._frame.getDockingManager().activateFrame(this._frame.getKey());
                            return;
                        }
                        if (!this._frame.isAutohide() && !this._frame.isAutohideShowing()) {
                            this._dockingManager.beginDraggingFrame(this._component, this._eventMouseScreenX, this._eventMouseScreenY, relativeX, relativeY, false);
                            return;
                        }
                        this._frame.getDockingManager().activateFrame(this._frame.getKey());
                        return;
                    }
                    if (this._tabbedPane != null && this.isTabPanelEvent(e)) {
                        point = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this._tabbedPane);
                        index = this._tabbedPane.getTabAtLocation(point.x, point.y);
                        if (index == -1) {
                            this._dockingManager.beginDraggingFrame((DockableFrame)this._tabbedPane.getSelectedComponent(), this._eventMouseScreenX, this._eventMouseScreenY, relativeX, relativeY, false);
                            this._savedTabRects = new Rectangle[this._tabbedPane.getTabCount()];
                            int i2 = 0;
                            while (true) {
                                if (i2 >= this._savedTabRects.length) {
                                    return;
                                }
                                this._savedTabRects[i2] = SwingUtilities.convertRectangle(this._tabbedPane, this._tabbedPane.getUI().getTabBounds(this._tabbedPane, i2), (Component)e.getSource());
                                ++i2;
                            }
                        }
                    }
                    if (this._tabbedPane != null && (this.isTabPanelEvent(e) || draggingTarget == this._frame)) {
                        FrameContainer fc;
                        point = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this._tabbedPane);
                        index = this._tabbedPane.getTabAtLocation(point.x, point.y);
                        DockableFrame frame = (DockableFrame)this._tabbedPane.getSelectedComponent();
                        if (index != -1) {
                            frame = this._tabbedPane.getFrame(index);
                        }
                        if (frame != null && frame.getParent() != null && frame.getParent() instanceof FrameContainer && (fc = (FrameContainer)frame.getParent()).isTabEditing()) {
                            return;
                        }
                        if (this._dockingManager != null) {
                            this._dockingManager.beginDraggingFrame(frame, this._eventMouseScreenX, this._eventMouseScreenY, relativeX, relativeY, true);
                            this._savedTabRects = new Rectangle[this._tabbedPane.getTabCount()];
                            for (int i3 = 0; i3 < this._savedTabRects.length; ++i3) {
                                this._savedTabRects[i3] = SwingUtilities.convertRectangle(this._tabbedPane, this._tabbedPane.getUI().getTabBounds(this._tabbedPane, i3), (Component)e.getSource());
                            }
                        }
                        return;
                    }
                    if (!(this._component.getTopLevelAncestor() instanceof FloatingContainer) && this._component instanceof DockableFrame && ((DockableFrame)this._component).isDocked()) {
                        return;
                    }
                    if (!(!(this._component.getTopLevelAncestor() instanceof FloatingContainer) || this._component instanceof DockableFrame && ((DockableFrame)this._component).isFloated() || DockingUtils.getFrameContainerCount(this._dockingManager, ((FloatingContainer)((Object)this._component.getTopLevelAncestor())).getContentPane()) <= 1)) {
                        return;
                    }
                    if (this._component instanceof FrameContainer && !(this._component.getTopLevelAncestor() instanceof FloatingContainer)) {
                        return;
                    }
                    if (!this._dockingManager.isResizable()) {
                        return;
                    }
                    if (this._frame != null && !this._frame.isSlidingAutohide()) {
                        return;
                    }
                    if (e.getSource() != this._component) break block61;
                    i = this._component.getInsets();
                    if (!(this._component instanceof FrameContainer)) break block62;
                    if (i.right > 0 && e.getX() >= this._component.getWidth() - i.right) {
                        this._resizeDir = i.bottom > 0 && e.getY() > this._component.getHeight() - this.resizeCornerSize - i.bottom ? 4 : 3;
                        break block60;
                    } else if (i.bottom > 0 && e.getY() >= this._component.getHeight() - i.bottom) {
                        this._resizeDir = i.right > 0 && e.getX() > this._component.getWidth() - this.resizeCornerSize - i.right ? 4 : 5;
                        break block60;
                    } else {
                        this._discardRelease = true;
                        return;
                    }
                }
                if (e.getX() <= i.left) {
                    this._resizeDir = i.top > 0 && e.getY() < this.resizeCornerSize + i.top ? 8 : (i.bottom > 0 && e.getY() > this._component.getHeight() - this.resizeCornerSize - i.bottom ? 6 : 7);
                } else if (i.right > 0 && e.getX() >= this._component.getWidth() - i.right) {
                    this._resizeDir = i.top > 0 && e.getY() < this.resizeCornerSize + i.top ? 2 : (i.bottom > 0 && e.getY() > this._component.getHeight() - this.resizeCornerSize - i.bottom ? 4 : 3);
                } else if (i.top > 0 && e.getY() <= i.top) {
                    this._resizeDir = i.left > 0 && e.getX() < this.resizeCornerSize + i.left ? 8 : (i.right > 0 && e.getX() > this._component.getWidth() - this.resizeCornerSize - i.right ? 2 : 1);
                } else if (i.bottom > 0 && e.getY() >= this._component.getHeight() - i.bottom) {
                    this._resizeDir = i.left > 0 && e.getX() < this.resizeCornerSize + i.left ? 6 : (i.right > 0 && e.getX() > this._component.getWidth() - this.resizeCornerSize - i.right ? 4 : 5);
                } else {
                    this._discardRelease = true;
                    return;
                }
            }
            Cursor s = Cursor.getDefaultCursor();
            switch (this._resizeDir) {
                case 5: {
                    if (this._frame != null && this._frame.isAutohideShowing()) {
                        s = JideCursors.getPredefinedCursor(21);
                        break;
                    }
                    s = Cursor.getPredefinedCursor(9);
                    break;
                }
                case 1: {
                    if (this._frame != null && this._frame.isAutohideShowing()) {
                        s = JideCursors.getPredefinedCursor(21);
                        break;
                    }
                    s = Cursor.getPredefinedCursor(8);
                    break;
                }
                case 7: {
                    if (this._frame != null && this._frame.isAutohideShowing()) {
                        s = JideCursors.getPredefinedCursor(20);
                        break;
                    }
                    s = Cursor.getPredefinedCursor(10);
                    break;
                }
                case 3: {
                    if (this._frame != null && this._frame.isAutohideShowing()) {
                        s = JideCursors.getPredefinedCursor(20);
                        break;
                    }
                    s = Cursor.getPredefinedCursor(11);
                    break;
                }
                case 4: {
                    s = Cursor.getPredefinedCursor(5);
                    break;
                }
                case 6: {
                    s = Cursor.getPredefinedCursor(4);
                    break;
                }
                case 8: {
                    s = Cursor.getPredefinedCursor(6);
                    break;
                }
                case 2: {
                    s = Cursor.getPredefinedCursor(7);
                    break;
                }
            }
            Container c = this._component.getTopLevelAncestor();
            if (this._dockingManager.isUseGlassPaneEnabled()) {
                if (c instanceof JFrame) {
                    this._glassPaneVisibility = ((JFrame)c).getGlassPane().isVisible();
                    ((JFrame)c).getGlassPane().setVisible(true);
                    ((JFrame)c).getGlassPane().setCursor(s);
                } else if (c instanceof JApplet) {
                    this._glassPaneVisibility = ((JApplet)c).getGlassPane().isVisible();
                    ((JApplet)c).getGlassPane().setVisible(true);
                    ((JApplet)c).getGlassPane().setCursor(s);
                } else if (c instanceof JWindow) {
                    this._glassPaneVisibility = ((JWindow)c).getGlassPane().isVisible();
                    ((JWindow)c).getGlassPane().setVisible(true);
                    ((JWindow)c).getGlassPane().setCursor(s);
                } else if (c instanceof JDialog) {
                    this._glassPaneVisibility = ((JDialog)c).getGlassPane().isVisible();
                    ((JDialog)c).getGlassPane().setVisible(true);
                    ((JDialog)c).getGlassPane().setCursor(s);
                }
            }
            this._dockingManager.beginResizingFrame(this._component, this._resizeDir);
        }
    }

    private boolean isFrameDisabled() {
        int index;
        return this._frame != null && this._component instanceof FrameContainer && (index = ((FrameContainer)this._component).indexOfComponent(this._frame)) >= 0 && index < ((FrameContainer)this._component).getTabCount() && !((FrameContainer)this._component).isEnabledAt(index);
    }

    private boolean isTabPanelEvent(MouseEvent e) {
        if (e.getSource() == this._tabbedPane) {
            Point point = e.getPoint();
            Component tabPanel = ((JideTabbedPaneUI)this._tabbedPane.getUI()).getTabPanel();
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), point, tabPanel);
            return tabPanel.contains(p);
        }
        if (e.getSource() == this._frame.getUI().getTitlePane()) {
            Point point = e.getPoint();
            Component titlePane = this._frame.getUI().getTitlePane();
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), point, titlePane);
            return titlePane.contains(p);
        }
        return false;
    }

    private void setDrag(boolean drag) {
        if (this._dragged != drag) {
            this._dragged = drag;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int newH;
        int newW;
        int newY;
        if (SwingUtilities.isMiddleMouseButton(e)) {
            return;
        }
        this.initDockingManager(e);
        if (this.isFrameDisabled()) {
            return;
        }
        if (this._dockingManager == null) {
            JideSwingUtilities.retargetMouseEvent(e.getID(), e, this._frame);
            return;
        }
        if (this._mouseOnComponent != null && e.getSource() != this._mouseOnComponent) {
            return;
        }
        this._mouseOnComponent = e.getSource();
        this.setDrag(true);
        if (this.dndArmedEvent != null) {
            int dx = Math.abs(e.getX() - this.dndArmedEvent.getX());
            int dy = Math.abs(e.getY() - this.dndArmedEvent.getY());
            if (dx < this.getDragThreshold() && dy < this.getDragThreshold()) {
                return;
            }
        }
        if ((this._frame == null || this._frame.isDockable()) && !(e.getSource() instanceof Gripper) && !(e.getSource() instanceof DockableFrame) && ((Component)e.getSource()).contains(e.getPoint())) {
            if (this._tabbedPane != null && this.isTabPanelEvent(e) && this._tabbedPane.getTabCount() > 1) {
                if (!this._dockingManager.isTabReorderAllowed()) {
                    this._discardRelease = true;
                    return;
                }
                this._dockingManager.pauseDragFrame();
                int tabIndex = -1;
                if (this._savedTabRects != null) {
                    DockableFrame draggingFrame;
                    for (int i = 0; i < this._savedTabRects.length; ++i) {
                        if (!this._savedTabRects[i].contains(e.getPoint())) continue;
                        tabIndex = i;
                        break;
                    }
                    if (tabIndex >= 0 && tabIndex < this._tabbedPane.getTabCount() && tabIndex != this._tabbedPane.getSelectedIndex() && (draggingFrame = this._tabbedPane.getSelectedFrame()) != null && this._dockingManager.isDropAllowed(draggingFrame, this._tabbedPane.getComponentAt(tabIndex), draggingFrame.getContext().getCurrentDockSide())) {
                        this._dockingManager.addUndo(this._dockingManager.getResourceString("Undo.moving"));
                        this._tabbedPane.moveSelectedTabTo(tabIndex);
                    }
                }
                return;
            }
            if (this._frame != null && this._frame.isDocked() && this.isTabPanelEvent(e)) {
                this._dockingManager.pauseDragFrame();
                return;
            }
        }
        if (_startingBounds == null) {
            return;
        }
        Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), (Component)((Object)((Dockable)((Object)this._component)).getDockingManager().getRootPaneContainer()));
        int deltaX = this._eventMouseScreenX - p.x;
        int deltaY = this._eventMouseScreenY - p.y;
        if (this._frame != null && this.isDraggingTarget(e)) {
            if (this._frame != null && !this._frame.isDockable() && this._frame.isDocked()) {
                return;
            }
            if (this._frame.isMaximized() || this._frame.isAutohide() || this._frame.isAutohideShowing() || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this._dockingManager.dragFrame(this._frame, p.x, p.y, PortingUtils.getMouseModifiers(e));
            return;
        }
        if (this._tabbedPane != null) {
            DockableFrame frame = (DockableFrame)this._tabbedPane.getSelectedComponent();
            if (frame == null) {
                return;
            }
            if (!frame.isDockable() && frame.isDocked()) {
                return;
            }
            if (frame.isMaximized() || frame.isAutohide() || frame.isAutohideShowing() || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this._dockingManager.dragFrame(frame, p.x, p.y, PortingUtils.getMouseModifiers(e));
            return;
        }
        if (!this._dockingManager.isResizable()) {
            return;
        }
        if (this._frame != null && !this._frame.isSlidingAutohide()) {
            return;
        }
        Dimension min = this._component.getMinimumSize();
        Dimension max = this._component.getMaximumSize();
        int newX = this._component.getParent() instanceof HeavyweightWrapper ? this._component.getParent().getX() : this._component.getX();
        int n = newY = this._component.getParent() instanceof HeavyweightWrapper ? this._component.getParent().getY() : this._component.getY();
        Rectangle parentBounds = this._component instanceof FrameContainer || this._component.getParent() == null ? new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE) : (this._component.getParent() instanceof HeavyweightWrapper ? this._component.getParent().getParent().getBounds() : this._component.getParent().getBounds());
        switch (this._resizeDir) {
            case 0: {
                return;
            }
            case 1: {
                if (DockableFrameMouseInputAdapter._startingBounds.height + deltaY < min.height) {
                    deltaY = -(DockableFrameMouseInputAdapter._startingBounds.height - min.height);
                } else if (DockableFrameMouseInputAdapter._startingBounds.height + deltaY > max.height) {
                    deltaY = max.height - DockableFrameMouseInputAdapter._startingBounds.height;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y - deltaY < 0) {
                    deltaY = DockableFrameMouseInputAdapter._startingBounds.y;
                }
                newX = DockableFrameMouseInputAdapter._startingBounds.x;
                newY = DockableFrameMouseInputAdapter._startingBounds.y - deltaY;
                newW = DockableFrameMouseInputAdapter._startingBounds.width;
                newH = DockableFrameMouseInputAdapter._startingBounds.height + deltaY;
                break;
            }
            case 2: {
                if (DockableFrameMouseInputAdapter._startingBounds.height + deltaY < min.height) {
                    deltaY = -(DockableFrameMouseInputAdapter._startingBounds.height - min.height);
                } else if (DockableFrameMouseInputAdapter._startingBounds.height + deltaY > max.height) {
                    deltaY = max.height - DockableFrameMouseInputAdapter._startingBounds.height;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y - deltaY < 0) {
                    deltaY = DockableFrameMouseInputAdapter._startingBounds.y;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.width - deltaX < min.width) {
                    deltaX = DockableFrameMouseInputAdapter._startingBounds.width - min.width;
                } else if (DockableFrameMouseInputAdapter._startingBounds.width - deltaX > max.width) {
                    deltaX = -(max.width - DockableFrameMouseInputAdapter._startingBounds.width);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - deltaX > parentBounds.width) {
                    deltaX = DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - parentBounds.width;
                }
                newX = DockableFrameMouseInputAdapter._startingBounds.x;
                newY = DockableFrameMouseInputAdapter._startingBounds.y - deltaY;
                newW = DockableFrameMouseInputAdapter._startingBounds.width - deltaX;
                newH = DockableFrameMouseInputAdapter._startingBounds.height + deltaY;
                break;
            }
            case 3: {
                if (DockableFrameMouseInputAdapter._startingBounds.width - deltaX < min.width) {
                    deltaX = DockableFrameMouseInputAdapter._startingBounds.width - min.width;
                } else if (DockableFrameMouseInputAdapter._startingBounds.width - deltaX > max.width) {
                    deltaX = -(max.width - DockableFrameMouseInputAdapter._startingBounds.width);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - deltaX > parentBounds.width) {
                    deltaX = DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - parentBounds.width;
                }
                newW = DockableFrameMouseInputAdapter._startingBounds.width - deltaX;
                newH = DockableFrameMouseInputAdapter._startingBounds.height;
                break;
            }
            case 4: {
                if (DockableFrameMouseInputAdapter._startingBounds.width - deltaX < min.width) {
                    deltaX = DockableFrameMouseInputAdapter._startingBounds.width - min.width;
                } else if (DockableFrameMouseInputAdapter._startingBounds.width - deltaX > max.width) {
                    deltaX = -(max.width - DockableFrameMouseInputAdapter._startingBounds.width);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - deltaX > parentBounds.width) {
                    deltaX = DockableFrameMouseInputAdapter._startingBounds.x + DockableFrameMouseInputAdapter._startingBounds.width - parentBounds.width;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.height - deltaY < min.height) {
                    deltaY = DockableFrameMouseInputAdapter._startingBounds.height - min.height;
                } else if (DockableFrameMouseInputAdapter._startingBounds.height - deltaY > max.height) {
                    deltaY = -(max.height - DockableFrameMouseInputAdapter._startingBounds.height);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - deltaY > parentBounds.height) {
                    deltaY = DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - parentBounds.height;
                }
                newW = DockableFrameMouseInputAdapter._startingBounds.width - deltaX;
                newH = DockableFrameMouseInputAdapter._startingBounds.height - deltaY;
                break;
            }
            case 5: {
                if (DockableFrameMouseInputAdapter._startingBounds.height - deltaY < min.height) {
                    deltaY = DockableFrameMouseInputAdapter._startingBounds.height - min.height;
                } else if (DockableFrameMouseInputAdapter._startingBounds.height - deltaY > max.height) {
                    deltaY = -(max.height - DockableFrameMouseInputAdapter._startingBounds.height);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - deltaY > parentBounds.height) {
                    deltaY = DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - parentBounds.height;
                }
                newW = DockableFrameMouseInputAdapter._startingBounds.width;
                newH = DockableFrameMouseInputAdapter._startingBounds.height - deltaY;
                break;
            }
            case 6: {
                if (DockableFrameMouseInputAdapter._startingBounds.height - deltaY < min.height) {
                    deltaY = DockableFrameMouseInputAdapter._startingBounds.height - min.height;
                } else if (DockableFrameMouseInputAdapter._startingBounds.height - deltaY > max.height) {
                    deltaY = -(max.height - DockableFrameMouseInputAdapter._startingBounds.height);
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - deltaY > parentBounds.height) {
                    deltaY = DockableFrameMouseInputAdapter._startingBounds.y + DockableFrameMouseInputAdapter._startingBounds.height - parentBounds.height;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.width + deltaX < min.width) {
                    deltaX = -(DockableFrameMouseInputAdapter._startingBounds.width - min.width);
                } else if (DockableFrameMouseInputAdapter._startingBounds.width + deltaX > max.width) {
                    deltaX = max.width - DockableFrameMouseInputAdapter._startingBounds.width;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x - deltaX < 0) {
                    deltaX = DockableFrameMouseInputAdapter._startingBounds.x;
                }
                newX = DockableFrameMouseInputAdapter._startingBounds.x - deltaX;
                newY = DockableFrameMouseInputAdapter._startingBounds.y;
                newW = DockableFrameMouseInputAdapter._startingBounds.width + deltaX;
                newH = DockableFrameMouseInputAdapter._startingBounds.height - deltaY;
                break;
            }
            case 7: {
                if (DockableFrameMouseInputAdapter._startingBounds.width + deltaX < min.width) {
                    deltaX = -(DockableFrameMouseInputAdapter._startingBounds.width - min.width);
                } else if (DockableFrameMouseInputAdapter._startingBounds.width + deltaX > max.width) {
                    deltaX = max.width - DockableFrameMouseInputAdapter._startingBounds.width;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x - deltaX < 0) {
                    deltaX = DockableFrameMouseInputAdapter._startingBounds.x;
                }
                newX = DockableFrameMouseInputAdapter._startingBounds.x - deltaX;
                newY = DockableFrameMouseInputAdapter._startingBounds.y;
                newW = DockableFrameMouseInputAdapter._startingBounds.width + deltaX;
                newH = DockableFrameMouseInputAdapter._startingBounds.height;
                break;
            }
            case 8: {
                if (DockableFrameMouseInputAdapter._startingBounds.width + deltaX < min.width) {
                    deltaX = -(DockableFrameMouseInputAdapter._startingBounds.width - min.width);
                } else if (DockableFrameMouseInputAdapter._startingBounds.width + deltaX > max.width) {
                    deltaX = max.width - DockableFrameMouseInputAdapter._startingBounds.width;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.x - deltaX < 0) {
                    deltaX = DockableFrameMouseInputAdapter._startingBounds.x;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.height + deltaY < min.height) {
                    deltaY = -(DockableFrameMouseInputAdapter._startingBounds.height - min.height);
                } else if (DockableFrameMouseInputAdapter._startingBounds.height + deltaY > max.height) {
                    deltaY = max.height - DockableFrameMouseInputAdapter._startingBounds.height;
                }
                if (DockableFrameMouseInputAdapter._startingBounds.y - deltaY < 0) {
                    deltaY = DockableFrameMouseInputAdapter._startingBounds.y;
                }
                newX = DockableFrameMouseInputAdapter._startingBounds.x - deltaX;
                newY = DockableFrameMouseInputAdapter._startingBounds.y - deltaY;
                newW = DockableFrameMouseInputAdapter._startingBounds.width + deltaX;
                newH = DockableFrameMouseInputAdapter._startingBounds.height + deltaY;
                break;
            }
            default: {
                return;
            }
        }
        if (this._frame != null && this._frame.isAutohideShowing()) {
            Rectangle rect = this._dockingManager.getDockedFrameContainer().getBounds();
            Rectangle bounds = SwingUtilities.convertRectangle(this._dockingManager.getDockedFrameContainer().getParent(), rect, this._component.getParent());
            if (newY < bounds.y) {
                newY = bounds.y;
            }
            if (newX < bounds.x) {
                newX = bounds.x;
            }
            if (newW > bounds.width) {
                newW = bounds.width;
            }
            if (newH > bounds.height) {
                newH = bounds.height;
            }
        }
        this._dockingManager.resizingFrame(this._component, newX, newY, newW, newH);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.initDockingManager(e);
        if (this._frame == null) {
            return;
        }
        if (this._dockingManager == null) {
            JideSwingUtilities.retargetMouseEvent(e.getID(), e, this._frame);
            return;
        }
        if (this.isFrameDisabled()) {
            this._dockingManager.setActiveMouseInputListener(null);
            return;
        }
        this.dndArmedEvent = null;
        if (e.isPopupTrigger() && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this.showContextMenu(e);
        }
        _startingBounds = null;
        this._mouseOnComponent = null;
        if (this._needClearTabbedPane) {
            this._tabbedPane = null;
        }
        this._needClearTabbedPane = false;
        if (!this._dragged) {
            MouseInputListener listener = this._dockingManager.getActiveMouseInputListener();
            if (listener != this && listener != null) {
                listener.mouseReleased(e);
                return;
            }
            this._dockingManager.cancelDragging();
            this._dockingManager.setActiveMouseInputListener(null);
            return;
        }
        this.setDrag(false);
        this._dockingManager.setActiveMouseInputListener(null);
        if (this._discardRelease) {
            this._dockingManager.cancelDragging();
            this._discardRelease = false;
            return;
        }
        if (this._resizeDir == 0) {
            if (this._frame != null) {
                this._dockingManager.endDraggingFrame(this._frame);
                return;
            }
            if (this._tabbedPane != null && this.isTabPanelEvent(e)) {
                DockableFrame frame = (DockableFrame)this._tabbedPane.getSelectedComponent();
                this._dockingManager.endDraggingFrame(frame);
                this._savedTabRects = null;
                return;
            }
        } else {
            if (this._dockingManager.isUseGlassPaneEnabled()) {
                Container c = this._component.getTopLevelAncestor();
                if (c instanceof JFrame) {
                    ((JFrame)this._component.getTopLevelAncestor()).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JFrame)this._component.getTopLevelAncestor()).getGlassPane().setVisible(this._glassPaneVisibility);
                } else if (c instanceof JApplet) {
                    ((JApplet)c).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JApplet)c).getGlassPane().setVisible(this._glassPaneVisibility);
                } else if (c instanceof JWindow) {
                    ((JWindow)c).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JWindow)c).getGlassPane().setVisible(this._glassPaneVisibility);
                } else if (c instanceof JDialog) {
                    ((JDialog)c).getGlassPane().setCursor(Cursor.getDefaultCursor());
                    ((JDialog)c).getGlassPane().setVisible(this._glassPaneVisibility);
                }
                this._glassPaneVisibility = false;
            }
            this._dockingManager.endResizingFrame(this._component);
        }
        this._eventMouseScreenX = 0;
        this._eventMouseScreenY = 0;
        this._eventMouseRelativeX = 0;
        this._eventMouseRelativeY = 0;
        _startingBounds = null;
        this._resizeDir = 0;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this._frame == null || this._component == null) {
            JideSwingUtilities.retargetMouseEvent(e.getID(), e, this._frame);
            return;
        }
        if (!this._frame.isAutohideShowing()) {
            return;
        }
        if (!this._frame.isSlidingAutohide()) {
            return;
        }
        this.initDockingManager(e);
        if (!this._dockingManager.isResizable()) {
            return;
        }
        if (e.getSource() == this._component) {
            if (!(this._component.getTopLevelAncestor() instanceof FloatingContainer) && this._component instanceof DockableFrame && ((DockableFrame)this._component).isDocked()) {
                return;
            }
            if (this._component instanceof FrameContainer && !(this._component.getTopLevelAncestor() instanceof FloatingContainer)) {
                return;
            }
            if (!(!(this._component.getTopLevelAncestor() instanceof FloatingContainer) || this._component instanceof DockableFrame && ((DockableFrame)this._component).isFloated() || DockingUtils.getFrameContainerCount(this._dockingManager, ((FloatingContainer)((Object)this._component.getTopLevelAncestor())).getContentPane()) <= 1)) {
                return;
            }
            Insets i = this._component.getInsets();
            if (this._component instanceof FrameContainer) {
                if (e.getX() >= this._component.getWidth() - i.right) {
                    if (i.bottom > 0 && e.getY() > this._component.getHeight() - this.resizeCornerSize - i.bottom) {
                        this._component.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        this._component.setCursor(Cursor.getPredefinedCursor(11));
                    }
                } else if (e.getY() >= this._component.getHeight() - i.bottom) {
                    if (i.right > 0 && e.getX() > this._component.getWidth() - this.resizeCornerSize - i.right) {
                        this._component.setCursor(Cursor.getPredefinedCursor(5));
                    } else {
                        this._component.setCursor(Cursor.getPredefinedCursor(9));
                    }
                } else {
                    this._component.setCursor(null);
                }
                return;
            }
            if (e.getX() <= i.left) {
                if (i.top > 0 && e.getY() < this.resizeCornerSize + i.top) {
                    this._component.setCursor(Cursor.getPredefinedCursor(6));
                } else if (i.bottom > 0 && e.getY() > this._component.getHeight() - this.resizeCornerSize - i.bottom) {
                    this._component.setCursor(Cursor.getPredefinedCursor(4));
                } else if (this._frame != null && this._frame.isAutohideShowing()) {
                    this._component.setCursor(JideCursors.getPredefinedCursor(20));
                } else {
                    this._component.setCursor(Cursor.getPredefinedCursor(10));
                }
            } else if (e.getX() >= this._component.getWidth() - i.right) {
                if (i.top > 0 && e.getY() < this.resizeCornerSize + i.top) {
                    this._component.setCursor(Cursor.getPredefinedCursor(7));
                } else if (i.bottom > 0 && e.getY() > this._component.getHeight() - this.resizeCornerSize - i.bottom) {
                    this._component.setCursor(Cursor.getPredefinedCursor(5));
                } else if (this._frame != null && this._frame.isAutohideShowing()) {
                    this._component.setCursor(JideCursors.getPredefinedCursor(20));
                } else {
                    this._component.setCursor(Cursor.getPredefinedCursor(11));
                }
            } else if (e.getY() <= i.top) {
                if (i.left > 0 && e.getX() < this.resizeCornerSize + i.left) {
                    this._component.setCursor(Cursor.getPredefinedCursor(6));
                } else if (i.right > 0 && e.getX() > this._component.getWidth() - this.resizeCornerSize - i.right) {
                    this._component.setCursor(Cursor.getPredefinedCursor(7));
                } else if (this._frame != null && this._frame.isAutohideShowing()) {
                    this._component.setCursor(JideCursors.getPredefinedCursor(21));
                } else {
                    this._component.setCursor(Cursor.getPredefinedCursor(8));
                }
            } else if (e.getY() >= this._component.getHeight() - i.bottom) {
                if (i.left > 0 && e.getX() < this.resizeCornerSize + i.left) {
                    this._component.setCursor(Cursor.getPredefinedCursor(4));
                } else if (i.right > 0 && e.getX() > this._component.getWidth() - this.resizeCornerSize - i.right) {
                    this._component.setCursor(Cursor.getPredefinedCursor(5));
                } else if (this._frame != null && this._frame.isAutohideShowing()) {
                    this._component.setCursor(JideCursors.getPredefinedCursor(21));
                } else {
                    this._component.setCursor(Cursor.getPredefinedCursor(9));
                }
            } else {
                this._component.setCursor(null);
            }
            return;
        }
        this._component.setCursor(null);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this._frame == null) {
            return;
        }
        this.initDockingManager(e);
        this._frame.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger() && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this.showContextMenu(e);
        }
        if (this._dockingManager == null) {
            JideSwingUtilities.retargetMouseEvent(e.getID(), e, this._frame);
            return;
        }
        if (e.isPopupTrigger() && this._dockingManager.isShowContextMenu() && this._frame.isShowContextMenu()) {
            this.showContextMenu(e);
        }
        if (SwingUtilities.isLeftMouseButton(e) && this._frame != null) {
            this._frame.requestFocusInInternalWindow();
        }
        if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
            Object source = e.getSource();
            if (this._frame != null && (source == this._frame.getUI().getTitlePane() || source == this._frame.getTitleBarComponent() || source == this._frame.getTitleLabelComponent() || source instanceof Gripper)) {
                Action action;
                if (this._dockingManager.getDoubleClickAction() == 0) {
                    this._frame.getFloatingAction(!this._dockingManager.isFloatAllTabs()).actionPerformed(new ActionEvent(e.getSource(), 0, "DOUBLE_CLICK_TO_FLOAT"));
                } else if (this._dockingManager.getDoubleClickAction() == 1) {
                    this._frame.getMaximizeAction().actionPerformed(new ActionEvent(e.getSource(), 0, "DOUBLE_CLICK_TO_MAXIMIZE"));
                } else if (this._dockingManager.getDoubleClickAction() == 2) {
                    this._frame.getAutohideAction().actionPerformed(new ActionEvent(e.getSource(), 0, "DOUBLE_CLICK_TO_AUTOHIDE"));
                } else if (this._dockingManager.getDoubleClickAction() == -2 && (action = this._frame.getCustomDoubleClickAction()) != null) {
                    action.actionPerformed(new ActionEvent(e.getSource(), 0, "DOUBLE_CLICK_CUSTOM"));
                }
                return;
            }
            if (this._tabbedPane != null && this.isTabPanelEvent(e)) {
                Action action;
                Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this._tabbedPane);
                int tabIndex = this._tabbedPane.getUI().tabForCoordinate(this._tabbedPane, p.x, p.y);
                if (tabIndex >= 0 && tabIndex < this._tabbedPane.getTabCount() && !this._tabbedPane.isEnabledAt(tabIndex)) {
                    return;
                }
                DockableFrame frame = (DockableFrame)this._tabbedPane.getSelectedComponent();
                if (this._dockingManager.getDoubleClickAction() == 0) {
                    frame.getFloatingAction(!this._dockingManager.isFloatAllTabs() || tabIndex != -1).actionPerformed(new ActionEvent(e.getSource(), 0, "DOUBLE_CLICK_TO_FLOAT"));
                } else if (this._dockingManager.getDoubleClickAction() == 1) {
                    frame.getMaximizeAction().actionPerformed(new ActionEvent(e.getSource(), 0, "DOUBLE_CLICK_TO_MAXIMIZE"));
                } else if (this._dockingManager.getDoubleClickAction() == 2) {
                    frame.getAutohideAction().actionPerformed(new ActionEvent(e.getSource(), 0, "DOUBLE_CLICK_TO_AUTOHIDE"));
                } else if (this._dockingManager.getDoubleClickAction() == -2 && (action = frame.getCustomDoubleClickAction()) != null) {
                    action.actionPerformed(new ActionEvent(e.getSource(), 0, "DOUBLE_CLICK_CUSTOM"));
                }
            }
        }
    }

    private boolean isDraggingTarget(MouseEvent e) {
        return this._frame.isDraggingTarget(e);
    }

    private void showContextMenu(MouseEvent e) {
        Object source = e.getSource();
        if (this._frame != null && (source == this._frame.getUI().getTitlePane() || source == this._frame.getTitleBarComponent() || source == this._frame.getTitleLabelComponent())) {
            this._dockingManager.showContextMenu((Component)source, e.getPoint(), this._frame, false);
        } else if (this._tabbedPane != null && this.isTabPanelEvent(e)) {
            Point point = SwingUtilities.convertPoint((Component)e.getSource(), e.getPoint(), this._tabbedPane);
            int index = this._tabbedPane.getTabAtLocation(point.x, point.y);
            if (index != -1) {
                DockableFrame frameActivate = this._tabbedPane.getFrame(index);
                frameActivate.getDockingManager().activateFrame(frameActivate.getKey());
                this._dockingManager.showContextMenu((Component)e.getSource(), e.getPoint(), (DockableFrame)this._tabbedPane.getComponentAt(index), true);
            }
        }
        e.consume();
    }
}

