/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockingManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class DockID {
    private final Set<Integer> _IDs = new HashSet<Integer>();
    private static Map<DockingManager, DockID> _instances;
    private static final int SCOPE = 65535;
    public static final int MAINCONTAINER_ID = 2;
    public static final int WORKSPACE_ID = 3;

    public static synchronized DockID getInstance(DockingManager dockingManager) {
        DockID value;
        if (dockingManager == null) {
            throw new IllegalArgumentException("The docking manager cannot be null.");
        }
        if (_instances == null) {
            _instances = new HashMap<DockingManager, DockID>();
        }
        if ((value = _instances.get(dockingManager)) != null) {
            return value;
        }
        DockID dockID = new DockID();
        _instances.put(dockingManager, dockID);
        return dockID;
    }

    public static synchronized void removeInstance(DockingManager dockingManager) {
        if (_instances != null) {
            _instances.remove(dockingManager);
        }
    }

    private DockID() {
    }

    private int getRandomNumber() {
        double d;
        int result;
        while (this.isNumberUsed(result = (int)((d = Math.random()) * 65535.0))) {
        }
        return result;
    }

    private boolean isNumberUsed(int id) {
        return id == 0 || id == 1 || id == 2 || id == 3 || this._IDs.contains(id);
    }

    public int getID() {
        return this.getRandomNumber();
    }

    public int getID(int oldID) {
        this.releaseID(oldID);
        return this.getRandomNumber();
    }

    public void releaseID(int oldID) {
        this._IDs.remove(oldID);
    }

    public void releaseAll() {
        this._IDs.clear();
    }

    public void reserveID(int id) {
        if (!this._IDs.contains(id)) {
            this._IDs.add(id);
        }
    }
}

